/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.util.JBUI;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.plaf.UIResource;

public class JBInsets
extends Insets {
    public JBInsets(int top, int left, int bottom, int right) {
        super(JBUI.scale(top), JBUI.scale(left), JBUI.scale(bottom), JBUI.scale(right));
    }

    public int width() {
        return this.left + this.right;
    }

    public int height() {
        return this.top + this.bottom;
    }

    public static JBInsets create(Insets insets) {
        if (insets instanceof JBInsets) {
            JBInsets copy = new JBInsets(0, 0, 0, 0);
            copy.top = insets.top;
            copy.left = insets.left;
            copy.bottom = insets.bottom;
            copy.right = insets.right;
            return copy;
        }
        return new JBInsets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public JBInsetsUIResource asUIResource() {
        return new JBInsetsUIResource(this);
    }

    public static void addTo(Dimension dimension, Insets insets) {
        if (insets != null) {
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
        }
    }

    public static void removeFrom(Dimension dimension, Insets insets) {
        if (insets != null) {
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
        }
    }

    public static void addTo(Rectangle rectangle, Insets insets) {
        if (insets != null) {
            rectangle.x -= insets.left;
            rectangle.y -= insets.top;
            rectangle.width += insets.left + insets.right;
            rectangle.height += insets.top + insets.bottom;
        }
    }

    public static void removeFrom(Rectangle rectangle, Insets insets) {
        if (insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        }
    }

    public static class JBInsetsUIResource
    extends JBInsets
    implements UIResource {
        public JBInsetsUIResource(JBInsets insets) {
            super(0, 0, 0, 0);
            this.top = insets.top;
            this.left = insets.left;
            this.bottom = insets.bottom;
            this.right = insets.right;
        }
    }
}

