/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.swing;

import com.lm.hbase.common.ImageIconConstons;
import com.lm.hbase.swing.FrameDock;
import com.lm.hbase.swing.LoginGui;
import com.lm.hbase.swing.SwingConstants;
import com.lm.hbase.tab.CreateTab;
import com.lm.hbase.tab.MetaDataTab;
import com.lm.hbase.tab.QueryTab;
import com.lm.hbase.tab.TabInterface;
import com.lm.hbase.tab.TableInfoTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class HbaseGui {
    public JFrame parentJframe;
    public ScheduledExecutorService threadPool = Executors.newSingleThreadScheduledExecutor();
    public JProgressBar processBar;
    public JLabel stopLabel;
    public JButton switchBut;
    private List<TabInterface> tabs = new ArrayList<TabInterface>();
    public static final String DARCULA_LAF_CLASS = "com.bulenkov.darcula.DarculaLaf";

    public static void main(String[] args) throws Throwable {
        FrameDock.setDockIconImage();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(HbaseGui.DARCULA_LAF_CLASS);
                    SwingConstants.hbaseGui = new HbaseGui();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public HbaseGui() {
        LoginGui.openDialog();
    }

    public void initialize() {
        SwingConstants.parentFrameIsInit = true;
        if (this.parentJframe != null) {
            this.parentJframe.dispose();
        }
        this.parentJframe = new JFrame();
        this.parentJframe.setTitle("Hbase Gui");
        this.parentJframe.setBounds(10, 10, 1450, 800);
        this.parentJframe.setDefaultCloseOperation(3);
        this.parentJframe.getContentPane().setLayout(new BorderLayout(0, 0));
        this.parentJframe.setMinimumSize(new Dimension(1450, 400));
        this.parentJframe.setIconImage(ImageIconConstons.DOCK_ICON.getImage());
        JLabel logoLabel = new JLabel(ImageIconConstons.HBASE_LOGO_ICON);
        this.parentJframe.getContentPane().add((Component)logoLabel, "North");
        JPanel footerPanel = new JPanel();
        footerPanel.setLayout(new BorderLayout());
        this.parentJframe.getContentPane().add((Component)footerPanel, "South");
        this.processBar = new JProgressBar(0);
        this.processBar.setVisible(false);
        this.stopLabel = new JLabel(ImageIconConstons.STOP_ICON);
        this.stopLabel.setEnabled(false);
        this.stopLabel.setVisible(false);
        this.stopLabel.addMouseListener(new StopEvent());
        this.switchBut = new JButton(ImageIconConstons.SWITCH_ICON);
        this.switchBut.addMouseListener(new SwitchEvent());
        JPanel footerCenterPanel = new JPanel();
        footerCenterPanel.add(this.stopLabel);
        footerCenterPanel.add(this.processBar);
        footerPanel.add((Component)footerCenterPanel, "Center");
        footerPanel.add((Component)this.switchBut, "East");
        JTabbedPane tabbedPanel = new JTabbedPane(1);
        tabbedPanel.setBorder(new TitledBorder(null, "", 4, 2, null, null));
        this.parentJframe.getContentPane().add((Component)tabbedPanel, "Center");
        TableInfoTab tableInfoTab = new TableInfoTab(this);
        this.registerTab(tableInfoTab, tabbedPanel);
        QueryTab queryTab = new QueryTab(this);
        this.registerTab(queryTab, tabbedPanel);
        MetaDataTab metaDataTab = new MetaDataTab(this);
        this.registerTab(metaDataTab, tabbedPanel);
        CreateTab createTab = new CreateTab(this);
        this.registerTab(createTab, tabbedPanel);
        this.parentJframe.setVisible(true);
        this.parentJframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    SwingConstants.hbaseAdapter.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                super.windowClosing(e);
            }
        });
    }

    private void registerTab(TabInterface tab, JTabbedPane panel) {
        panel.addTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), tab.getTip());
        this.tabs.add(tab);
    }

    class SwitchEvent
    extends MouseAdapter {
        SwitchEvent() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            LoginGui.openDialog();
        }
    }

    class StopEvent
    extends MouseAdapter {
        StopEvent() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!HbaseGui.this.threadPool.isShutdown() || !HbaseGui.this.threadPool.isTerminated()) {
                HbaseGui.this.threadPool.shutdownNow();
                HbaseGui.this.threadPool = Executors.newSingleThreadScheduledExecutor();
            }
            HbaseGui.this.stopLabel.setEnabled(false);
            HbaseGui.this.processBar.setIndeterminate(false);
            for (TabInterface tab : HbaseGui.this.tabs) {
                tab.enableAll();
            }
        }
    }
}

