/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.conf;

import com.lm.hbase.common.Env;
import com.lm.hbase.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

public class ConfItem {
    private String confFileName;
    private Properties confProps = null;

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        String confDisplayname = this.getStringValue("display.name");
        if (StringUtil.isEmpty(confDisplayname)) {
            return this.confFileName;
        }
        return confDisplayname;
    }

    public String getConfFileName() {
        return this.confFileName;
    }

    public ConfItem(String confFileName) {
        this.confFileName = confFileName;
        this.loadProperties();
    }

    public String getConfFilePath() {
        return Env.HBASE_CONN_CONF_DIR + this.confFileName;
    }

    private Properties loadProperties() {
        this.confProps = new Properties();
        try {
            File conf = new File(this.getConfFilePath());
            if (!conf.exists()) {
                conf.createNewFile();
            }
            this.confProps.load(new InputStreamReader(new FileInputStream(conf)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.confProps;
    }

    public void reloadConf() {
        this.loadProperties();
    }

    public void setValue(String key, String value) {
        if (this.confProps == null) {
            this.loadProperties();
        }
        this.confProps.put(key, value);
        try {
            this.confProps.store(new FileOutputStream(this.getConfFilePath()), null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getStringValue(String key) {
        if (this.confProps == null) {
            return this.loadProperties().getProperty(key);
        }
        return this.confProps.getProperty(key);
    }

    public Integer getIntegerValue(String key) {
        return Integer.parseInt(this.getStringValue(key));
    }

    public Long getLongValue(String key) {
        return Long.parseLong(this.getStringValue(key));
    }

    public Boolean getBooleanValue(String key) {
        return Boolean.parseBoolean(this.getStringValue(key));
    }

    public void setConf(String displayName, String zkPort, String zkQuorum, String hbaseMaster, String znodeParent, String version, String mavenHome) {
        if (this.confProps == null) {
            this.loadProperties();
        }
        this.confProps.put("display.name", displayName);
        this.confProps.put("hbase.zk.port", zkPort);
        this.confProps.put("hbase.zk.quorum", zkQuorum);
        this.confProps.put("hbase.master", hbaseMaster);
        this.confProps.put("znode.parent", znodeParent);
        this.confProps.put("hbase.version", version);
        this.confProps.put("maven.home", mavenHome);
        try {
            this.confProps.store(new FileOutputStream(this.getConfFilePath()), null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void remove(String key) {
        if (this.confProps == null) {
            this.loadProperties();
        }
        this.confProps.remove(key);
        try {
            this.confProps.store(new FileOutputStream(this.getConfFilePath()), null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

