/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.tab;

import com.lm.hbase.swing.SwingConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class TabCommonUtil {
    public void initTableList(JList<String> list) throws Exception {
        String[] tableNames = SwingConstants.hbaseAdapter.getListTableNames();
        if (tableNames != null) {
            list.setListData((String[])tableNames);
        }
    }

    public void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    public void resizeTable(boolean bool, JTable contentTable, JScrollPane tableScroll) {
        Dimension containerwidth = null;
        containerwidth = !bool ? tableScroll.getPreferredSize() : tableScroll.getSize();
        int allwidth = contentTable.getIntercellSpacing().width;
        int j = 0;
        while (j < contentTable.getColumnCount()) {
            int max = 0;
            int i = 0;
            while (i < contentTable.getRowCount()) {
                int width = contentTable.getCellRenderer((int)i, (int)j).getTableCellRendererComponent((JTable)contentTable, (Object)contentTable.getValueAt((int)i, (int)j), (boolean)false, (boolean)false, (int)i, (int)j).getPreferredSize().width;
                if (width > max) {
                    max = width;
                }
                ++i;
            }
            int headerwidth = contentTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)contentTable, (Object)contentTable.getColumnModel().getColumn((int)j).getIdentifier(), (boolean)false, (boolean)false, (int)-1, (int)j).getPreferredSize().width;
            contentTable.getColumnModel().getColumn(j).setPreferredWidth(max += headerwidth);
            allwidth += max + contentTable.getIntercellSpacing().width;
            ++j;
        }
        if ((allwidth += contentTable.getIntercellSpacing().width) > containerwidth.width) {
            contentTable.setAutoResizeMode(0);
        } else {
            contentTable.setAutoResizeMode(2);
        }
    }
}

