/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.adapter;

import com.lm.hbase.adapter.ColumnFamily;
import com.lm.hbase.adapter.entity.QualifierValue;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;

public class Row {
    private LinkedHashMap<byte[], ColumnFamily> columnFamilys = new LinkedHashMap();
    private String rowKey;

    public Row(String rowKey) {
        this.rowKey = rowKey;
    }

    public void add(byte[] columnFamilyName, byte[] qualifier, QualifierValue value) {
        ColumnFamily columnFamily = this.columnFamilys.get(columnFamilyName);
        if (columnFamily == null) {
            columnFamily = new ColumnFamily(columnFamilyName);
            columnFamily.add(qualifier, value);
            this.columnFamilys.put(columnFamilyName, columnFamily);
        } else {
            columnFamily.add(qualifier, value);
            this.columnFamilys.put(columnFamilyName, columnFamily);
        }
    }

    public String getRowKey() {
        return this.rowKey;
    }

    public ColumnFamily getColumnFamily(byte[] columnFamilyName) {
        return this.columnFamilys.get(columnFamilyName);
    }

    public LinkedHashMap<byte[], ColumnFamily> getColumnFamilys() {
        return this.columnFamilys;
    }

    public String toString() {
        StringBuilder rowString = new StringBuilder("RowKey:" + this.rowKey + "\n");
        for (Map.Entry<byte[], ColumnFamily> entry : this.columnFamilys.entrySet()) {
            rowString.append("ColumnFamilyName:" + new String(entry.getKey(), 0, entry.getKey().length, Charset.forName("UTF-8")) + ">" + entry.getValue().toString() + "\n");
        }
        rowString.append("<======================================>");
        return rowString.toString();
    }
}

