/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.tab;

import com.lm.hbase.adapter.entity.ColumnFamilyDescriptor;
import com.lm.hbase.adapter.entity.ColumnFamilyDescriptorEnum;
import com.lm.hbase.adapter.entity.TableDescriptor;
import com.lm.hbase.common.ImageIconConstons;
import com.lm.hbase.swing.HbaseGui;
import com.lm.hbase.swing.SwingConstants;
import com.lm.hbase.tab.TabAbstract;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TableInfoTab
extends TabAbstract {
    private JList<String> list = null;
    private JButton refreshTableButton;
    private JPanel descPanel;
    private TableDescriptor tableDescriptor;
    private JLabel tableNameLabel;
    private JComboBox<String> cfComboBox;
    private JTextField bloomfilterTextField;
    private JTextField inMemoryTextField;
    private JTextField versionsTextField;
    private JTextField minVersionsTextField;
    private JTextField keepDeletedCellsTextField;
    private JTextField dataBlockEncodingTextField;
    private JTextField ttlTextField;
    private JTextField compressionTextField;
    private JTextField blockcacheField;
    private JTextField replicationScopeTextField;
    private JTextArea hDescTextArea;

    public TableInfoTab(HbaseGui window) {
        super(window);
    }

    @Override
    public String getTitle() {
        return "\u8868\u8be6\u60c5";
    }

    @Override
    public void enableAll() {
        this.list.setEnabled(true);
        this.refreshTableButton.setEnabled(true);
    }

    @Override
    public void disableAll() {
        this.list.setEnabled(false);
        this.refreshTableButton.setEnabled(false);
    }

    @Override
    public JPanel initializePanel() {
        JPanel parentPanel = new JPanel();
        parentPanel.setLayout(new BorderLayout(0, 0));
        JPanel tableListPanel = new JPanel();
        tableListPanel.setBorder(new EtchedBorder(1, null, null));
        tableListPanel.setLayout(new BorderLayout(1, 1));
        this.refreshTableButton = new JButton("\u5237\u65b0", ImageIconConstons.UPDATE_ICON);
        tableListPanel.add((Component)this.refreshTableButton, "North");
        this.list = new JList();
        this.list.setFixedCellHeight(20);
        this.list.getSelectionModel().setSelectionMode(0);
        JScrollPane jlistScroll = new JScrollPane(this.list);
        jlistScroll.setBorder(new TitledBorder("TABLES"));
        jlistScroll.setLayout(new ScrollPaneLayout());
        tableListPanel.add(jlistScroll);
        parentPanel.add((Component)tableListPanel, "West");
        JPanel contentPanel = new JPanel(new BorderLayout());
        parentPanel.add((Component)contentPanel, "Center");
        this.descPanel = new JPanel();
        this.descPanel.setBorder(new TitledBorder("Descriptor"));
        contentPanel.add((Component)this.descPanel, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        this.descPanel.setLayout(new GridBagLayout());
        this.tableNameLabel = new JLabel();
        this.cfComboBox = new JComboBox();
        JPanel headPanel = new JPanel();
        headPanel.setBorder(new TitledBorder("Familys"));
        headPanel.add(this.tableNameLabel);
        headPanel.add(this.cfComboBox);
        contentPanel.add((Component)headPanel, "North");
        JLabel label = new JLabel("BLOOMFILTER");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)label, gbc);
        this.bloomfilterTextField = new JTextField(28);
        JPanel componentPanel = new JPanel();
        componentPanel.add(this.bloomfilterTextField);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)componentPanel, gbc);
        label = new JLabel("IN_MEMORY");
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)label, gbc);
        this.inMemoryTextField = new JTextField(28);
        componentPanel = new JPanel();
        componentPanel.add(this.inMemoryTextField);
        gbc.gridx = 8;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)componentPanel, gbc);
        label = new JLabel("VERSIONS");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)label, gbc);
        this.versionsTextField = new JTextField(28);
        componentPanel = new JPanel();
        componentPanel.add(this.versionsTextField);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)componentPanel, gbc);
        label = new JLabel("MIN_VERSIONS");
        gbc.gridx = 6;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)label, gbc);
        this.minVersionsTextField = new JTextField(28);
        componentPanel = new JPanel();
        componentPanel.add(this.minVersionsTextField);
        gbc.gridx = 8;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)componentPanel, gbc);
        label = new JLabel("KEEP_DELETED_CELLS");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)label, gbc);
        this.keepDeletedCellsTextField = new JTextField(28);
        componentPanel = new JPanel();
        componentPanel.add(this.keepDeletedCellsTextField);
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)componentPanel, gbc);
        label = new JLabel("DATA_BLOCK_ENCODING");
        gbc.gridx = 6;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)label, gbc);
        this.dataBlockEncodingTextField = new JTextField(28);
        componentPanel = new JPanel();
        componentPanel.add(this.dataBlockEncodingTextField);
        gbc.gridx = 8;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)componentPanel, gbc);
        label = new JLabel("TTL");
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)label, gbc);
        this.ttlTextField = new JTextField(28);
        componentPanel = new JPanel();
        componentPanel.add(this.ttlTextField);
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)componentPanel, gbc);
        label = new JLabel("COMPRESSION");
        gbc.gridx = 6;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)label, gbc);
        this.compressionTextField = new JTextField(28);
        componentPanel = new JPanel();
        componentPanel.add(this.compressionTextField);
        gbc.gridx = 8;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)componentPanel, gbc);
        label = new JLabel("BLOCKSIZE");
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)label, gbc);
        this.blockcacheField = new JTextField(28);
        componentPanel = new JPanel();
        componentPanel.add(this.blockcacheField);
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)componentPanel, gbc);
        label = new JLabel("REPLICATION_SCOPE");
        gbc.gridx = 6;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)label, gbc);
        this.replicationScopeTextField = new JTextField(28);
        componentPanel = new JPanel();
        componentPanel.add(this.replicationScopeTextField);
        gbc.gridx = 8;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)componentPanel, gbc);
        this.hDescTextArea = new JTextArea();
        this.hDescTextArea.setRows(10);
        this.hDescTextArea.setLineWrap(true);
        this.hDescTextArea.setWrapStyleWord(true);
        componentPanel = new JPanel(new GridLayout(1, 1));
        componentPanel.add(new JScrollPane(this.hDescTextArea));
        contentPanel.add((Component)componentPanel, "South");
        this.refreshTableButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TableInfoTab.this.refreshTableButton.setEnabled(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TableInfoTab.this.getSingleThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        TableInfoTab.this.startTask();
                        try {
                            TableInfoTab.this.initTableList(TableInfoTab.this.list);
                        }
                        catch (Exception e) {
                            TableInfoTab.this.exceptionAlert(e);
                            return;
                        }
                        TableInfoTab.this.stopTask();
                    }
                });
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TableInfoTab.this.getSingleThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            TableInfoTab.this.startTask();
                            try {
                                TableDescriptor tableDescriptor = SwingConstants.hbaseAdapter.getTableDescriptor((String)TableInfoTab.this.list.getSelectedValue());
                                TableInfoTab.this.cleanAll();
                                TableInfoTab.this.tableDescriptor = tableDescriptor;
                                TableInfoTab.this.render();
                            }
                            catch (Exception e) {
                                TableInfoTab.this.exceptionAlert(e);
                                return;
                            }
                            TableInfoTab.this.stopTask();
                        }
                    });
                }
            }
        });
        this.cfComboBox.addItemListener(new CfComboBoxItemListener());
        try {
            this.initTableList(this.list);
        }
        catch (Exception e) {
            this.exceptionAlert(e);
        }
        return parentPanel;
    }

    private void cleanAll() {
        this.tableDescriptor = null;
        this.cfComboBox.removeAllItems();
        this.tableNameLabel.setText("");
        this.bloomfilterTextField.setText("");
        this.inMemoryTextField.setText("");
        this.versionsTextField.setText("");
        this.minVersionsTextField.setText("");
        this.keepDeletedCellsTextField.setText("");
        this.dataBlockEncodingTextField.setText("");
        this.ttlTextField.setText("");
        this.compressionTextField.setText("");
        this.blockcacheField.setText("");
        this.replicationScopeTextField.setText("");
        this.hDescTextArea.setText("");
    }

    private void render() {
        this.tableNameLabel.setText(this.tableDescriptor.getTableName());
        this.hDescTextArea.setText(this.tableDescriptor.toString());
        for (ColumnFamilyDescriptor item : this.tableDescriptor.getCfDesc()) {
            this.cfComboBox.addItem((String)item.getDefaultDesc().get(ColumnFamilyDescriptorEnum.NAME));
        }
    }

    class CfComboBoxItemListener
    implements ItemListener {
        CfComboBoxItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (TableInfoTab.this.tableDescriptor == null) {
                    return;
                }
                String selectedItem = TableInfoTab.this.cfComboBox.getSelectedItem().toString();
                for (ColumnFamilyDescriptor cfItem : TableInfoTab.this.tableDescriptor.getCfDesc()) {
                    Map descMap = cfItem.getDefaultDesc();
                    String name = (String)descMap.get(ColumnFamilyDescriptorEnum.NAME);
                    if (!name.equalsIgnoreCase(selectedItem)) continue;
                    TableInfoTab.this.descPanel.setBorder(new TitledBorder("Descriptor:" + name));
                    TableInfoTab.this.bloomfilterTextField.setText((String)descMap.get(ColumnFamilyDescriptorEnum.BLOOMFILTER));
                    TableInfoTab.this.inMemoryTextField.setText((String)descMap.get(ColumnFamilyDescriptorEnum.IN_MEMORY));
                    TableInfoTab.this.versionsTextField.setText((String)descMap.get(ColumnFamilyDescriptorEnum.VERSIONS));
                    TableInfoTab.this.minVersionsTextField.setText((String)descMap.get(ColumnFamilyDescriptorEnum.MIN_VERSIONS));
                    TableInfoTab.this.keepDeletedCellsTextField.setText((String)descMap.get(ColumnFamilyDescriptorEnum.KEEP_DELETED_CELLS));
                    TableInfoTab.this.dataBlockEncodingTextField.setText((String)descMap.get(ColumnFamilyDescriptorEnum.DATA_BLOCK_ENCODING));
                    TableInfoTab.this.ttlTextField.setText((String)descMap.get(ColumnFamilyDescriptorEnum.TTL));
                    TableInfoTab.this.compressionTextField.setText((String)descMap.get(ColumnFamilyDescriptorEnum.COMPRESSION));
                    TableInfoTab.this.blockcacheField.setText((String)descMap.get(ColumnFamilyDescriptorEnum.BLOCKCACHE));
                    TableInfoTab.this.replicationScopeTextField.setText((String)descMap.get(ColumnFamilyDescriptorEnum.REPLICATION_SCOPE));
                    break;
                }
            }
        }
    }
}

