/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.darcula.ui.DarculaButtonUI;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.Gray;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarculaButtonPainter
implements Border,
UIResource {
    private static final int myOffset = 4;

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        Insets ins = this.getBorderInsets(c);
        int yOff = (ins.top + ins.bottom) / 4;
        boolean square = DarculaButtonUI.isSquare(c);
        int offset = square ? 1 : this.getOffset();
        int scaleFactor = DarculaUIUtil.getScaleFactor();
        offset *= scaleFactor;
        if (c.hasFocus()) {
            DarculaUIUtil.paintFocusRing(g2d, offset, yOff, width - 2 * offset, height - 2 * yOff);
        } else {
            GraphicsConfig config = new GraphicsConfig(g);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            g2d.setPaint(new GradientPaint(width / 2, y + yOff + 1, Gray._80.withAlpha(90), width / 2, height - 2 * yOff, Gray._90.withAlpha(90)));
            ((Graphics2D)g).setPaint(Gray._100.withAlpha(180));
            g.drawRoundRect(x + offset, y + yOff, width - 2 * offset, height - 2 * yOff, square ? 3 : 5, square ? 3 : 5);
            config.restore();
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int scaleFactor = DarculaUIUtil.getScaleFactor();
        if (DarculaButtonUI.isSquare(c)) {
            return new InsetsUIResource(2 * scaleFactor, 0, 2 * scaleFactor, 0);
        }
        return new InsetsUIResource(8 * scaleFactor, 16 * scaleFactor, 8 * scaleFactor, 14 * scaleFactor);
    }

    protected int getOffset() {
        return 4;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

