/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.driver;

import com.lm.hbase.common.Env;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public final class DriverClassLoader {
    private static Method addURL = DriverClassLoader.initAddMethod();
    private static URLClassLoader classloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
    private static boolean isLoad = false;

    public static void loadClasspath(String version) {
        if (isLoad) {
            System.gc();
        }
        isLoad = true;
        List<File> files = DriverClassLoader.getJarFiles(version);
        for (File f : files) {
            DriverClassLoader.loadClasspath(f);
        }
    }

    private static Method initAddMethod() {
        try {
            Method add = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            add.setAccessible(true);
            return add;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void loadClasspath(File jarFile) {
        DriverClassLoader.loopFiles(jarFile);
    }

    private static void loopFiles(File file) {
        if (file.isDirectory()) {
            File[] tmps;
            for (File tmp : tmps = file.listFiles()) {
                DriverClassLoader.loopFiles(tmp);
            }
        } else if (file.getAbsolutePath().endsWith(".jar") || file.getAbsolutePath().endsWith(".zip")) {
            System.out.println("load jar:" + file.getName());
            DriverClassLoader.addURL(file);
        }
    }

    private static void addURL(File file) {
        try {
            addURL.invoke((Object)classloader, file.toURI().toURL());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static List<File> getJarFiles(String version) {
        ArrayList<File> files = new ArrayList<File>();
        File lib = new File(Env.DRIVER_DIR + version);
        System.out.println(lib.getPath());
        DriverClassLoader.loopFiles(lib, files);
        return files;
    }

    private static final void loopFiles(File file, List<File> files) {
        if (file.isDirectory()) {
            File[] tmps;
            for (File tmp : tmps = file.listFiles()) {
                DriverClassLoader.loopFiles(tmp, files);
            }
        } else if (file.getAbsolutePath().endsWith(".jar") || file.getAbsolutePath().endsWith(".zip")) {
            files.add(file);
        }
    }
}

