/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.util;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class Chooser
extends JPanel {
    private static final long serialVersionUID = -5384012731547358720L;
    private Calendar calendar;
    private Calendar now = Calendar.getInstance();
    private JPanel calendarPanel;
    private Font font = new Font("Times", 0, 12);
    private SimpleDateFormat sdf;
    private final LabelManager lm = new LabelManager();
    private Popup pop;
    private TitlePanel titlePanel;
    private BodyPanel bodyPanel;
    private FooterPanel footerPanel;
    private JComponent showDate;
    private boolean isShow = false;
    public static final String DEFAULTFORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String[] showTEXT = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static WeekLabel[] weekLabels = new WeekLabel[7];
    private static int defaultStartDAY = 0;
    private static Color hoverColor = Color.BLUE;

    private Chooser(Date date, String format, int startDAY) {
        if (startDAY > -1 && startDAY < 7) {
            defaultStartDAY = startDAY;
        }
        int dayIndex = defaultStartDAY;
        for (int i = 0; i < 7; ++i) {
            if (dayIndex > 6) {
                dayIndex = 0;
            }
            Chooser.weekLabels[i] = new WeekLabel(dayIndex, showTEXT[dayIndex]);
            ++dayIndex;
        }
        this.sdf = new SimpleDateFormat(format);
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(date);
        this.initCalendarPanel();
    }

    public static Chooser getInstance(Date date, String format) {
        return new Chooser(date, format, defaultStartDAY);
    }

    public static Chooser getInstance(Date date) {
        return Chooser.getInstance(date, DEFAULTFORMAT);
    }

    public static Chooser getInstance(String format) {
        return Chooser.getInstance(new Date(), format);
    }

    public static Chooser getInstance() {
        return Chooser.getInstance(new Date(), DEFAULTFORMAT);
    }

    private void initCalendarPanel() {
        this.calendarPanel = new JPanel(new BorderLayout());
        this.calendarPanel.setBorder(BorderFactory.createLineBorder(new Color(170, 170, 170)));
        this.titlePanel = new TitlePanel();
        this.calendarPanel.add((Component)this.titlePanel, "North");
        this.bodyPanel = new BodyPanel();
        this.calendarPanel.add((Component)this.bodyPanel, "Center");
        this.footerPanel = new FooterPanel();
        this.calendarPanel.add((Component)this.footerPanel, "South");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                Chooser.this.hidePanel();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                Chooser.this.hidePanel();
            }
        });
    }

    public void register(final JComponent showComponent) {
        this.showDate = showComponent;
        showComponent.setRequestFocusEnabled(true);
        showComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                showComponent.requestFocusInWindow();
            }
        });
        this.add((Component)showComponent, "Center");
        this.setPreferredSize(new Dimension(90, 25));
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        showComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                if (showComponent.isEnabled()) {
                    showComponent.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent me) {
                if (showComponent.isEnabled()) {
                    showComponent.setCursor(new Cursor(0));
                    showComponent.setForeground(Color.BLACK);
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
                if (showComponent.isEnabled()) {
                    showComponent.setForeground(hoverColor);
                    if (Chooser.this.isShow) {
                        Chooser.this.hidePanel();
                    } else {
                        Chooser.this.showPanel(showComponent);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (showComponent.isEnabled()) {
                    showComponent.setForeground(Color.BLACK);
                }
            }
        });
        showComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                Chooser.this.hidePanel();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void hidePanel() {
        if (this.pop != null) {
            this.isShow = false;
            this.pop.hide();
            this.pop = null;
        }
    }

    private void showPanel(Component owner) {
        if (this.pop != null) {
            this.pop.hide();
        }
        Point show = new Point(0, this.showDate.getHeight());
        SwingUtilities.convertPointToScreen(show, this.showDate);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int x = show.x;
        int y = show.y;
        if (x < 0) {
            x = 0;
        }
        if (x > size.width - 212) {
            x = size.width - 212;
        }
        if (y > size.height - 167) {
            y -= 165;
        }
        this.pop = PopupFactory.getSharedInstance().getPopup(owner, this.calendarPanel, x, y);
        this.pop.show();
        this.isShow = true;
    }

    private void commit() {
        if (this.showDate instanceof JTextField) {
            ((JTextField)this.showDate).setText(this.sdf.format(this.calendar.getTime()));
        } else if (this.showDate instanceof JLabel) {
            ((JLabel)this.showDate).setText(this.sdf.format(this.calendar.getTime()));
        }
        this.hidePanel();
    }

    private void refresh() {
        this.titlePanel.updateDate();
        this.bodyPanel.updateDate();
        this.footerPanel.updateDate();
        SwingUtilities.updateComponentTreeUI(this);
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame("Date Picker Test");
        jf.setDefaultCloseOperation(3);
        jf.setLayout(null);
        jf.setBounds(400, 200, 600, 400);
        Chooser ser = Chooser.getInstance();
        JTextField text = new JTextField();
        text.setBounds(10, 10, 200, 30);
        text.setText("2013-10-11");
        ser.register(text);
        Chooser ser2 = Chooser.getInstance("yyyy\u5e74MM\u6708dd\u65e5");
        JLabel label = new JLabel("please click me.");
        label.setBounds(10, 50, 200, 30);
        ser2.register(label);
        jf.add(text);
        jf.add(label);
        jf.setVisible(true);
    }

    private class LabelManager {
        private List<DayLabel> list = new ArrayList<DayLabel>();

        public List<DayLabel> getLabels() {
            return this.list;
        }

        public void addLabel(DayLabel label) {
            this.list.add(label);
        }

        public void clear() {
            this.list.clear();
        }

        public void setSelect(Point p, boolean b) {
            if (b) {
                boolean findPrevious = false;
                boolean findNext = false;
                for (DayLabel lab : this.list) {
                    if (lab.contains(p)) {
                        findNext = true;
                        if (lab.getIsSelected()) {
                            findPrevious = true;
                        } else {
                            lab.setSelected(true, b);
                        }
                    } else if (lab.getIsSelected()) {
                        findPrevious = true;
                        lab.setSelected(false, b);
                    }
                    if (!findPrevious || !findNext) continue;
                    return;
                }
            } else {
                DayLabel temp = null;
                for (DayLabel m : this.list) {
                    if (m.contains(p)) {
                        temp = m;
                        continue;
                    }
                    if (!m.getIsSelected()) continue;
                    m.setSelected(false, b);
                }
                if (temp != null) {
                    temp.setSelected(true, b);
                }
            }
        }
    }

    private class DayLabel
    extends JLabel
    implements Comparator<DayLabel>,
    MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = -6002103678554799020L;
        private boolean isSelected;
        private int year;
        private int month;
        private int day;

        public DayLabel(Calendar cal) {
            super("" + cal.get(5), 0);
            this.year = cal.get(1);
            this.month = cal.get(2);
            this.day = cal.get(5);
            this.setFont(Chooser.this.font);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            if (this.month == Chooser.this.calendar.get(2)) {
                this.setForeground(Color.BLACK);
            } else {
                this.setForeground(Color.LIGHT_GRAY);
            }
        }

        public boolean getIsSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean b, boolean isDrag) {
            this.isSelected = b;
            if (b && !isDrag) {
                int temp = Chooser.this.calendar.get(2);
                Chooser.this.calendar.set(this.year, this.month, this.day);
                if (temp == this.month) {
                    SwingUtilities.updateComponentTreeUI(Chooser.this.bodyPanel);
                } else {
                    Chooser.this.refresh();
                }
                this.repaint();
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.day == Chooser.this.calendar.get(5) && this.month == Chooser.this.calendar.get(2)) {
                g.setColor(new Color(187, 191, 218));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.year == Chooser.this.now.get(1) && this.month == Chooser.this.now.get(2) && this.day == Chooser.this.now.get(5)) {
                Graphics2D gd = (Graphics2D)g;
                gd.setColor(new Color(85, 85, 136));
                Polygon p = new Polygon();
                p.addPoint(0, 0);
                p.addPoint(this.getWidth() - 1, 0);
                p.addPoint(this.getWidth() - 1, this.getHeight() - 1);
                p.addPoint(0, this.getHeight() - 1);
                gd.drawPolygon(p);
            }
            if (this.isSelected) {
                BasicStroke s = new BasicStroke(1.0f, 2, 2, 1.0f, new float[]{2.0f, 2.0f}, 1.0f);
                Graphics2D gd = (Graphics2D)g;
                gd.setStroke(s);
                gd.setColor(Color.BLACK);
                Polygon p = new Polygon();
                p.addPoint(0, 0);
                p.addPoint(this.getWidth() - 1, 0);
                p.addPoint(this.getWidth() - 1, this.getHeight() - 1);
                p.addPoint(0, this.getHeight() - 1);
                gd.drawPolygon(p);
            }
            super.paintComponent(g);
        }

        @Override
        public boolean contains(Point p) {
            return this.getBounds().contains(p);
        }

        private void update() {
            this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.isSelected = true;
            this.update();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Point p = SwingUtilities.convertPoint(this, e.getPoint(), Chooser.this.bodyPanel);
            this.setForeground(Color.BLACK);
            Chooser.this.lm.setSelect(p, false);
            Chooser.this.commit();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setForeground(hoverColor);
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.month == Chooser.this.calendar.get(2)) {
                this.setForeground(Color.BLACK);
            } else {
                this.setForeground(Color.LIGHT_GRAY);
            }
            this.repaint();
        }

        @Override
        public int compare(DayLabel o1, DayLabel o2) {
            Calendar c1 = Calendar.getInstance();
            c1.set(o1.year, o1.month, o1.day);
            Calendar c2 = Calendar.getInstance();
            c2.set(o2.year, o2.month, o2.day);
            return c1.compareTo(c2);
        }
    }

    private class WeekLabel
    extends JLabel {
        private static final long serialVersionUID = -8053965084432740110L;
        private String name;

        public WeekLabel(int index, String name) {
            super(name, 0);
            this.name = name;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private class FooterPanel
    extends JPanel {
        private static final long serialVersionUID = 8135037333899746736L;
        private JLabel dateLabel;

        public FooterPanel() {
            super(new BorderLayout());
            this.initFooterPanel();
        }

        private void initFooterPanel() {
            this.dateLabel = new JLabel("Today is : " + Chooser.this.sdf.format(new Date()));
            this.dateLabel.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    Chooser.this.calendar.setTime(new Date());
                    Chooser.this.refresh();
                    Chooser.this.commit();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    FooterPanel.this.dateLabel.setForeground(Color.BLACK);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    FooterPanel.this.dateLabel.setCursor(new Cursor(12));
                    FooterPanel.this.dateLabel.setForeground(hoverColor);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
            this.add(this.dateLabel);
        }

        public void updateDate() {
        }
    }

    private class BodyPanel
    extends JPanel {
        private static final long serialVersionUID = 5677718768457235447L;

        public BodyPanel() {
            super(new GridLayout(7, 7));
            this.setPreferredSize(new Dimension(210, 140));
            this.initMonthPanel();
        }

        private void initMonthPanel() {
            this.updateDate();
        }

        public void updateDate() {
            this.removeAll();
            Chooser.this.lm.clear();
            Date temp = Chooser.this.calendar.getTime();
            Calendar cal = Calendar.getInstance();
            cal.setTime(temp);
            cal.set(5, 1);
            int index = cal.get(7);
            if (index > defaultStartDAY) {
                cal.add(5, -index + defaultStartDAY);
            } else {
                cal.add(5, -index + defaultStartDAY - 7);
            }
            for (WeekLabel weekLabel : weekLabels) {
                this.add(weekLabel);
            }
            for (int i = 0; i < 42; ++i) {
                cal.add(5, 1);
                Chooser.this.lm.addLabel(new DayLabel(cal));
            }
            for (DayLabel my : Chooser.this.lm.getLabels()) {
                this.add(my);
            }
        }
    }

    private class TitlePanel
    extends JPanel {
        private static final long serialVersionUID = -2865282186037420798L;
        private JLabel preYear;
        private JLabel preMonth;
        private JLabel center;
        private JLabel nextMonth;
        private JLabel nextYear;
        private JLabel centercontainer;

        public TitlePanel() {
            super(new BorderLayout());
            this.setBackground(new Color(190, 200, 200));
            this.initTitlePanel();
        }

        private void initTitlePanel() {
            this.preYear = new JLabel("<<", 0);
            this.preMonth = new JLabel("<", 0);
            this.center = new JLabel("", 0);
            this.centercontainer = new JLabel("", 0);
            this.nextMonth = new JLabel(">", 0);
            this.nextYear = new JLabel(">>", 0);
            this.preYear.setToolTipText("Last Year");
            this.preMonth.setToolTipText("Last Month");
            this.nextMonth.setToolTipText("Next Month");
            this.nextYear.setToolTipText("Next Year");
            this.preYear.setBorder(BorderFactory.createEmptyBorder(2, 10, 0, 0));
            this.preMonth.setBorder(BorderFactory.createEmptyBorder(2, 15, 0, 0));
            this.nextMonth.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 15));
            this.nextYear.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 10));
            this.centercontainer.setLayout(new BorderLayout());
            this.centercontainer.add((Component)this.preMonth, "West");
            this.centercontainer.add((Component)this.center, "Center");
            this.centercontainer.add((Component)this.nextMonth, "East");
            this.add((Component)this.preYear, "West");
            this.add((Component)this.centercontainer, "Center");
            this.add((Component)this.nextYear, "East");
            this.setPreferredSize(new Dimension(210, 25));
            this.updateDate();
            this.preYear.addMouseListener(new MyMouseAdapter(this.preYear, 1, -1));
            this.preMonth.addMouseListener(new MyMouseAdapter(this.preMonth, 2, -1));
            this.nextMonth.addMouseListener(new MyMouseAdapter(this.nextMonth, 2, 1));
            this.nextYear.addMouseListener(new MyMouseAdapter(this.nextYear, 1, 1));
        }

        private void updateDate() {
            this.center.setText(Chooser.this.calendar.get(1) + "-" + (Chooser.this.calendar.get(2) + 1));
        }

        class MyMouseAdapter
        extends MouseAdapter {
            JLabel label;
            private int type;
            private int value;

            public MyMouseAdapter(JLabel label, int type, int value) {
                this.label = label;
                this.type = type;
                this.value = value;
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                this.label.setCursor(new Cursor(12));
                this.label.setForeground(hoverColor);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                this.label.setCursor(new Cursor(0));
                this.label.setForeground(Color.BLACK);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                Chooser.this.calendar.add(this.type, this.value);
                this.label.setForeground(Color.WHITE);
                Chooser.this.refresh();
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                this.label.setForeground(Color.BLACK);
            }
        }
    }
}

