/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.driver;

import com.lm.hbase.common.Env;
import com.lm.hbase.util.network.HttpURLConnectionFactory;
import java.io.File;
import java.net.HttpURLConnection;
import java.util.Collections;
import javax.swing.JLabel;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

public class DownloadDriver {
    private static final String ALIYUN_TAG = "aliyun-";

    private static boolean isAliyun(String version) {
        boolean isAliyun = version.startsWith(ALIYUN_TAG);
        return isAliyun;
    }

    private static String getPomUrl(String version) {
        if (DownloadDriver.isAliyun(version)) {
            String aliyunVersion = version.replace(ALIYUN_TAG, "");
            StringBuilder url = new StringBuilder("https://maven.aliyun.com/repository/central/com/aliyun/hbase/alihbase-client");
            url.append("/" + aliyunVersion + "/");
            url.append("alihbase-client-");
            url.append(aliyunVersion);
            url.append(".pom");
            return url.toString();
        }
        StringBuilder url = new StringBuilder("https://maven.aliyun.com/repository/central/org/apache/hbase/hbase-client");
        url.append("/" + version + "/");
        url.append("hbase-client-");
        url.append(version);
        url.append(".pom");
        return url.toString();
    }

    private static String getJarUrl(String version) {
        if (DownloadDriver.isAliyun(version)) {
            String aliyunVersion = version.replace(ALIYUN_TAG, "");
            StringBuilder url = new StringBuilder("https://maven.aliyun.com/repository/central/com/aliyun/hbase/alihbase-client");
            url.append("/" + aliyunVersion + "/");
            url.append("alihbase-client-");
            url.append(aliyunVersion);
            url.append(".jar");
            return url.toString();
        }
        StringBuilder url = new StringBuilder("https://maven.aliyun.com/repository/central/org/apache/hbase/hbase-client");
        url.append("/" + version + "/");
        url.append("hbase-client-");
        url.append(version);
        url.append(".jar");
        return url.toString();
    }

    public static boolean load(String version, String mavenHome, JLabel progressInfoLabel) throws Throwable {
        String outputDir = Env.DRIVER_DIR + version;
        File outputFileDir = new File(outputDir);
        if (outputFileDir.exists()) {
            return true;
        }
        outputFileDir.mkdir();
        progressInfoLabel.setText("\u6b63\u5728\u4e0b\u8f7dpom\u6587\u4ef6 ...");
        System.out.println("download file:" + DownloadDriver.getPomUrl(version));
        HttpURLConnection con = HttpURLConnectionFactory.getConn(DownloadDriver.getPomUrl(version));
        HttpURLConnectionFactory.downloadFile(con, outputDir, "pom.xml");
        progressInfoLabel.setText("\u6b63\u5728\u4e0b\u8f7dhbase-client-" + version + ".jar ...");
        System.out.println("download file:" + DownloadDriver.getJarUrl(version));
        con = HttpURLConnectionFactory.getConn(DownloadDriver.getJarUrl(version));
        HttpURLConnectionFactory.downloadFile(con, outputDir, "hbase-client-" + version + ".jar");
        File pomFile = new File(outputDir);
        StringBuilder cmd = new StringBuilder("dependency:copy-dependencies -DoutputDirectory=");
        cmd.append(outputDir);
        progressInfoLabel.setText("\u6b63\u5728\u4e0b\u8f7dhbase-client\u4f9d\u8d56 ...");
        boolean result = DownloadDriver.executeMavenCmd(cmd.toString(), pomFile, mavenHome);
        if (result) {
            progressInfoLabel.setText("hbase-client\u4f9d\u8d56\u4e0b\u8f7d\u6210\u529f");
        } else {
            progressInfoLabel.setText("hbase-client\u4f9d\u8d56\u4e0b\u8f7d\u5931\u8d25");
        }
        return result;
    }

    public static boolean executeMavenCmd(String cmd, File pomFile, String mavenHome) {
        System.out.println("download dependency jar." + cmd);
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(pomFile);
        request.setGoals(Collections.singletonList(cmd));
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(mavenHome));
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() == 0) {
                System.out.println("download dependency jar success");
                return true;
            }
        }
        catch (MavenInvocationException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }
}

