/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.swing;

import com.lm.hbase.adapter.ColumnFamily;
import com.lm.hbase.adapter.Row;
import com.lm.hbase.adapter.entity.HBasePageModel;
import com.lm.hbase.adapter.entity.QualifierValue;
import com.lm.hbase.swing.SwingConstants;
import com.lm.hbase.swing.component.ComboBoxTable;
import com.lm.hbase.swing.component.ComboBoxTableUtil;
import com.lm.hbase.util.MyBytesUtil;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class HandleCore {
    private static final String NUMBER = "Number";
    private static final String ROW_KEY = "RowKey";
    private static final String SPLIT_MARK = ".";

    public static String testConf(String displayName, String zkPort, String zkQuorum, String hbaseMaster, String znodeParent, String version, String mavenHome) throws Exception {
        SwingConstants.hbaseAdapter.init(zkPort, zkQuorum, hbaseMaster, znodeParent);
        if (SwingConstants.selectedConf == null) {
            throw new Exception("\u8bf7\u70b9\u51fb\u5de6\u4fa7\u7684\u6dfb\u52a0\u6309\u94ae\uff0c\u6dfb\u52a0\u4e00\u4e2a\u914d\u7f6e");
        }
        SwingConstants.selectedConf.setConf(displayName, zkPort, zkQuorum, hbaseMaster, znodeParent, version, mavenHome);
        String clusterStatus = SwingConstants.hbaseAdapter.getClusterStatus();
        return clusterStatus;
    }

    public static void reloadTableFormat(String tableName, JTable table, HBasePageModel dataModel) {
        LinkedHashSet<String> columnNameSet = new LinkedHashSet<String>();
        columnNameSet.add(NUMBER);
        columnNameSet.add(ROW_KEY);
        LinkedHashMap dataMap = new LinkedHashMap();
        dataMap.put(NUMBER, new LinkedHashMap());
        dataMap.put(ROW_KEY, new LinkedHashMap());
        for (int i = 0; i < dataModel.getRowList().size(); ++i) {
            Row row = (Row)dataModel.getRowList().get(i);
            String rowKey = row.getRowKey();
            ((Map)dataMap.get(NUMBER)).put(rowKey, String.valueOf(i + 1));
            ((Map)dataMap.get(ROW_KEY)).put(rowKey, rowKey);
            Set columnSet = row.getColumnFamilys().entrySet();
            Iterator iterator = columnSet.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                for (Map.Entry column : ((ColumnFamily)entry.getValue()).getColumns().entrySet()) {
                    String tableHead = ((ColumnFamily)entry.getValue()).getFamilyName() + SPLIT_MARK + MyBytesUtil.byteToString((byte[])column.getKey(), 0, ((byte[])column.getKey()).length);
                    columnNameSet.add(tableHead);
                    LinkedHashMap<String, String> columnMap = (LinkedHashMap<String, String>)dataMap.get(tableHead);
                    if (columnMap == null) {
                        columnMap = new LinkedHashMap<String, String>();
                        columnMap.put(rowKey, ((QualifierValue)column.getValue()).getDisplayValue());
                    } else {
                        columnMap.put(rowKey, ((QualifierValue)column.getValue()).getDisplayValue());
                    }
                    dataMap.put(tableHead, columnMap);
                }
            }
        }
        Object[][] rowData = new String[dataModel.getRowList().size()][columnNameSet.size() + 2];
        Map rowKeyMap = (Map)dataMap.get(ROW_KEY);
        int rowIndex = 0;
        for (String rowKey : rowKeyMap.keySet()) {
            String[] columnDataList = new String[columnNameSet.size() + 2];
            int index = 0;
            for (String columnKey : columnNameSet) {
                columnDataList[index] = (String)((Map)dataMap.get(columnKey)).get(rowKey);
                ++index;
            }
            rowData[rowIndex] = columnDataList;
            ++rowIndex;
        }
        DefaultTableModel tableModel = (DefaultTableModel)table.getModel();
        tableModel.setDataVector(rowData, columnNameSet.toArray());
        table.setModel(tableModel);
        int rowCount = table.getRowCount();
        table.getSelectionModel().setSelectionInterval(rowCount - 1, rowCount - 1);
        Rectangle rect = table.getCellRect(rowCount - 1, 0, true);
        table.scrollRectToVisible(rect);
    }

    private static void metaTableModelApply(ComboBoxTable table, Object[][] rowData) {
        DefaultTableModel tableModel = (DefaultTableModel)table.getModel();
        tableModel.setDataVector(rowData, new String[]{"Column", "Type"});
        table.setModel(tableModel);
        table.getColumnModel().getColumn(1).setCellEditor(new ComboBoxTable.CustomComboBoxEditor());
        table.getColumnModel().getColumn(1).setCellRenderer(new ComboBoxTable.ComboxRenderer());
        int rowCount = table.getRowCount();
        table.getSelectionModel().setSelectionInterval(rowCount - 1, rowCount - 1);
        Rectangle rect = table.getCellRect(rowCount - 1, 0, true);
        table.scrollRectToVisible(rect);
    }

    public static void reloadMetaTableFormat(ComboBoxTable table, Map<String, String> metaMap) {
        Object[][] rowData = new Object[metaMap.size()][2];
        int index = 0;
        for (Map.Entry<String, String> entry : metaMap.entrySet()) {
            rowData[index][0] = entry.getKey();
            rowData[index][1] = ComboBoxTableUtil.getJTabComboBoxOptions(entry.getValue());
            ++index;
        }
        HandleCore.metaTableModelApply(table, rowData);
    }

    public static void reloadMetaTableFormat(String tableName, ComboBoxTable table) throws Exception {
        HBasePageModel dataModel = new HBasePageModel(1, tableName);
        dataModel = SwingConstants.hbaseAdapter.scanResultByPageFilter(tableName, null, null, null, Integer.MAX_VALUE, dataModel, true, null);
        LinkedHashSet<String> columnNameSet = new LinkedHashSet<String>();
        LinkedHashMap dataMap = new LinkedHashMap();
        dataMap.put(NUMBER, new LinkedHashMap());
        dataMap.put(ROW_KEY, new LinkedHashMap());
        for (int i = 0; i < dataModel.getRowList().size(); ++i) {
            Row row = (Row)dataModel.getRowList().get(i);
            String rowKey = row.getRowKey();
            Set columnSet = row.getColumnFamilys().entrySet();
            for (Map.Entry entry : columnSet) {
                for (Map.Entry column : ((ColumnFamily)entry.getValue()).getColumns().entrySet()) {
                    String tableHead = ((ColumnFamily)entry.getValue()).getFamilyName() + SPLIT_MARK + MyBytesUtil.byteToString((byte[])column.getKey(), 0, ((byte[])column.getKey()).length);
                    columnNameSet.add(tableHead);
                    LinkedHashMap<String, String> columnMap = (LinkedHashMap<String, String>)dataMap.get(tableHead);
                    if (columnMap == null) {
                        columnMap = new LinkedHashMap<String, String>();
                        columnMap.put(rowKey, ((QualifierValue)column.getValue()).getDisplayValue());
                    } else {
                        columnMap.put(rowKey, ((QualifierValue)column.getValue()).getDisplayValue());
                    }
                    dataMap.put(tableHead, columnMap);
                }
            }
        }
        Object[][] rowData = new Object[columnNameSet.size()][2];
        int index = 0;
        for (String columnKey : columnNameSet) {
            rowData[index][0] = columnKey;
            rowData[index][1] = ComboBoxTableUtil.getDefaultJTabComboBoxOptions();
            ++index;
        }
        HandleCore.metaTableModelApply(table, rowData);
    }

    public static void setPageInfomation(HBasePageModel dataModel, JLabel jlabel) {
        if (dataModel == null) {
            jlabel.setText("");
            return;
        }
        StringBuilder info = new StringBuilder();
        info.append("\u7b2c" + dataModel.getPageIndex() + "\u9875  ");
        info.append(dataModel.getPageSize() + "\u6761/\u9875  ");
        info.append("\u8017\u65f6\uff1a" + dataModel.getTimeIntervalBySecond());
        jlabel.setText(info.toString());
    }

    public static void cleanPageInfomation(JLabel jlabel) {
        jlabel.setText("");
    }
}

