/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.swing;

import com.lm.hbase.adapter.FilterFactoryInterface;
import com.lm.hbase.adapter.HbaseAdapterInterface;
import com.lm.hbase.common.Env;
import com.lm.hbase.common.ImageIconConstons;
import com.lm.hbase.conf.ConfItem;
import com.lm.hbase.conf.RemoteDriverProp;
import com.lm.hbase.driver.DownloadDriver;
import com.lm.hbase.swing.HandleCore;
import com.lm.hbase.swing.SwingConstants;
import com.lm.hbase.util.DirectoryUtil;
import com.lm.hbase.util.StringUtil;
import com.lm.hbase.util.network.HttpURLConnectionFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.xeustechnologies.jcl.JarClassLoader;
import org.xeustechnologies.jcl.JclObjectFactory;

public class LoginGui
extends JDialog {
    private static final long serialVersionUID = 7686127697988572348L;
    public ScheduledExecutorService threadPool = Executors.newSingleThreadScheduledExecutor();
    private JPanel confsPanel = new JPanel();
    private JList<ConfItem> confsList = new JList();
    private JButton addConfBut = new JButton(ImageIconConstons.ADD_ICON);
    private JButton removeConfBut = new JButton(ImageIconConstons.GARBAGE_ICON);
    private JPanel contentPanel = new JPanel();
    private JTextField confNameField;
    private JTextField zkPortField;
    private JTextField zkQuorumField;
    private JTextField hbaseMasterField;
    private JTextField znodeParentField;
    private JTextField mavenHomeField;
    private JButton testButton = new JButton("Test");
    private JButton cancelButton = new JButton("Close");
    private JButton okButton = new JButton("Connect");
    private JButton reloadDriverVersionButton = new JButton(ImageIconConstons.UPDATE_ICON);
    private JComboBox<String> driverVersionComboBox;
    public JLabel progressInfoLabel = new JLabel("\u8bf7\u5728\u5de6\u4fa7\u9009\u62e9\u914d\u7f6e");
    public JProgressBar processBar = new JProgressBar();
    public JLabel stopLabel = new JLabel(ImageIconConstons.STOP_ICON);

    public static void openDialog() {
        try {
            if (SwingConstants.loginGui == null) {
                SwingConstants.loginGui = new LoginGui();
            }
            SwingConstants.loginGui.setDefaultCloseOperation(2);
            SwingConstants.loginGui.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(SwingConstants.hbaseGui.parentJframe, e, "\u5f02\u5e38", 0);
        }
    }

    public LoginGui() {
        this.setTitle("\u914d\u7f6eHbase");
        int width = 800;
        int height = 360;
        this.setBounds(100, 100, width, height);
        this.setMinimumSize(new Dimension(width, height));
        this.setLocationRelativeTo(null);
        JSplitPane parentSplitPanel = new JSplitPane(1);
        this.getContentPane().add(parentSplitPanel);
        parentSplitPanel.setLeftComponent(this.confsPanel);
        this.confsPanel.setLayout(new BorderLayout());
        this.confsList.setBorder(new TitledBorder("\u914d\u7f6e\u5217\u8868"));
        this.confsList.setFixedCellWidth(150);
        this.confsList.getSelectionModel().setSelectionMode(0);
        List<ConfItem> confs = this.getConfItems();
        this.confsList.setListData((ConfItem[])this.getConfItems().toArray(new ConfItem[confs.size()]));
        this.confsList.addListSelectionListener(new ConfListListener());
        JScrollPane jlistScroll = new JScrollPane(this.confsList);
        jlistScroll.setLayout(new ScrollPaneLayout());
        this.confsPanel.add((Component)jlistScroll, "Center");
        JPanel modifyConfPanel = new JPanel();
        this.confsPanel.add((Component)modifyConfPanel, "South");
        this.addConfBut.addMouseListener(new AddConfAdapter());
        this.removeConfBut.addMouseListener(new DeleteConfAdapter());
        modifyConfPanel.add(this.addConfBut);
        modifyConfPanel.add(this.removeConfBut);
        parentSplitPanel.setRightComponent(this.contentPanel);
        this.contentPanel.setLayout(new FlowLayout());
        JPanel formPanel = new JPanel();
        this.contentPanel.add(formPanel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        formPanel.setLayout(new GridBagLayout());
        JLabel lblNewLabel = new JLabel("\u914d\u7f6e\u540d\u79f0");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)lblNewLabel, gbc);
        this.confNameField = new JTextField(32);
        JPanel componentPanel = new JPanel();
        componentPanel.add(this.confNameField);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)componentPanel, gbc);
        lblNewLabel = new JLabel("ZK.PORT");
        lblNewLabel.setToolTipText("hbase.zookeeper.property.clientPort");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)lblNewLabel, gbc);
        this.zkPortField = new JTextField(32);
        componentPanel = new JPanel();
        componentPanel.add(this.zkPortField);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)componentPanel, gbc);
        JLabel lblNewLabel_1 = new JLabel("ZK.QUORUM");
        lblNewLabel_1.setToolTipText("hbase.zookeeper.quorum");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)lblNewLabel_1, gbc);
        this.zkQuorumField = new JTextField(32);
        componentPanel = new JPanel();
        componentPanel.add(this.zkQuorumField);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)componentPanel, gbc);
        JLabel lblNewLabel_2 = new JLabel("HBASE.MASTER");
        lblNewLabel_2.setToolTipText("hbase.master");
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)lblNewLabel_2, gbc);
        this.hbaseMasterField = new JTextField(32);
        componentPanel = new JPanel();
        componentPanel.add(this.hbaseMasterField);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)componentPanel, gbc);
        JLabel lblNewLabel_3 = new JLabel("ZNODE.PARENT");
        lblNewLabel_3.setToolTipText("zookeeper.znode.parent");
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)lblNewLabel_3, gbc);
        this.znodeParentField = new JTextField(32);
        componentPanel = new JPanel();
        componentPanel.add(this.znodeParentField);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)componentPanel, gbc);
        JLabel lblNewLabel_4 = new JLabel("Maven Home");
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)lblNewLabel_4, gbc);
        this.mavenHomeField = new JTextField(32);
        componentPanel = new JPanel();
        componentPanel.add(this.mavenHomeField);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)componentPanel, gbc);
        lblNewLabel_4 = new JLabel("Hbase Version");
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)lblNewLabel_4, gbc);
        this.driverVersionComboBox = new JComboBox();
        Dimension dimension = this.driverVersionComboBox.getPreferredSize();
        dimension.setSize((double)width * 0.5, dimension.getHeight());
        this.driverVersionComboBox.setPreferredSize(dimension);
        this.driverVersionComboBox.addItem("");
        for (String item : RemoteDriverProp.getKeys()) {
            this.driverVersionComboBox.addItem(item);
        }
        this.driverVersionComboBox.addItemListener(new VersionListener());
        this.reloadDriverVersionButton.addMouseListener(new ReloadVersion());
        JPanel versionPanel = new JPanel();
        versionPanel.add(this.driverVersionComboBox);
        versionPanel.add(this.reloadDriverVersionButton);
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)versionPanel, gbc);
        this.testButton.setEnabled(false);
        this.testButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LoginGui.this.testButton.setEnabled(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!LoginGui.this.checkConnectParam(LoginGui.this.zkPortField.getText(), LoginGui.this.zkQuorumField.getText(), LoginGui.this.hbaseMasterField.getText(), LoginGui.this.znodeParentField.getText(), LoginGui.this.driverVersionComboBox.getSelectedItem().toString(), LoginGui.this.mavenHomeField.getText())) {
                    LoginGui.this.testButton.setEnabled(true);
                    return;
                }
                LoginGui.this.startTask();
                LoginGui.this.threadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String clusterStatus = HandleCore.testConf(LoginGui.this.confNameField.getText(), LoginGui.this.zkPortField.getText(), LoginGui.this.zkQuorumField.getText(), LoginGui.this.hbaseMasterField.getText(), LoginGui.this.znodeParentField.getText(), LoginGui.this.driverVersionComboBox.getSelectedItem().toString(), LoginGui.this.mavenHomeField.getText());
                            if (clusterStatus != null) {
                                System.out.println(SwingConstants.hbaseAdapter.getVersion());
                                JOptionPane.showMessageDialog(LoginGui.this.contentPanel, "\u8fde\u63a5\u6210\u529f,\u96c6\u7fa4\u4fe1\u606f\u5982\u4e0b\n" + clusterStatus, "\u63d0\u793a", 1);
                            } else {
                                JOptionPane.showMessageDialog(LoginGui.this.contentPanel, "\u8fde\u63a5\u5931\u8d25", "\u9519\u8bef", 0);
                            }
                        }
                        catch (Exception e2) {
                            JOptionPane.showMessageDialog(LoginGui.this.contentPanel, "\u8fde\u63a5\u5931\u8d25.\n" + e2.getLocalizedMessage(), "\u9519\u8bef", 0);
                        }
                        finally {
                            LoginGui.this.endTask();
                        }
                    }
                });
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)this.testButton, gbc);
        this.cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingConstants.parentFrameIsInit) {
                    SwingConstants.loginGui.setVisible(false);
                } else {
                    System.exit(0);
                }
            }
        });
        this.cancelButton.setActionCommand("Cancel");
        gbc.gridx = 2;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)this.cancelButton, gbc);
        this.okButton.setEnabled(false);
        this.okButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LoginGui.this.okButton.setEnabled(false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseReleased(MouseEvent e) {
                LoginGui loginGui = SwingConstants.loginGui;
                synchronized (loginGui) {
                    if (!SwingConstants.loginGui.isVisible()) {
                        return;
                    }
                    if (!LoginGui.this.checkConnectParam(LoginGui.this.zkPortField.getText(), LoginGui.this.zkQuorumField.getText(), LoginGui.this.hbaseMasterField.getText(), LoginGui.this.znodeParentField.getText(), LoginGui.this.driverVersionComboBox.getSelectedItem().toString(), LoginGui.this.mavenHomeField.getText())) {
                        LoginGui.this.okButton.setEnabled(true);
                        return;
                    }
                    LoginGui.this.startTask();
                    LoginGui.this.threadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String clusterStatus = HandleCore.testConf(LoginGui.this.confNameField.getText(), LoginGui.this.zkPortField.getText(), LoginGui.this.zkQuorumField.getText(), LoginGui.this.hbaseMasterField.getText(), LoginGui.this.znodeParentField.getText(), LoginGui.this.driverVersionComboBox.getSelectedItem().toString(), LoginGui.this.mavenHomeField.getText());
                                if (clusterStatus != null) {
                                    SwingConstants.loginGui.setVisible(false);
                                    SwingConstants.hbaseGui.initialize();
                                } else {
                                    JOptionPane.showMessageDialog(LoginGui.this.contentPanel, "\u8fde\u63a5\u5931\u8d25", "\u9519\u8bef", 0);
                                }
                            }
                            catch (Exception e2) {
                                JOptionPane.showMessageDialog(LoginGui.this.contentPanel, "\u8fde\u63a5\u5931\u8d25.\n" + e2.getLocalizedMessage(), "\u9519\u8bef", 0);
                            }
                            finally {
                                LoginGui.this.endTask();
                            }
                        }
                    });
                }
            }
        });
        this.okButton.setActionCommand("OK");
        gbc.gridx = 3;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)this.okButton, gbc);
        this.getRootPane().setDefaultButton(this.okButton);
        JPanel processPanel = new JPanel();
        processPanel.setLayout(new FlowLayout(0));
        this.stopLabel.addMouseListener(new StopEvent());
        this.stopLabel.setEnabled(false);
        this.stopLabel.setVisible(false);
        this.processBar.setIndeterminate(false);
        this.processBar.setVisible(false);
        processPanel.add(this.stopLabel);
        processPanel.add(this.processBar);
        processPanel.add(this.progressInfoLabel);
        processPanel.add(new JLabel(" "));
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        formPanel.add((Component)processPanel, gbc);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (SwingConstants.parentFrameIsInit) {
                    SwingConstants.loginGui.setVisible(false);
                } else {
                    super.windowClosed(e);
                    System.exit(0);
                }
            }
        });
    }

    public void asyncLoadDriver(final String version, final boolean reload) {
        this.startTask();
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    LoginGui.this.loadDriver(version, reload);
                    LoginGui.this.testButton.setEnabled(true);
                    LoginGui.this.okButton.setEnabled(true);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(SwingConstants.hbaseGui.parentJframe, e, "\u5f02\u5e38", 0);
                }
                finally {
                    LoginGui.this.endTask();
                }
            }
        });
    }

    public void loadDriver(String version, boolean reload) {
        if (StringUtil.isEmpty(version)) {
            return;
        }
        JarClassLoader jcl = SwingConstants.driverMap.get(version);
        if (!reload && jcl != null) {
            this.loadCore(jcl);
            return;
        }
        String outputDir = Env.DRIVER_DIR + version;
        File outputFileDir = new File(outputDir);
        if (!outputFileDir.exists()) {
            try {
                String mavenHome;
                String string = mavenHome = this.mavenHomeField == null ? null : this.mavenHomeField.getText();
                if (StringUtil.isEmpty(mavenHome) && SwingConstants.selectedConf != null) {
                    mavenHome = SwingConstants.selectedConf.getStringValue("maven.home");
                }
                if (StringUtil.isEmpty(mavenHome)) {
                    JOptionPane.showMessageDialog(this, "\u8bf7\u8bbe\u7f6eMavenHome", "\u9519\u8bef", 0);
                    return;
                }
                DownloadDriver.load(version, mavenHome, this.progressInfoLabel);
            }
            catch (Throwable e1) {
                JOptionPane.showMessageDialog(SwingConstants.hbaseGui.parentJframe, e1, "\u5f02\u5e38", 0);
            }
            try {
                this.progressInfoLabel.setText("\u6b63\u5728\u4e0b\u8f7d\u9002\u914d\u5668Jar\u5305 ....");
                this.loadHbaseAdapterJar(version);
                this.progressInfoLabel.setText("\u9002\u914d\u5668Jar\u5305\u4e0b\u8f7d\u5b8c\u6210");
            }
            catch (Throwable e) {
                JOptionPane.showMessageDialog(SwingConstants.hbaseGui.parentJframe, e, "\u5f02\u5e38", 0);
            }
        } else if (reload) {
            DirectoryUtil.delFolder(outputDir);
            SwingConstants.driverMap.put(version, null);
            this.loadDriver(version, false);
        }
        this.progressInfoLabel.setText("Jar\u5305\u52a0\u8f7d\u4e2d ....");
        jcl = new JarClassLoader();
        jcl.add(Env.DRIVER_DIR + version + "/");
        SwingConstants.driverMap.put(version, jcl);
        SwingConstants.version = version;
        this.progressInfoLabel.setText("\u5df2\u52a0\u8f7d" + version + "\u7248\u672c\u6240\u9700\u7684\u6240\u6709Jar\u5305");
        this.loadCore(jcl);
    }

    public void loadCore(JarClassLoader jcl) {
        JclObjectFactory factory = JclObjectFactory.getInstance();
        SwingConstants.hbaseAdapter = (HbaseAdapterInterface)factory.create(jcl, "com.lm.hbase.adapter.HbaseAdapter");
        SwingConstants.filterFactory = (FilterFactoryInterface)factory.create(jcl, "com.lm.hbase.adapter.FilterFactory");
    }

    public void loadHbaseAdapterJar(String version) throws Throwable {
        System.out.print("download adapter jar ....");
        String url = RemoteDriverProp.getStringValue(version);
        String outputDir = Env.DRIVER_DIR + version;
        HttpURLConnection con = HttpURLConnectionFactory.getConn(url);
        HttpURLConnectionFactory.downloadFile(con, outputDir, "hbaes-core-adapter-" + version + ".jar");
        System.out.println("ok");
    }

    public boolean checkConnectParam(String zkPort, String zkQuorum, String hbaseMaster, String znodeParent, String version, String mavenHome) {
        if (StringUtil.isEmpty(zkPort)) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u8bbe\u7f6ezkPort", "\u9519\u8bef", 0);
            return false;
        }
        if (StringUtil.isEmpty(zkQuorum)) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u8bbe\u7f6ezkQuorum", "\u9519\u8bef", 0);
            return false;
        }
        if (StringUtil.isEmpty(znodeParent)) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u8bbe\u7f6eznodeParent", "\u9519\u8bef", 0);
            return false;
        }
        if (StringUtil.isEmpty(version)) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u8bbe\u7f6ehbaseVersion", "\u9519\u8bef", 0);
            return false;
        }
        if (StringUtil.isEmpty(mavenHome)) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u8bbe\u7f6emavenHome", "\u9519\u8bef", 0);
            return false;
        }
        return true;
    }

    private void endTask() {
        this.addConfBut.setEnabled(true);
        this.removeConfBut.setEnabled(true);
        this.reloadDriverVersionButton.setEnabled(true);
        this.testButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
        this.okButton.setEnabled(true);
        this.processBar.setIndeterminate(false);
        this.stopLabel.setEnabled(false);
        this.processBar.setVisible(false);
        this.stopLabel.setVisible(false);
    }

    private void startTask() {
        this.addConfBut.setEnabled(false);
        this.removeConfBut.setEnabled(false);
        this.reloadDriverVersionButton.setEnabled(false);
        this.testButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.okButton.setEnabled(false);
        this.processBar.setIndeterminate(true);
        this.processBar.setVisible(true);
        this.stopLabel.setEnabled(true);
        this.stopLabel.setVisible(true);
    }

    private List<ConfItem> getConfItems() {
        ArrayList<ConfItem> confList = new ArrayList<ConfItem>();
        File confDir = new File(Env.HBASE_CONN_CONF_DIR);
        if (!confDir.exists()) {
            confDir.mkdir();
        }
        for (File item : confDir.listFiles()) {
            if (!item.isFile() || !item.getName().startsWith("hbase-conf-")) continue;
            confList.add(new ConfItem(item.getName()));
        }
        return confList;
    }

    private void cleanConf() {
        this.confNameField.setText("");
        this.zkPortField.setText("");
        this.zkQuorumField.setText("");
        this.hbaseMasterField.setText("");
        this.znodeParentField.setText("");
        this.mavenHomeField.setText("");
    }

    class ConfListListener
    implements ListSelectionListener {
        ConfListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                LoginGui.this.cleanConf();
                SwingConstants.selectedConf = (ConfItem)LoginGui.this.confsList.getSelectedValue();
                if (SwingConstants.selectedConf == null) {
                    return;
                }
                String zkPort = SwingConstants.selectedConf.getStringValue("hbase.zk.port");
                String zkQuorum = SwingConstants.selectedConf.getStringValue("hbase.zk.quorum");
                String hbaseMaster = SwingConstants.selectedConf.getStringValue("hbase.master");
                String znodeParent = SwingConstants.selectedConf.getStringValue("znode.parent");
                String hbaseVersion = SwingConstants.selectedConf.getStringValue("hbase.version");
                String mavenHome = SwingConstants.selectedConf.getStringValue("maven.home");
                LoginGui.this.confNameField.setText(SwingConstants.selectedConf.getDisplayName());
                LoginGui.this.zkPortField.setText(zkPort);
                LoginGui.this.zkQuorumField.setText(zkQuorum);
                LoginGui.this.hbaseMasterField.setText(hbaseMaster);
                LoginGui.this.znodeParentField.setText(znodeParent);
                LoginGui.this.mavenHomeField.setText(mavenHome);
                for (int i = 0; i < LoginGui.this.driverVersionComboBox.getModel().getSize(); ++i) {
                    if (!((String)LoginGui.this.driverVersionComboBox.getModel().getElementAt(i)).equalsIgnoreCase(hbaseVersion)) continue;
                    LoginGui.this.driverVersionComboBox.setSelectedIndex(i);
                    LoginGui.this.asyncLoadDriver(hbaseVersion, false);
                }
                LoginGui.this.testButton.setEnabled(false);
                LoginGui.this.okButton.setEnabled(false);
            }
        }
    }

    class DeleteConfAdapter
    extends MouseAdapter {
        DeleteConfAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ConfItem conf = (ConfItem)LoginGui.this.confsList.getSelectedValue();
            File confFile = new File(conf.getConfFilePath());
            confFile.delete();
            SwingConstants.selectedConf = null;
            LoginGui.this.cleanConf();
            List confs = LoginGui.this.getConfItems();
            LoginGui.this.confsList.setListData(LoginGui.this.getConfItems().toArray(new ConfItem[confs.size()]));
            LoginGui.this.testButton.setEnabled(false);
            LoginGui.this.okButton.setEnabled(false);
        }
    }

    class AddConfAdapter
    extends MouseAdapter {
        AddConfAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            LoginGui.this.cleanConf();
            File confDir = new File(Env.HBASE_CONN_CONF_DIR);
            if (!confDir.exists()) {
                confDir.mkdir();
            }
            for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                File confFile = new File(Env.HBASE_CONN_CONF_DIR + "hbase-conf-" + i + ".conf");
                if (confFile.exists()) continue;
                try {
                    DefaultListModel<ConfItem> model = new DefaultListModel<ConfItem>();
                    for (ConfItem confs : LoginGui.this.getConfItems()) {
                        model.addElement(confs);
                    }
                    confFile.createNewFile();
                    model.addElement(new ConfItem(confFile.getName()));
                    LoginGui.this.confsList.setModel(model);
                    LoginGui.this.confsList.updateUI();
                    LoginGui.this.confsList.setSelectedIndex(model.getSize() - 1);
                    return;
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(SwingConstants.hbaseGui.parentJframe, e1, "\u5f02\u5e38", 0);
                    return;
                }
            }
        }
    }

    class StopEvent
    extends MouseAdapter {
        StopEvent() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!LoginGui.this.threadPool.isShutdown() || !LoginGui.this.threadPool.isTerminated()) {
                LoginGui.this.threadPool.shutdownNow();
                LoginGui.this.threadPool = Executors.newSingleThreadScheduledExecutor();
            }
            LoginGui.this.endTask();
        }
    }

    class ReloadVersion
    extends MouseAdapter {
        ReloadVersion() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            LoginGui.this.startTask();
            LoginGui.this.reloadDriverVersionButton.setEnabled(false);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (LoginGui.this.reloadDriverVersionButton.isEnabled()) {
                return;
            }
            if (StringUtil.isEmpty(LoginGui.this.mavenHomeField.getText())) {
                JOptionPane.showMessageDialog(LoginGui.this.contentPanel, "\u8bf7\u8bbe\u7f6eMavenHome", "\u9519\u8bef", 0);
                LoginGui.this.endTask();
                return;
            }
            String version = LoginGui.this.driverVersionComboBox.getSelectedItem().toString();
            if (StringUtil.isEmpty(version)) {
                JOptionPane.showMessageDialog(LoginGui.this.contentPanel, "\u8bf7\u8bbe\u7f6ehbaseVersion", "\u9519\u8bef", 0);
                LoginGui.this.reloadDriverVersionButton.setEnabled(true);
                LoginGui.this.endTask();
                return;
            }
            LoginGui.this.asyncLoadDriver(version, true);
        }
    }

    class VersionListener
    implements ItemListener {
        VersionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                String version = e.getItem().toString();
                LoginGui.this.asyncLoadDriver(version, false);
            }
        }
    }
}

