/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.swing.component;

import com.lm.hbase.swing.component.ComboBoxTableUtil;
import java.awt.Component;
import java.util.Locale;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ComboBoxTable
extends JTable {
    private static final long serialVersionUID = 1L;

    public static class JTabComboBoxOption
    implements Cloneable {
        private String value;
        private boolean isSelected = false;

        public JTabComboBoxOption() {
        }

        public JTabComboBoxOption(String value) {
            this.value = value;
            this.isSelected = false;
        }

        public JTabComboBoxOption(String value, boolean isSelected) {
            this.value = value;
            this.isSelected = isSelected;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public JTabComboBoxOption clone() {
            return new JTabComboBoxOption(this.value, this.isSelected);
        }
    }

    public static class ComboxRenderer
    extends JComboBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTabComboBoxOption[] options = (JTabComboBoxOption[])value;
            String[] values = new String[options.length];
            String selected = "String";
            for (int i = 0; i < options.length; ++i) {
                JTabComboBoxOption item = options[i];
                values[i] = item.getValue();
                if (!item.isSelected) continue;
                selected = item.getValue();
            }
            JComboBox<String> box = new JComboBox<String>(values);
            box.setSelectedItem(selected.toLowerCase(Locale.ROOT));
            box.setBounds(0, 0, 0, 30);
            return box;
        }
    }

    public static class CustomComboBoxEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        JComboBox<?> box;
        String[] values;

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JTabComboBoxOption[] options = (JTabComboBoxOption[])value;
            this.values = new String[options.length];
            String selected = "String";
            for (int i = 0; i < options.length; ++i) {
                JTabComboBoxOption item = options[i];
                this.values[i] = item.getValue();
                if (!item.isSelected) continue;
                selected = item.getValue();
            }
            this.box = new JComboBox<String>(this.values);
            this.box.setSelectedItem(selected.toLowerCase(Locale.ROOT));
            this.box.setBounds(0, 0, 0, 30);
            return this.box;
        }

        @Override
        public Object getCellEditorValue() {
            return ComboBoxTableUtil.getJTabComboBoxOptions((String)this.box.getSelectedItem());
        }
    }
}

