/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.tab;

import com.lm.hbase.swing.HbaseGui;
import com.lm.hbase.tab.TabCommonUtil;
import com.lm.hbase.tab.TabInterface;
import java.awt.Component;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public abstract class TabAbstract
extends TabCommonUtil
implements TabInterface {
    public static final String PROPERTIES_SUFFIX = ".MATA";
    protected HbaseGui window;

    public TabAbstract(HbaseGui window) {
        this.window = window;
    }

    public void exceptionAlert(Exception e) {
        this.stopTask();
        JOptionPane.showMessageDialog(this.window.parentJframe, e, "\u5f02\u5e38", 0);
    }

    public synchronized void startTask() {
        this.disableAll();
        this.window.processBar.setVisible(true);
        this.window.processBar.setIndeterminate(true);
        this.window.stopLabel.setVisible(true);
        this.window.stopLabel.setEnabled(true);
    }

    public synchronized void stopTask() {
        this.enableAll();
        this.window.processBar.setVisible(false);
        this.window.processBar.setIndeterminate(false);
        this.window.stopLabel.setVisible(false);
        this.window.stopLabel.setEnabled(false);
        this.window.threadPool.shutdownNow();
        this.window.threadPool = Executors.newSingleThreadScheduledExecutor();
    }

    public ScheduledExecutorService getSingleThreadPool() {
        return this.window.threadPool;
    }

    public JFrame getFrame() {
        return this.window.parentJframe;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTip() {
        return null;
    }

    @Override
    public Component getComponent() {
        return this.initializePanel();
    }

    public abstract JComponent initializePanel();
}

