/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarculaButtonUI
extends BasicButtonUI {
    private float scale = 1.0f;
    private PropertyChangeListener sizeVariantListener = evt -> {
        this.scale = DarculaUIUtil.getScale((JComponent)evt.getSource());
    };
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return new DarculaButtonUI();
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener("JComponent.sizeVariant", this.sizeVariantListener);
        this.scale = DarculaUIUtil.getScale(b);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        b.removePropertyChangeListener("JComponent.sizeVariant", this.sizeVariantListener);
        super.uninstallListeners(b);
    }

    public static boolean isSquare(Component c) {
        return c instanceof JButton && "square".equals(((JButton)c).getClientProperty("JButton.buttonType"));
    }

    public static boolean isIndeterminate(Component c) {
        return c instanceof JComponent && "indeterminate".equals(((JComponent)c).getClientProperty("JButton.selectedState"));
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        return new Dimension((int)((float)d.width * this.scale + 0.5f), (int)((float)d.height * this.scale + 0.5f));
    }

    private String layout(AbstractButton b, FontMetrics fm, int width, int height) {
        Insets i = b.getInsets();
        DarculaButtonUI.viewRect.x = i.left;
        DarculaButtonUI.viewRect.y = i.top;
        DarculaButtonUI.viewRect.width = width - (i.right + DarculaButtonUI.viewRect.x);
        DarculaButtonUI.viewRect.height = height - (i.bottom + DarculaButtonUI.viewRect.y);
        DarculaButtonUI.textRect.height = 0;
        DarculaButtonUI.textRect.width = 0;
        DarculaButtonUI.textRect.y = 0;
        DarculaButtonUI.textRect.x = 0;
        DarculaButtonUI.iconRect.height = 0;
        DarculaButtonUI.iconRect.width = 0;
        DarculaButtonUI.iconRect.y = 0;
        DarculaButtonUI.iconRect.x = 0;
        return SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.scale(this.scale, this.scale);
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Border border = c.getBorder();
        GraphicsConfig config = GraphicsUtil.setupAAPainting(g2d);
        boolean square = DarculaButtonUI.isSquare(c);
        int h = (int)((float)c.getHeight() / this.scale);
        int w = (int)((float)c.getWidth() / this.scale);
        if (c.isEnabled() && border != null && b.isContentAreaFilled()) {
            Insets ins = border.getBorderInsets(c);
            int yOff = (ins.top + ins.bottom) / 4;
            if (!square) {
                if (c instanceof JButton && ((JButton)c).isDefaultButton() || model.isSelected()) {
                    g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.getSelectedButtonColor1(), 0.0f, h, this.getSelectedButtonColor2()));
                } else {
                    g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.getButtonColor1(), 0.0f, h, this.getButtonColor2()));
                }
            }
            int scaleFactor = DarculaUIUtil.getScaleFactor();
            int x = (square ? 2 : 4) * scaleFactor;
            int width = w - 8 * scaleFactor;
            int height = h - 2 * yOff;
            int arcWidth = (square ? 3 : 5) * scaleFactor;
            int arcHeight = (square ? 3 : 5) * scaleFactor;
            g2d.fillRoundRect(x, yOff, width, height, arcWidth, arcHeight);
        }
        config.restore();
        Font f = b.getFont();
        String text = this.layout(b, SwingUtilities2.getFontMetrics((JComponent)b, f.deriveFont(f.getSize2D() * this.scale)), w, h);
        DarculaButtonUI.textRect.x = (int)((float)DarculaButtonUI.textRect.x * this.scale);
        DarculaButtonUI.textRect.y = (int)((float)DarculaButtonUI.textRect.y * this.scale);
        this.clearTextShiftOffset();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g2d, b);
        }
        if (b.getIcon() != null) {
            this.paintIcon(g2d, c, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g2d, textRect);
            } else {
                this.paintText((Graphics)g2d, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g2d, b, viewRect, textRect, iconRect);
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        Color selectedFg;
        Graphics2D g2d = (Graphics2D)g.create();
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        Color fg = button.getForeground();
        if (fg instanceof UIResource && button instanceof JButton && ((JButton)button).isDefaultButton() && (selectedFg = UIManager.getColor("Button.darcula.selectedButtonForeground")) != null) {
            fg = selectedFg;
        }
        g2d.setColor(fg);
        FontMetrics metrics = SwingUtilities2.getFontMetrics(c, g2d);
        int mnemonicIndex = button.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            SwingUtilities2.drawStringUnderlineCharAt(c, g2d, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
        } else {
            g2d.setColor(UIManager.getColor("Button.darcula.disabledText.shadow"));
            SwingUtilities2.drawStringUnderlineCharAt(c, g2d, text, -1, textRect.x + this.getTextShiftOffset() + 1, textRect.y + metrics.getAscent() + this.getTextShiftOffset() + 1);
            g2d.setColor(UIManager.getColor("Button.disabledText"));
            SwingUtilities2.drawStringUnderlineCharAt(c, g2d, text, -1, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        if (c instanceof JButton && ((JButton)c).isDefaultButton() && !SystemInfo.isMac && !c.getFont().isBold()) {
            c.setFont(c.getFont().deriveFont(1));
        }
    }

    protected Color getButtonColor1() {
        return UIManager.getColor("Button.darcula.color1");
    }

    protected Color getButtonColor2() {
        return UIManager.getColor("Button.darcula.color2");
    }

    protected Color getSelectedButtonColor1() {
        return UIManager.getColor("Button.darcula.selection.color1");
    }

    protected Color getSelectedButtonColor2() {
        return UIManager.getColor("Button.darcula.selection.color2");
    }
}

