/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.iconloader.util.ColorUtil;
import com.bulenkov.iconloader.util.EmptyIcon;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.Gray;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarculaRadioButtonUI
extends MetalRadioButtonUI {
    private float scale = 1.0f;
    private PropertyChangeListener sizeVariantListener = evt -> {
        this.scale = DarculaUIUtil.getScale((JComponent)evt.getSource());
    };

    public static ComponentUI createUI(JComponent c) {
        return new DarculaRadioButtonUI();
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener("JComponent.sizeVariant", this.sizeVariantListener);
        this.scale = DarculaUIUtil.getScale(b);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        b.removePropertyChangeListener("JComponent.sizeVariant", this.sizeVariantListener);
        super.uninstallListeners(b);
    }

    @Override
    public synchronized void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.scale(this.scale, this.scale);
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Dimension s = c.getSize();
        Dimension size = new Dimension((int)((float)s.width / this.scale), (int)((float)s.height / this.scale));
        Font f = c.getFont();
        g2d.setFont(f);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g2d, f);
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i = c.getInsets();
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (c.isOpaque()) {
            g2d.setColor(b.getBackground());
            g2d.fillRect(0, 0, size.width, size.height);
        }
        int scaleFactor = DarculaUIUtil.getScaleFactor();
        int rad = 5 * scaleFactor;
        int x = iconRect.x + (rad - 1) / 2;
        int y = iconRect.y + (rad - 1) / 2;
        int w = iconRect.width - (rad + 5 * scaleFactor) / 2;
        int h = iconRect.height - (rad + 5 * scaleFactor) / 2;
        g2d.translate(x, y);
        GraphicsConfig config = GraphicsUtil.setupAAPainting(g2d);
        boolean focus = b.hasFocus();
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, ColorUtil.shift(c.getBackground(), 1.5), 0.0f, c.getHeight(), ColorUtil.shift(c.getBackground(), 1.2)));
        if (focus) {
            g2d.fillOval(0, 1, w, h);
        } else {
            g2d.fillOval(0, 1, w - 1, h - 1);
        }
        if (focus) {
            if (UIUtil.isRetina()) {
                DarculaUIUtil.paintFocusOval(g2d, 1, 2, w - 2, h - 2);
            } else {
                DarculaUIUtil.paintFocusOval(g2d, 0, 1, w, h);
            }
        } else if (UIUtil.isUnderDarcula()) {
            g2d.setPaint(new GradientPaint(w / 2, 1.0f, Gray._160.withAlpha(90), w / 2, h, Gray._100.withAlpha(90)));
            g2d.drawOval(0, 2, w - 1, h - 1);
            g2d.setPaint(Gray._40.withAlpha(200));
            g2d.drawOval(0, 1, w - 1, h - 1);
        } else {
            g2d.setPaint(b.isEnabled() ? Gray._30 : Gray._130);
            g2d.drawOval(0, 1, w - 1, h - 1);
        }
        if (b.isSelected()) {
            boolean enabled = b.isEnabled();
            g2d.setColor(UIManager.getColor(enabled ? "RadioButton.darcula.selectionEnabledShadowColor" : "RadioButton.darcula.selectionDisabledShadowColor"));
            g2d.fillOval(w / 2 - rad / 2, h / 2 - rad / 2 + 1, rad, rad);
            g2d.setColor(UIManager.getColor(enabled ? "RadioButton.darcula.selectionEnabledColor" : "RadioButton.darcula.selectionDisabledColor"));
            g2d.fillOval(w / 2 - rad / 2, h / 2 - rad / 2, rad, rad);
        }
        config.restore();
        g2d.translate(-x, -y);
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g2d, textRect);
            } else {
                int mnemIndex = b.getDisplayedMnemonicIndex();
                if (model.isEnabled()) {
                    g2d.setColor(b.getForeground());
                } else {
                    g2d.setColor(this.getDisabledTextColor());
                }
                SwingUtilities2.drawStringUnderlineCharAt(c, g2d, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    @Override
    public Icon getDefaultIcon() {
        return new IconUIResource(EmptyIcon.create((int)(20.0f * this.scale * (float)DarculaUIUtil.getScaleFactor() + 0.5f)));
    }
}

