/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.tab;

import com.alibaba.fastjson.JSON;
import com.lm.hbase.common.ImageIconConstons;
import com.lm.hbase.swing.HandleCore;
import com.lm.hbase.swing.HbaseGui;
import com.lm.hbase.swing.SwingConstants;
import com.lm.hbase.swing.component.ComboBoxTable;
import com.lm.hbase.swing.component.ComboBoxTableUtil;
import com.lm.hbase.tab.TabAbstract;
import com.lm.hbase.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class MetaDataTab
extends TabAbstract {
    private JList<String> list;
    private ComboBoxTable contentTable;
    private JScrollPane tableScroll;
    private JButton removeMataDataBut;
    private JButton addMataDataBut;
    private JButton refreshMataDataBut;
    private JButton saveButton;
    private JButton refreshTableButton;

    public MetaDataTab(HbaseGui window) {
        super(window);
    }

    @Override
    public String getTitle() {
        return "\u5143\u6570\u636e\u7ef4\u62a4";
    }

    @Override
    public JComponent initializePanel() {
        JSplitPane panel = new JSplitPane(1);
        JPanel tableListPanel = new JPanel();
        tableListPanel.setBorder(new EtchedBorder(1, null, null));
        tableListPanel.setLayout(new BorderLayout(1, 1));
        panel.setLeftComponent(tableListPanel);
        this.list = new JList();
        this.list.setFixedCellHeight(20);
        this.list.setFixedCellWidth(250);
        this.list.getSelectionModel().setSelectionMode(0);
        JScrollPane jlistScroll = new JScrollPane(this.list);
        jlistScroll.setBorder(new TitledBorder("TABLES"));
        jlistScroll.setLayout(new ScrollPaneLayout());
        tableListPanel.add(jlistScroll);
        this.refreshTableButton = new JButton("\u5237\u65b0", ImageIconConstons.UPDATE_ICON);
        tableListPanel.add((Component)this.refreshTableButton, "North");
        JPanel southPanel = new JPanel();
        southPanel.setBorder(new EtchedBorder(1, null, null));
        southPanel.setLayout(new BorderLayout(0, 0));
        panel.setRightComponent(southPanel);
        this.contentTable = new ComboBoxTable();
        this.contentTable.setRowHeight(30);
        this.tableScroll = new JScrollPane(this.contentTable);
        this.tableScroll.setBorder(new TitledBorder("\u5143\u6570\u636e\u4fe1\u606f"));
        southPanel.add((Component)this.tableScroll, "Center");
        JPanel mataSouthPanel = new JPanel();
        mataSouthPanel.setBorder(new EtchedBorder(1, null, null));
        southPanel.add((Component)mataSouthPanel, "South");
        this.addMataDataBut = new JButton(ImageIconConstons.ADD_ICON);
        this.removeMataDataBut = new JButton(ImageIconConstons.GARBAGE_ICON);
        this.refreshMataDataBut = new JButton(ImageIconConstons.UPDATE_ICON);
        this.saveButton = new JButton("\u4fdd\u5b58\u5143\u6570\u636e", ImageIconConstons.SAVE_ICON);
        this.addMataDataBut.setEnabled(false);
        this.removeMataDataBut.setEnabled(false);
        this.refreshMataDataBut.setEnabled(false);
        this.saveButton.setEnabled(false);
        mataSouthPanel.add(this.addMataDataBut);
        mataSouthPanel.add(this.removeMataDataBut);
        mataSouthPanel.add(this.refreshMataDataBut);
        mataSouthPanel.add(this.saveButton);
        this.refreshTableButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MetaDataTab.this.refreshTableButton.setEnabled(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MetaDataTab.this.getSingleThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        MetaDataTab.this.startTask();
                        try {
                            MetaDataTab.this.initTableList(MetaDataTab.this.list);
                        }
                        catch (Exception e) {
                            MetaDataTab.this.exceptionAlert(e);
                            return;
                        }
                        MetaDataTab.this.stopTask();
                    }
                });
            }
        });
        this.contentTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MetaDataTab.this.resizeTable(true, MetaDataTab.this.contentTable, MetaDataTab.this.tableScroll);
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    MetaDataTab.this.loadMataData((String)MetaDataTab.this.list.getSelectedValue(), false);
                }
            }
        });
        this.addMataDataBut.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                DefaultTableModel tableModel = (DefaultTableModel)MetaDataTab.this.contentTable.getModel();
                tableModel.addRow(new Object[]{"<CustomField>", ComboBoxTableUtil.getDefaultJTabComboBoxOptions()});
            }
        });
        this.removeMataDataBut.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int selectedRowCount = MetaDataTab.this.contentTable.getSelectedRowCount();
                String tableName = (String)MetaDataTab.this.list.getSelectedValue();
                if (selectedRowCount > 0 || tableName != null) {
                    String[] rowkeys = new String[selectedRowCount];
                    int[] selectRowIndexs = MetaDataTab.this.contentTable.getSelectedRows();
                    for (int i = 0; i < selectedRowCount; ++i) {
                        rowkeys[i] = MetaDataTab.this.contentTable.getValueAt(selectRowIndexs[i], 1).toString();
                    }
                    DefaultTableModel model = (DefaultTableModel)MetaDataTab.this.contentTable.getModel();
                    while (MetaDataTab.this.contentTable.getSelectedRowCount() > 0) {
                        model.removeRow(MetaDataTab.this.contentTable.getSelectedRow());
                    }
                }
                MetaDataTab.this.removeMataDataBut.setEnabled(false);
            }
        });
        this.contentTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (MetaDataTab.this.contentTable.getSelectedRowCount() == 0) {
                    MetaDataTab.this.removeMataDataBut.setEnabled(false);
                } else {
                    MetaDataTab.this.removeMataDataBut.setEnabled(true);
                }
            }
        });
        this.refreshMataDataBut.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MetaDataTab.this.loadMataData((String)MetaDataTab.this.list.getSelectedValue(), true);
            }
        });
        this.saveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                TableCellEditor cellEditor;
                if (MetaDataTab.this.contentTable.isEditing() && (cellEditor = MetaDataTab.this.contentTable.getCellEditor()) != null) {
                    cellEditor.stopCellEditing();
                }
                HashMap<String, String> map = new HashMap<String, String>();
                for (int i = 0; i < MetaDataTab.this.contentTable.getRowCount(); ++i) {
                    ComboBoxTable.JTabComboBoxOption[] JTabComboBoxOptions;
                    for (ComboBoxTable.JTabComboBoxOption option : JTabComboBoxOptions = (ComboBoxTable.JTabComboBoxOption[])MetaDataTab.this.contentTable.getValueAt(i, 1)) {
                        if (!option.isSelected()) continue;
                        map.put(MetaDataTab.this.contentTable.getValueAt(i, 0).toString(), option.getValue());
                    }
                }
                String propertiesKey = (String)MetaDataTab.this.list.getSelectedValue() + ".MATA";
                SwingConstants.selectedConf.setValue(propertiesKey, JSON.toJSONString(map));
                JOptionPane.showMessageDialog(MetaDataTab.this.getFrame(), "\u4fdd\u5b58\u6210\u529f", "\u63d0\u793a", 1);
            }
        });
        try {
            this.initTableList(this.list);
        }
        catch (Exception e) {
            this.exceptionAlert(e);
        }
        return panel;
    }

    private void loadMataData(final String tableName, final boolean onlyLoadHbase) {
        this.startTask();
        this.getSingleThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                DefaultTableModel tableModel = (DefaultTableModel)MetaDataTab.this.contentTable.getModel();
                tableModel.setRowCount(0);
                String propertiesKey = (String)MetaDataTab.this.list.getSelectedValue() + ".MATA";
                String cacheMetaData = SwingConstants.selectedConf.getStringValue(propertiesKey);
                if (!StringUtil.isEmpty(cacheMetaData) && !onlyLoadHbase) {
                    HandleCore.reloadMetaTableFormat(MetaDataTab.this.contentTable, (Map)JSON.parseObject((String)cacheMetaData, Map.class));
                } else {
                    try {
                        HandleCore.reloadMetaTableFormat(tableName, MetaDataTab.this.contentTable);
                    }
                    catch (Exception e) {
                        MetaDataTab.this.exceptionAlert(e);
                        return;
                    }
                }
                MetaDataTab.this.stopTask();
            }
        });
    }

    @Override
    public void enableAll() {
        this.list.setEnabled(true);
        this.addMataDataBut.setEnabled(true);
        this.refreshMataDataBut.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.refreshTableButton.setEnabled(true);
        this.removeMataDataBut.setEnabled(true);
    }

    @Override
    public void disableAll() {
        this.list.setEnabled(false);
        this.addMataDataBut.setEnabled(false);
        this.refreshMataDataBut.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.refreshTableButton.setEnabled(false);
        this.removeMataDataBut.setEnabled(false);
    }
}

