/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.tab;

import com.lm.hbase.util.StringUtil;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

class DefaultValueTextField
extends JTextField {
    private static final long serialVersionUID = -8757598274181885964L;
    private String defaultShowText;

    public DefaultValueTextField(String defaultShowText) {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (StringUtil.isEmpty(DefaultValueTextField.this.getText())) {
                    DefaultValueTextField.this.setText(DefaultValueTextField.this.defaultShowText);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (DefaultValueTextField.this.getText() == null) {
                    DefaultValueTextField.this.setText(null);
                }
            }
        });
        this.defaultShowText = "* " + defaultShowText;
        this.setText(this.defaultShowText);
    }

    @Override
    public String getText() {
        String text = super.getText();
        if (super.getText().equalsIgnoreCase(this.defaultShowText)) {
            return null;
        }
        return text;
    }
}

