/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.util;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.security.Key;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.maven.shared.utils.StringUtils;

public class StringUtil
extends StringUtils {
    public static final String EMPTY_STRING = "";
    public static final String SYMBOL_COMMA = ",";
    public static final String SYMBOL_EQUAL = "=";
    public static final String SYMBOL_DOT = ".";
    public static final String SYMBOL_QUESTION = "?";
    public static final String SYMBOL_SEMICOLON = ";";
    public static final String SYMBOL_LEFT_BRACKETS = "(";
    public static final String SYMBOL_RIGHT_BRACKETS = ")";
    public static final String SYMBOL_AND = "&";
    public static Map<String, String> contractMappingTable = new HashMap<String, String>();

    public static boolean containEnglish(String word) {
        if (word == null) {
            return false;
        }
        for (int i = 0; i < word.length(); ++i) {
            if ((word.charAt(i) < 'A' || word.charAt(i) > 'Z') && (word.charAt(i) < 'a' || word.charAt(i) > 'z')) continue;
            return true;
        }
        return false;
    }

    public static String getNotNullValue(String word) {
        return word == null || word.equalsIgnoreCase("null") ? EMPTY_STRING : word;
    }

    public static String getNotNullValue(String word, String defaultWord) {
        return word == null || word.equalsIgnoreCase("null") ? defaultWord : word;
    }

    public static List<String> getSplitListFromString(String originWord, String symbol) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtil.isBlank((String)originWord)) {
            return result;
        }
        String[] splitData = originWord.split(symbol);
        if (splitData == null || splitData.length == 0) {
            return result;
        }
        for (String word : splitData) {
            if (!StringUtil.isNotBlank((String)word)) continue;
            result.add(word);
        }
        return result;
    }

    public static String removeLeftZero(String str) {
        int start = 0;
        if (StringUtil.isNotEmpty(str)) {
            char[] chars = str.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == '0') continue;
                start = i;
                break;
            }
            return str.substring(start);
        }
        return EMPTY_STRING;
    }

    public static boolean isNumberAndLetter(String word) {
        if (word == null) {
            return false;
        }
        for (int i = 0; i < word.length(); ++i) {
            boolean isNumber;
            boolean isLetter = word.charAt(i) >= 'A' && word.charAt(i) <= 'Z' || word.charAt(i) >= 'a' && word.charAt(i) <= 'z';
            boolean bl = isNumber = word.charAt(i) >= '0' && word.charAt(i) <= '9';
            if (isLetter || isNumber) continue;
            return false;
        }
        return true;
    }

    public static boolean isEnglishWord(String word) {
        if (word == null) {
            return false;
        }
        for (int i = 0; i < word.length(); ++i) {
            if (Character.isLetter(word.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String word) {
        if (StringUtil.isBlank((String)word)) {
            return false;
        }
        for (int i = 0; i < word.length(); ++i) {
            if (Character.isDigit(word.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getAuditStatus(String auditStatus) {
        if (StringUtil.isNotBlank((String)auditStatus) && auditStatus.indexOf("_") != -1) {
            return contractMappingTable.get(auditStatus.substring(auditStatus.indexOf("_")));
        }
        return EMPTY_STRING;
    }

    public static String formatLagerNumberToStr(Object obj, int len) {
        if (obj != null) {
            if (obj instanceof String) {
                String str = String.valueOf(obj);
                return str.substring(0, str.indexOf(SYMBOL_DOT) + len + 1);
            }
            StringBuffer pattern = new StringBuffer("0");
            for (int i = 0; i < len; ++i) {
                if (i == 0) {
                    pattern.append(".0");
                    continue;
                }
                pattern.append("0");
            }
            return new DecimalFormat(pattern.toString()).format(obj);
        }
        return EMPTY_STRING;
    }

    public static String encryptToDesHexString(Object val, String key) {
        String ret = EMPTY_STRING;
        String src = String.valueOf(val);
        if (StringUtil.isBlank((String)src) || StringUtil.isBlank((String)key)) {
            return ret;
        }
        try {
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            DESKeySpec desKeySpec = new DESKeySpec(key.getBytes("UTF-8"));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            IvParameterSpec iv = new IvParameterSpec(key.getBytes("UTF-8"));
            cipher.init(1, (Key)secretKey, iv);
            return StringUtil.toHexString(cipher.doFinal(src.getBytes("UTF-8"))).toUpperCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
    }

    public static String toHexString(byte[] src) {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < src.length; ++i) {
            String plainText = Integer.toHexString(0xFF & src[i]);
            if (plainText.length() < 2) {
                plainText = "0" + plainText;
            }
            res.append(plainText);
        }
        return res.toString();
    }

    public static String arrayToString(String[] str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int length = str.length;
        for (int i = 0; i < length; ++i) {
            sb.append(str[i]);
            if (i >= length - 1) continue;
            sb.append(SYMBOL_COMMA);
        }
        return sb.toString();
    }

    public static String ifNumToSixLength(String work_no) {
        if (work_no.length() > 5 || Character.isLetter(work_no.charAt(0))) {
            return work_no;
        }
        int len = work_no.length();
        StringBuffer res = new StringBuffer(work_no);
        for (int i = len; i < 6; ++i) {
            res.insert(0, '0');
        }
        return res.toString();
    }

    public static String cancelGroupingNumber(Double d) {
        if (d == null) {
            return EMPTY_STRING;
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        return nf.format(d);
    }

    public static String formatGroupingNumber(Double d) {
        if (d == null) {
            return EMPTY_STRING;
        }
        NumberFormat nf = NumberFormat.getInstance();
        return nf.format(d);
    }

    public static String formatGroupingNumber(String s) {
        if (StringUtil.isBlank((String)s)) {
            return EMPTY_STRING;
        }
        Double d = 0.0;
        try {
            d = Double.valueOf(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NumberFormat nf = NumberFormat.getInstance();
        return nf.format(d);
    }

    public static String formatDouble(Double number, int precision) {
        if (number == null) {
            return EMPTY_STRING;
        }
        if (precision < 0 || precision > 10) {
            precision = 2;
        }
        return String.format("%." + precision + "f", number);
    }

    public static String formatDouble(Double d) {
        return StringUtil.formatDouble(d, 2);
    }

    public static double round(Double number, int precision) {
        if (number == null) {
            return 0.0;
        }
        if (precision < 0) {
            precision = 2;
        }
        BigDecimal decimal = new BigDecimal(Double.toString(number)).setScale(precision, 4);
        return decimal.doubleValue();
    }

    public static double round(Double number) {
        return StringUtil.round(number, 2);
    }

    public static String formatToCurrency(Object o) {
        return o == null ? null : String.format("%1$,.2f", o);
    }

    public static String formatFloat(Object number, int precision) {
        if (number == null) {
            return EMPTY_STRING;
        }
        if (precision < 0 || precision > 10) {
            precision = 2;
        }
        return String.format("%." + precision + "f", number);
    }

    public static String getStringForObject(Object obj) {
        if (null == obj) {
            return null;
        }
        return obj.toString();
    }

    public static String toJson(Object obj) {
        return JSON.toJSONString((Object)obj);
    }

    public static String getRootPath() {
        String path = StringUtil.class.getResource("/").getPath();
        path = path.substring(1, path.indexOf("WEB-INF/classes"));
        return path;
    }

    public static boolean isMobile(String str) {
        Pattern p = null;
        Matcher m = null;
        boolean b = false;
        p = Pattern.compile("^[1][3,4,5,7,8][0-9]{9}$");
        m = p.matcher(str);
        b = m.matches();
        return b;
    }

    public static boolean isEmptyForIntger(Integer intger) {
        boolean b = false;
        if (intger == null || intger == 0) {
            b = true;
            return b;
        }
        return b;
    }

    public static String getPercentum(int numerator, int denominator) {
        if (denominator == 0 || numerator == 0) {
            return "0";
        }
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMinimumFractionDigits(2);
        String result = format.format((double)numerator / Double.valueOf(denominator));
        return result;
    }

    public static boolean isNotEmpty(String str) {
        return StringUtils.isNotBlank((String)str) && StringUtils.isNotEmpty((String)str);
    }

    public static boolean isEmpty(String str) {
        return !StringUtils.isNotEmpty((String)str) || !StringUtils.isNotEmpty((String)str.trim());
    }
}

