/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.adapter.entity;

import com.lm.hbase.adapter.Row;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class HBasePageModel
implements Serializable {
    private static final long serialVersionUID = 330410716100946538L;
    private String tableName = null;
    private int pageSize = 100;
    private int pageIndex = 0;
    private int prevPageIndex = 1;
    private int nextPageIndex = 1;
    private int pageCount = 0;
    private int pageFirstRowIndex = 1;
    private byte[] pageStartRowKey = null;
    private byte[] pageEndRowKey = null;
    private int queryTotalCount = 0;
    private long startTime = System.currentTimeMillis();
    private long endTime = System.currentTimeMillis();
    private List<Row> rowList = new ArrayList<Row>();
    private long minStamp = 0L;
    private long maxStamp = 0L;

    public HBasePageModel(int pageSize, String tableName) {
        this.pageSize = pageSize;
        this.tableName = tableName;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public int getPageFirstRowIndex() {
        this.pageFirstRowIndex = (this.getPageIndex() - 1) * this.getPageSize() + 1;
        return this.pageFirstRowIndex;
    }

    public byte[] getPageStartRowKey() {
        return this.pageStartRowKey;
    }

    public void setPageStartRowKey(byte[] pageStartRowKey) {
        this.pageStartRowKey = pageStartRowKey;
    }

    public byte[] getPageEndRowKey() {
        return this.pageEndRowKey;
    }

    public void setPageEndRowKey(byte[] pageEndRowKey) {
        this.pageEndRowKey = pageEndRowKey;
    }

    public int getPrevPageIndex() {
        this.prevPageIndex = this.getPageIndex() > 1 ? this.getPageIndex() - 1 : 1;
        return this.prevPageIndex;
    }

    public int getNextPageIndex() {
        this.nextPageIndex = this.getPageIndex() + 1;
        return this.nextPageIndex;
    }

    public int getQueryTotalCount() {
        return this.queryTotalCount;
    }

    public void setQueryTotalCount(int queryTotalCount) {
        this.queryTotalCount = queryTotalCount;
    }

    public void initStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    public void initEndTime() {
        this.endTime = System.currentTimeMillis();
    }

    public String getTimeIntervalByMilli() {
        return String.valueOf(this.endTime - this.startTime) + "\u6beb\u79d2";
    }

    public String getTimeIntervalBySecond() {
        double interval = (double)(this.endTime - this.startTime) / 1000.0;
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(interval) + "\u79d2";
    }

    public void printTimeInfo() {
        System.out.println("\u8017\u8d39\u65f6\u95f4\uff1a" + this.getTimeIntervalBySecond());
    }

    public List<Row> getRowList() {
        return this.rowList;
    }

    public void addRow(Row row) {
        this.rowList.add(row);
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getMinStamp() {
        return this.minStamp;
    }

    public void setMinStamp(long minStamp) {
        this.minStamp = minStamp;
    }

    public long getMaxStamp() {
        return this.maxStamp;
    }

    public void setMaxStamp(long maxStamp) {
        this.maxStamp = maxStamp;
    }
}

