/*
 * Decompiled with CFR 0.152.
 */
package com.lm.hbase.tab;

import com.lm.hbase.swing.SwingConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class TabCommonUtil {
    String[] tableNamesCache = null;

    public String[] getTableListCache() {
        return this.tableNamesCache;
    }

    public void initTableList(JList<String> list) throws Exception {
        String[] tableNames = SwingConstants.hbaseAdapter.getListTableNames();
        if (tableNames != null) {
            this.tableNamesCache = tableNames;
            list.setListData((String[])tableNames);
        }
    }

    public void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    public void resizeTable(boolean bool, JTable contentTable, JScrollPane tableScroll) {
        Dimension containerwidth = null;
        containerwidth = !bool ? tableScroll.getPreferredSize() : tableScroll.getSize();
        int allwidth = contentTable.getIntercellSpacing().width;
        for (int j = 0; j < contentTable.getColumnCount(); ++j) {
            int max = 0;
            for (int i = 0; i < contentTable.getRowCount(); ++i) {
                int width = contentTable.getCellRenderer((int)i, (int)j).getTableCellRendererComponent((JTable)contentTable, (Object)contentTable.getValueAt((int)i, (int)j), (boolean)false, (boolean)false, (int)i, (int)j).getPreferredSize().width;
                if (width <= max) continue;
                max = width;
            }
            int headerwidth = contentTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)contentTable, (Object)contentTable.getColumnModel().getColumn((int)j).getIdentifier(), (boolean)false, (boolean)false, (int)-1, (int)j).getPreferredSize().width;
            contentTable.getColumnModel().getColumn(j).setPreferredWidth(max += headerwidth);
            allwidth += max + contentTable.getIntercellSpacing().width;
        }
        if ((allwidth += contentTable.getIntercellSpacing().width) > containerwidth.width) {
            contentTable.setAutoResizeMode(0);
        } else {
            contentTable.setAutoResizeMode(2);
        }
    }
}

