/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class SessionState {
    private static File sessionDataFolder;
    private static List sessionObjects;

    public static synchronized void register(Client client) {
        sessionObjects.add(client);
        if (sessionDataFolder != null) {
            client.importState(sessionDataFolder);
        }
    }

    public static synchronized File save() {
        File file = null;
        try {
            file = File.createTempFile("session", "");
            file.delete();
            file.mkdirs();
            Trace.println("Saving session state to " + file.getAbsolutePath(), TraceLevel.BASIC);
            for (Client client : sessionObjects) {
                client.exportState(file);
            }
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
        return file;
    }

    public static synchronized void init(String string) {
        if (string != null) {
            sessionDataFolder = new File(string);
            Trace.println("Session state location: " + sessionDataFolder.getAbsolutePath(), TraceLevel.BASIC);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    if (sessionDataFolder != null) {
                        SystemUtils.deleteRecursive(sessionDataFolder);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    static {
        sessionObjects = new LinkedList();
    }

    public static interface Client {
        public void importState(File var1);

        public void exportState(File var1);
    }
}

