/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jdk.nashorn.internal.AssertsEnabled;
import jdk.nashorn.internal.codegen.ApplySpecialization;
import jdk.nashorn.internal.codegen.AssignSymbols;
import jdk.nashorn.internal.codegen.ClassEmitter;
import jdk.nashorn.internal.codegen.CodeGenerator;
import jdk.nashorn.internal.codegen.CompilationException;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.DumpBytecode;
import jdk.nashorn.internal.codegen.FindScopeDepths;
import jdk.nashorn.internal.codegen.FoldConstants;
import jdk.nashorn.internal.codegen.LocalVariableTypesCalculator;
import jdk.nashorn.internal.codegen.Lower;
import jdk.nashorn.internal.codegen.OptimisticTypesCalculator;
import jdk.nashorn.internal.codegen.ProgramPoints;
import jdk.nashorn.internal.codegen.ReplaceCompileUnits;
import jdk.nashorn.internal.codegen.SplitIntoFunctions;
import jdk.nashorn.internal.codegen.Splitter;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.debug.ASTWriter;
import jdk.nashorn.internal.ir.debug.PrintVisitor;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.CodeInstaller;
import jdk.nashorn.internal.runtime.RecompilableScriptFunctionData;
import jdk.nashorn.internal.runtime.ScriptEnvironment;
import jdk.nashorn.internal.runtime.logging.DebugLogger;

abstract class CompilationPhase
extends Enum<CompilationPhase> {
    public static final /* enum */ CompilationPhase CONSTANT_FOLDING_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED, FunctionNode.CompilationState.PARSED)){

        @Override
        FunctionNode transform(Compiler compiler, Compiler.CompilationPhases phases, FunctionNode fn) {
            return CompilationPhase.transformFunction(fn, new FoldConstants(compiler));
        }

        public String toString() {
            return "'Constant Folding'";
        }
    };
    public static final /* enum */ CompilationPhase LOWERING_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED, FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED)){

        @Override
        FunctionNode transform(Compiler compiler, Compiler.CompilationPhases phases, FunctionNode fn) {
            return CompilationPhase.transformFunction(fn, new Lower(compiler));
        }

        public String toString() {
            return "'Control Flow Lowering'";
        }
    };
    public static final /* enum */ CompilationPhase TRANSFORM_BUILTINS_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED, FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED)){

        @Override
        FunctionNode transform(Compiler compiler, Compiler.CompilationPhases phases, FunctionNode fn) {
            return CompilationPhase.setStates(CompilationPhase.transformFunction(fn, new ApplySpecialization(compiler)), FunctionNode.CompilationState.BUILTINS_TRANSFORMED);
        }

        public String toString() {
            return "'Builtin Replacement'";
        }
    };
    public static final /* enum */ CompilationPhase SPLITTING_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED, FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.BUILTINS_TRANSFORMED)){

        @Override
        FunctionNode transform(Compiler compiler, Compiler.CompilationPhases phases, FunctionNode fn) {
            CompileUnit outermostCompileUnit = compiler.addCompileUnit(0L);
            FunctionNode newFunctionNode = CompilationPhase.transformFunction(fn, new NodeVisitor<LexicalContext>(new LexicalContext()){

                @Override
                public LiteralNode<?> leaveLiteralNode(LiteralNode<?> literalNode) {
                    return literalNode.initialize(this.lc);
                }
            });
            newFunctionNode = new Splitter(compiler, newFunctionNode, outermostCompileUnit).split(newFunctionNode, true);
            newFunctionNode = CompilationPhase.transformFunction(newFunctionNode, new SplitIntoFunctions(compiler));
            assert (newFunctionNode.getCompileUnit() == outermostCompileUnit) : "fn=" + fn.getName() + ", fn.compileUnit (" + newFunctionNode.getCompileUnit() + ") != " + outermostCompileUnit;
            assert (newFunctionNode.isStrict() == compiler.isStrict()) : "functionNode.isStrict() != compiler.isStrict() for " + DebugLogger.quote(newFunctionNode.getName());
            return newFunctionNode;
        }

        public String toString() {
            return "'Code Splitting'";
        }
    };
    public static final /* enum */ CompilationPhase PROGRAM_POINT_PHASE = new CompilationPhase(EnumSet.of(FunctionNode.CompilationState.INITIALIZED, new FunctionNode.CompilationState[]{FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.BUILTINS_TRANSFORMED, FunctionNode.CompilationState.SPLIT})){

        @Override
        FunctionNode transform(Compiler compiler, Compiler.CompilationPhases phases, FunctionNode fn) {
            return CompilationPhase.transformFunction(fn, new ProgramPoints());
        }

        public String toString() {
            return "'Program Point Calculation'";
        }
    };
    public static final /* enum */ CompilationPhase SERIALIZE_SPLIT_PHASE = new CompilationPhase(EnumSet.of(FunctionNode.CompilationState.INITIALIZED, new FunctionNode.CompilationState[]{FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.BUILTINS_TRANSFORMED, FunctionNode.CompilationState.SPLIT})){

        @Override
        FunctionNode transform(final Compiler compiler, Compiler.CompilationPhases phases, FunctionNode fn) {
            return CompilationPhase.transformFunction(fn, new NodeVisitor<LexicalContext>(new LexicalContext()){

                @Override
                public boolean enterFunctionNode(FunctionNode functionNode) {
                    if (functionNode.isSplit()) {
                        compiler.serializeAst(functionNode);
                    }
                    return true;
                }
            });
        }

        public String toString() {
            return "'Serialize Split Functions'";
        }
    };
    public static final /* enum */ CompilationPhase SYMBOL_ASSIGNMENT_PHASE = new CompilationPhase(EnumSet.of(FunctionNode.CompilationState.INITIALIZED, new FunctionNode.CompilationState[]{FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.BUILTINS_TRANSFORMED, FunctionNode.CompilationState.SPLIT})){

        @Override
        FunctionNode transform(Compiler compiler, Compiler.CompilationPhases phases, FunctionNode fn) {
            return CompilationPhase.transformFunction(fn, new AssignSymbols(compiler));
        }

        public String toString() {
            return "'Symbol Assignment'";
        }
    };
    public static final /* enum */ CompilationPhase SCOPE_DEPTH_COMPUTATION_PHASE = new CompilationPhase(EnumSet.of(FunctionNode.CompilationState.INITIALIZED, new FunctionNode.CompilationState[]{FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.BUILTINS_TRANSFORMED, FunctionNode.CompilationState.SPLIT, FunctionNode.CompilationState.SYMBOLS_ASSIGNED})){

        @Override
        FunctionNode transform(Compiler compiler, Compiler.CompilationPhases phases, FunctionNode fn) {
            return CompilationPhase.transformFunction(fn, new FindScopeDepths(compiler));
        }

        public String toString() {
            return "'Scope Depth Computation'";
        }
    };
    public static final /* enum */ CompilationPhase OPTIMISTIC_TYPE_ASSIGNMENT_PHASE = new CompilationPhase(EnumSet.of(FunctionNode.CompilationState.INITIALIZED, new FunctionNode.CompilationState[]{FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.BUILTINS_TRANSFORMED, FunctionNode.CompilationState.SPLIT, FunctionNode.CompilationState.SYMBOLS_ASSIGNED, FunctionNode.CompilationState.SCOPE_DEPTHS_COMPUTED})){

        @Override
        FunctionNode transform(Compiler compiler, Compiler.CompilationPhases phases, FunctionNode fn) {
            if (compiler.useOptimisticTypes()) {
                return CompilationPhase.transformFunction(fn, new OptimisticTypesCalculator(compiler));
            }
            return CompilationPhase.setStates(fn, FunctionNode.CompilationState.OPTIMISTIC_TYPES_ASSIGNED);
        }

        public String toString() {
            return "'Optimistic Type Assignment'";
        }
    };
    public static final /* enum */ CompilationPhase LOCAL_VARIABLE_TYPE_CALCULATION_PHASE = new CompilationPhase(EnumSet.of(FunctionNode.CompilationState.INITIALIZED, new FunctionNode.CompilationState[]{FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.BUILTINS_TRANSFORMED, FunctionNode.CompilationState.SPLIT, FunctionNode.CompilationState.SYMBOLS_ASSIGNED, FunctionNode.CompilationState.SCOPE_DEPTHS_COMPUTED, FunctionNode.CompilationState.OPTIMISTIC_TYPES_ASSIGNED})){

        @Override
        FunctionNode transform(Compiler compiler, Compiler.CompilationPhases phases, FunctionNode fn) {
            FunctionNode newFunctionNode = CompilationPhase.transformFunction(fn, new LocalVariableTypesCalculator(compiler));
            ScriptEnvironment senv = compiler.getScriptEnvironment();
            PrintWriter err = senv.getErr();
            if (senv._print_lower_ast || fn.getFlag(0x100000)) {
                err.println("Lower AST for: " + DebugLogger.quote(newFunctionNode.getName()));
                err.println(new ASTWriter(newFunctionNode));
            }
            if (senv._print_lower_parse || fn.getFlag(262144)) {
                err.println("Lower AST for: " + DebugLogger.quote(newFunctionNode.getName()));
                err.println(new PrintVisitor(newFunctionNode));
            }
            return newFunctionNode;
        }

        public String toString() {
            return "'Local Variable Type Calculation'";
        }
    };
    public static final /* enum */ CompilationPhase REUSE_COMPILE_UNITS_PHASE = new CompilationPhase(EnumSet.of(FunctionNode.CompilationState.INITIALIZED, new FunctionNode.CompilationState[]{FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.BUILTINS_TRANSFORMED, FunctionNode.CompilationState.SPLIT, FunctionNode.CompilationState.SYMBOLS_ASSIGNED, FunctionNode.CompilationState.SCOPE_DEPTHS_COMPUTED, FunctionNode.CompilationState.OPTIMISTIC_TYPES_ASSIGNED, FunctionNode.CompilationState.LOCAL_VARIABLE_TYPES_CALCULATED})){

        @Override
        FunctionNode transform(Compiler compiler, Compiler.CompilationPhases phases, FunctionNode fn) {
            assert (phases.isRestOfCompilation()) : "reuse compile units currently only used for Rest-Of methods";
            final HashMap<CompileUnit, CompileUnit> map = new HashMap<CompileUnit, CompileUnit>();
            Set<CompileUnit> newUnits = CompileUnit.createCompileUnitSet();
            DebugLogger log = compiler.getLogger();
            log.fine("Clearing bytecode cache");
            compiler.clearBytecode();
            for (CompileUnit oldUnit : compiler.getCompileUnits()) {
                assert (map.get(oldUnit) == null);
                CompileUnit newUnit = CompilationPhase.createNewCompileUnit(compiler, phases);
                log.fine("Creating new compile unit ", oldUnit, " => ", newUnit);
                map.put(oldUnit, newUnit);
                assert (newUnit != null);
                newUnits.add(newUnit);
            }
            log.fine("Replacing compile units in Compiler...");
            compiler.replaceCompileUnits(newUnits);
            log.fine("Done");
            FunctionNode newFunctionNode = CompilationPhase.transformFunction(fn, new ReplaceCompileUnits(){

                @Override
                CompileUnit getReplacement(CompileUnit original) {
                    return (CompileUnit)map.get(original);
                }

                @Override
                public Node leaveDefault(Node node) {
                    return node.ensureUniqueLabels(this.lc);
                }
            });
            return newFunctionNode;
        }

        public String toString() {
            return "'Reuse Compile Units'";
        }
    };
    public static final /* enum */ CompilationPhase REINITIALIZE_SERIALIZED = new CompilationPhase(EnumSet.of(FunctionNode.CompilationState.INITIALIZED, new FunctionNode.CompilationState[]{FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.BUILTINS_TRANSFORMED, FunctionNode.CompilationState.SPLIT})){

        @Override
        FunctionNode transform(final Compiler compiler, final Compiler.CompilationPhases phases, FunctionNode fn) {
            final Set<CompileUnit> unitSet = CompileUnit.createCompileUnitSet();
            final HashMap<CompileUnit, CompileUnit> unitMap = new HashMap<CompileUnit, CompileUnit>();
            this.createCompileUnit(fn.getCompileUnit(), unitSet, unitMap, compiler, phases);
            FunctionNode newFn = CompilationPhase.transformFunction(fn, new ReplaceCompileUnits(){

                @Override
                CompileUnit getReplacement(CompileUnit oldUnit) {
                    CompileUnit existing = (CompileUnit)unitMap.get(oldUnit);
                    if (existing != null) {
                        return existing;
                    }
                    return this.createCompileUnit(oldUnit, unitSet, unitMap, compiler, phases);
                }

                @Override
                public Node leaveFunctionNode(FunctionNode fn2) {
                    return super.leaveFunctionNode(compiler.getScriptFunctionData(fn2.getId()).restoreFlags(this.lc, fn2));
                }
            });
            compiler.replaceCompileUnits(unitSet);
            return newFn;
        }

        private CompileUnit createCompileUnit(CompileUnit oldUnit, Set<CompileUnit> unitSet, Map<CompileUnit, CompileUnit> unitMap, Compiler compiler, Compiler.CompilationPhases phases) {
            CompileUnit newUnit = CompilationPhase.createNewCompileUnit(compiler, phases);
            unitMap.put(oldUnit, newUnit);
            unitSet.add(newUnit);
            return newUnit;
        }

        public String toString() {
            return "'Deserialize'";
        }
    };
    public static final /* enum */ CompilationPhase BYTECODE_GENERATION_PHASE = new CompilationPhase(EnumSet.of(FunctionNode.CompilationState.INITIALIZED, new FunctionNode.CompilationState[]{FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.BUILTINS_TRANSFORMED, FunctionNode.CompilationState.SPLIT, FunctionNode.CompilationState.SYMBOLS_ASSIGNED, FunctionNode.CompilationState.SCOPE_DEPTHS_COMPUTED, FunctionNode.CompilationState.OPTIMISTIC_TYPES_ASSIGNED, FunctionNode.CompilationState.LOCAL_VARIABLE_TYPES_CALCULATED})){

        @Override
        FunctionNode transform(Compiler compiler, Compiler.CompilationPhases phases, FunctionNode fn) {
            ScriptEnvironment senv = compiler.getScriptEnvironment();
            FunctionNode newFunctionNode = fn;
            fn.getCompileUnit().setUsed();
            compiler.getLogger().fine("Starting bytecode generation for ", DebugLogger.quote(fn.getName()), " - restOf=", phases.isRestOfCompilation());
            CodeGenerator codegen = new CodeGenerator(compiler, phases.isRestOfCompilation() ? compiler.getContinuationEntryPoints() : null);
            try {
                newFunctionNode = CompilationPhase.transformFunction(newFunctionNode, codegen).setState(null, FunctionNode.CompilationState.BYTECODE_GENERATED);
                codegen.generateScopeCalls();
            }
            catch (VerifyError e) {
                if (senv._verify_code || senv._print_code) {
                    senv.getErr().println(e.getClass().getSimpleName() + ": " + e.getMessage());
                    if (senv._dump_on_error) {
                        e.printStackTrace(senv.getErr());
                    }
                }
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError("Failed generating bytecode for " + fn.getSourceName() + ":" + codegen.getLastLineNumber(), e);
            }
            for (CompileUnit compileUnit : compiler.getCompileUnits()) {
                ClassEmitter classEmitter = compileUnit.getClassEmitter();
                classEmitter.end();
                if (!compileUnit.isUsed()) {
                    compiler.getLogger().fine("Skipping unused compile unit ", compileUnit);
                    continue;
                }
                byte[] bytecode = classEmitter.toByteArray();
                assert (bytecode != null);
                String className = compileUnit.getUnitClassName();
                compiler.addClass(className, bytecode);
                CompileUnit.increaseEmitCount();
                if (senv._verify_code) {
                    compiler.getCodeInstaller().verify(bytecode);
                }
                DumpBytecode.dumpBytecode(senv, compiler.getLogger(), bytecode, className);
            }
            return newFunctionNode;
        }

        public String toString() {
            return "'Bytecode Generation'";
        }
    };
    public static final /* enum */ CompilationPhase INSTALL_PHASE = new CompilationPhase(EnumSet.of(FunctionNode.CompilationState.INITIALIZED, new FunctionNode.CompilationState[]{FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.BUILTINS_TRANSFORMED, FunctionNode.CompilationState.SPLIT, FunctionNode.CompilationState.SYMBOLS_ASSIGNED, FunctionNode.CompilationState.SCOPE_DEPTHS_COMPUTED, FunctionNode.CompilationState.OPTIMISTIC_TYPES_ASSIGNED, FunctionNode.CompilationState.LOCAL_VARIABLE_TYPES_CALCULATED, FunctionNode.CompilationState.BYTECODE_GENERATED})){

        @Override
        FunctionNode transform(Compiler compiler, Compiler.CompilationPhases phases, FunctionNode fn) {
            DebugLogger log = compiler.getLogger();
            LinkedHashMap installedClasses = new LinkedHashMap();
            boolean first = true;
            Class<?> rootClass = null;
            long length = 0L;
            CodeInstaller<ScriptEnvironment> codeInstaller = compiler.getCodeInstaller();
            Map<String, byte[]> bytecode = compiler.getBytecode();
            for (Map.Entry<String, byte[]> entry : bytecode.entrySet()) {
                String className = entry.getKey();
                byte[] code = entry.getValue();
                length += (long)code.length;
                Class<?> clazz = codeInstaller.install(className, code);
                if (first) {
                    rootClass = clazz;
                    first = false;
                }
                installedClasses.put(className, clazz);
            }
            if (rootClass == null) {
                throw new CompilationException("Internal compiler error: root class not found!");
            }
            Object[] constants = compiler.getConstantData().toArray();
            codeInstaller.initialize(installedClasses.values(), compiler.getSource(), constants);
            for (Object constant : constants) {
                if (!(constant instanceof RecompilableScriptFunctionData)) continue;
                ((RecompilableScriptFunctionData)constant).initTransients(compiler.getSource(), codeInstaller);
            }
            for (CompileUnit unit : compiler.getCompileUnits()) {
                if (!unit.isUsed()) continue;
                unit.setCode((Class)installedClasses.get(unit.getUnitClassName()));
                unit.initializeFunctionsCode();
            }
            if (log.isEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Installed class '").append(rootClass.getSimpleName()).append('\'').append(" [").append(rootClass.getName()).append(", size=").append(length).append(" bytes, ").append(compiler.getCompileUnits().size()).append(" compile unit(s)]");
                log.fine(stringBuilder.toString());
            }
            return CompilationPhase.setStates(fn.setRootClass(null, rootClass), FunctionNode.CompilationState.BYTECODE_INSTALLED);
        }

        public String toString() {
            return "'Class Installation'";
        }
    };
    private final EnumSet<FunctionNode.CompilationState> pre;
    private long startTime;
    private long endTime;
    private boolean isFinished;
    private static final /* synthetic */ CompilationPhase[] $VALUES;

    public static CompilationPhase[] values() {
        return (CompilationPhase[])$VALUES.clone();
    }

    public static CompilationPhase valueOf(String name) {
        return Enum.valueOf(CompilationPhase.class, name);
    }

    private CompilationPhase(EnumSet<FunctionNode.CompilationState> pre) {
        this.pre = pre;
    }

    private static FunctionNode setStates(FunctionNode functionNode, final FunctionNode.CompilationState state) {
        if (!AssertsEnabled.assertsEnabled()) {
            return functionNode;
        }
        return CompilationPhase.transformFunction(functionNode, new NodeVisitor<LexicalContext>(new LexicalContext()){

            @Override
            public Node leaveFunctionNode(FunctionNode fn) {
                return fn.setState(this.lc, state);
            }
        });
    }

    protected FunctionNode begin(Compiler compiler, FunctionNode functionNode) {
        compiler.getLogger().indent();
        assert (this.pre != null);
        if (!functionNode.hasState(this.pre)) {
            StringBuilder sb = new StringBuilder("Compilation phase ");
            sb.append((Object)this).append(" is not applicable to ").append(DebugLogger.quote(functionNode.getName())).append("\n\tFunctionNode state = ").append(functionNode.getState()).append("\n\tRequired state     = ").append(this.pre);
            throw new CompilationException(sb.toString());
        }
        this.startTime = System.nanoTime();
        return functionNode;
    }

    protected FunctionNode end(Compiler compiler, FunctionNode functionNode) {
        compiler.getLogger().unindent();
        this.endTime = System.nanoTime();
        compiler.getScriptEnvironment()._timing.accumulateTime(this.toString(), this.endTime - this.startTime);
        this.isFinished = true;
        return functionNode;
    }

    boolean isFinished() {
        return this.isFinished;
    }

    long getStartTime() {
        return this.startTime;
    }

    long getEndTime() {
        return this.endTime;
    }

    abstract FunctionNode transform(Compiler var1, Compiler.CompilationPhases var2, FunctionNode var3) throws CompilationException;

    final FunctionNode apply(Compiler compiler, Compiler.CompilationPhases phases, FunctionNode functionNode) throws CompilationException {
        assert (phases.contains(this));
        return this.end(compiler, this.transform(compiler, phases, this.begin(compiler, functionNode)));
    }

    private static FunctionNode transformFunction(FunctionNode fn, NodeVisitor<?> visitor) {
        return (FunctionNode)fn.accept(visitor);
    }

    private static CompileUnit createNewCompileUnit(Compiler compiler, Compiler.CompilationPhases phases) {
        StringBuilder sb = new StringBuilder(compiler.nextCompileUnitName());
        if (phases.isRestOfCompilation()) {
            sb.append("$restOf");
        }
        return compiler.createCompileUnit(sb.toString(), 0L);
    }

    static {
        $VALUES = new CompilationPhase[]{CONSTANT_FOLDING_PHASE, LOWERING_PHASE, TRANSFORM_BUILTINS_PHASE, SPLITTING_PHASE, PROGRAM_POINT_PHASE, SERIALIZE_SPLIT_PHASE, SYMBOL_ASSIGNMENT_PHASE, SCOPE_DEPTH_COMPUTATION_PHASE, OPTIMISTIC_TYPE_ASSIGNMENT_PHASE, LOCAL_VARIABLE_TYPE_CALCULATION_PHASE, REUSE_COMPILE_UNITS_PHASE, REINITIALIZE_SERIALIZED, BYTECODE_GENERATION_PHASE, INSTALL_PHASE};
    }
}

