/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.SwitchPoint;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import jdk.nashorn.internal.runtime.AccessorProperty;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.Debug;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyHashMap;
import jdk.nashorn.internal.runtime.PropertyListeners;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.UserAccessorProperty;
import jdk.nashorn.internal.runtime.arrays.ArrayIndex;
import jdk.nashorn.internal.scripts.JO;

public final class PropertyMap
implements Iterable<Object>,
Serializable {
    public static final int NOT_EXTENSIBLE = 1;
    public static final int CONTAINS_ARRAY_KEYS = 2;
    private int flags;
    private transient PropertyHashMap properties;
    private int fieldCount;
    private final int fieldMaximum;
    private int spillLength;
    private String className;
    private transient HashMap<String, SwitchPoint> protoGetSwitches;
    private transient WeakHashMap<Property, SoftReference<PropertyMap>> history;
    private transient WeakHashMap<ScriptObject, SoftReference<PropertyMap>> protoHistory;
    private transient PropertyListeners listeners;
    private transient BitSet freeSlots;
    private static final long serialVersionUID = -7041836752008732533L;
    private static int count;
    private static int clonedCount;
    private static int historyHit;
    private static int protoInvalidations;
    private static int protoHistoryHit;
    private static int setProtoNewMapCount;

    private PropertyMap(PropertyHashMap properties, String className, int fieldCount, int fieldMaximum, int spillLength, boolean containsArrayKeys) {
        this.properties = properties;
        this.className = className;
        this.fieldCount = fieldCount;
        this.fieldMaximum = fieldMaximum;
        this.spillLength = spillLength;
        if (containsArrayKeys) {
            this.setContainsArrayKeys();
        }
        if (Context.DEBUG) {
            ++count;
        }
    }

    private PropertyMap(PropertyMap propertyMap, PropertyHashMap properties) {
        this.properties = properties;
        this.flags = propertyMap.flags;
        this.spillLength = propertyMap.spillLength;
        this.fieldCount = propertyMap.fieldCount;
        this.fieldMaximum = propertyMap.fieldMaximum;
        this.listeners = propertyMap.listeners;
        this.freeSlots = propertyMap.freeSlots;
        if (Context.DEBUG) {
            ++count;
            ++clonedCount;
        }
    }

    private PropertyMap(PropertyMap propertyMap) {
        this(propertyMap, propertyMap.properties);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.properties.getProperties());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Property[] props = (Property[])in.readObject();
        this.properties = PropertyHashMap.EMPTY_HASHMAP.immutableAdd(props);
        assert (this.className != null);
        Class<? extends ScriptObject> structure = Context.forStructureClass(this.className);
        for (Property prop : props) {
            prop.initMethodHandles(structure);
        }
    }

    public static PropertyMap newMap(Collection<Property> properties, String className, int fieldCount, int fieldMaximum, int spillLength) {
        PropertyHashMap newProperties = PropertyHashMap.EMPTY_HASHMAP.immutableAdd(properties);
        return new PropertyMap(newProperties, className, fieldCount, fieldMaximum, spillLength, false);
    }

    public static PropertyMap newMap(Collection<Property> properties) {
        return properties == null || properties.isEmpty() ? PropertyMap.newMap() : PropertyMap.newMap(properties, JO.class.getName(), 0, 0, 0);
    }

    public static PropertyMap newMap(Class<? extends ScriptObject> clazz) {
        return new PropertyMap(PropertyHashMap.EMPTY_HASHMAP, clazz.getName(), 0, 0, 0, false);
    }

    public static PropertyMap newMap() {
        return PropertyMap.newMap(JO.class);
    }

    public int size() {
        return this.properties.size();
    }

    public PropertyListeners getListeners() {
        return this.listeners;
    }

    public void addListener(String key, PropertyMap listenerMap) {
        if (listenerMap != this) {
            this.listeners = PropertyListeners.addListener(this.listeners, key, listenerMap);
        }
    }

    public void propertyAdded(Property property) {
        this.invalidateProtoGetSwitchPoint(property);
        if (this.listeners != null) {
            this.listeners.propertyAdded(property);
        }
    }

    public void propertyDeleted(Property property) {
        this.invalidateProtoGetSwitchPoint(property);
        if (this.listeners != null) {
            this.listeners.propertyDeleted(property);
        }
    }

    public void propertyModified(Property oldProperty, Property newProperty) {
        this.invalidateProtoGetSwitchPoint(oldProperty);
        if (this.listeners != null) {
            this.listeners.propertyModified(oldProperty, newProperty);
        }
    }

    public void protoChanged() {
        this.invalidateAllProtoGetSwitchPoints();
        if (this.listeners != null) {
            this.listeners.protoChanged();
        }
    }

    public synchronized SwitchPoint getSwitchPoint(String key) {
        SwitchPoint switchPoint;
        if (this.protoGetSwitches == null) {
            this.protoGetSwitches = new HashMap();
        }
        if ((switchPoint = this.protoGetSwitches.get(key)) == null) {
            switchPoint = new SwitchPoint();
            this.protoGetSwitches.put(key, switchPoint);
        }
        return switchPoint;
    }

    synchronized void invalidateProtoGetSwitchPoint(Property property) {
        String key;
        SwitchPoint sp;
        if (this.protoGetSwitches != null && (sp = this.protoGetSwitches.get(key = property.getKey())) != null) {
            this.protoGetSwitches.remove(key);
            if (Context.DEBUG) {
                ++protoInvalidations;
            }
            SwitchPoint.invalidateAll(new SwitchPoint[]{sp});
        }
    }

    synchronized void invalidateAllProtoGetSwitchPoints() {
        int size;
        if (this.protoGetSwitches != null && (size = this.protoGetSwitches.size()) > 0) {
            if (Context.DEBUG) {
                protoInvalidations += size;
            }
            SwitchPoint.invalidateAll(this.protoGetSwitches.values().toArray(new SwitchPoint[size]));
            this.protoGetSwitches.clear();
        }
    }

    PropertyMap addPropertyBind(AccessorProperty property, Object bindTo) {
        return this.addPropertyNoHistory(new AccessorProperty(property, bindTo));
    }

    private int logicalSlotIndex(Property property) {
        int slot = property.getSlot();
        if (slot < 0) {
            return -1;
        }
        return property.isSpill() ? slot + this.fieldMaximum : slot;
    }

    private void updateFlagsAndBoundaries(Property newProperty) {
        if (newProperty.isSpill()) {
            this.spillLength = Math.max(this.spillLength, newProperty.getSlot() + 1);
        } else {
            this.fieldCount = Math.max(this.fieldCount, newProperty.getSlot() + 1);
        }
        if (ArrayIndex.isValidArrayIndex(ArrayIndex.getArrayIndex(newProperty.getKey()))) {
            this.setContainsArrayKeys();
        }
    }

    private void updateFreeSlots(Property oldProperty, Property newProperty) {
        BitSet newFreeSlots;
        int slotIndex;
        boolean freeSlotsCloned = false;
        if (oldProperty != null && (slotIndex = this.logicalSlotIndex(oldProperty)) >= 0) {
            BitSet bitSet = newFreeSlots = this.freeSlots == null ? new BitSet() : (BitSet)this.freeSlots.clone();
            assert (!newFreeSlots.get(slotIndex));
            newFreeSlots.set(slotIndex);
            this.freeSlots = newFreeSlots;
            freeSlotsCloned = true;
        }
        if (this.freeSlots != null && newProperty != null && (slotIndex = this.logicalSlotIndex(newProperty)) > -1 && this.freeSlots.get(slotIndex)) {
            newFreeSlots = freeSlotsCloned ? this.freeSlots : (BitSet)this.freeSlots.clone();
            newFreeSlots.clear(slotIndex);
            this.freeSlots = newFreeSlots.isEmpty() ? null : newFreeSlots;
        }
    }

    public PropertyMap addPropertyNoHistory(Property property) {
        if (this.listeners != null) {
            this.listeners.propertyAdded(property);
        }
        PropertyHashMap newProperties = this.properties.immutableAdd(property);
        PropertyMap newMap = new PropertyMap(this, newProperties);
        newMap.updateFlagsAndBoundaries(property);
        newMap.updateFreeSlots(null, property);
        return newMap;
    }

    public synchronized PropertyMap addProperty(Property property) {
        PropertyMap newMap;
        if (this.listeners != null) {
            this.listeners.propertyAdded(property);
        }
        if ((newMap = this.checkHistory(property)) == null) {
            PropertyHashMap newProperties = this.properties.immutableAdd(property);
            newMap = new PropertyMap(this, newProperties);
            newMap.updateFlagsAndBoundaries(property);
            newMap.updateFreeSlots(null, property);
            this.addToHistory(property, newMap);
        }
        return newMap;
    }

    public synchronized PropertyMap deleteProperty(Property property) {
        if (this.listeners != null) {
            this.listeners.propertyDeleted(property);
        }
        PropertyMap newMap = this.checkHistory(property);
        String key = property.getKey();
        if (newMap == null && this.properties.containsKey(key)) {
            PropertyHashMap newProperties = this.properties.immutableRemove(key);
            boolean isSpill = property.isSpill();
            int slot = property.getSlot();
            if (isSpill && slot >= 0 && slot == this.spillLength - 1) {
                newMap = new PropertyMap(newProperties, this.className, this.fieldCount, this.fieldMaximum, this.spillLength - 1, this.containsArrayKeys());
                newMap.freeSlots = this.freeSlots;
            } else if (!isSpill && slot >= 0 && slot == this.fieldCount - 1) {
                newMap = new PropertyMap(newProperties, this.className, this.fieldCount - 1, this.fieldMaximum, this.spillLength, this.containsArrayKeys());
                newMap.freeSlots = this.freeSlots;
            } else {
                newMap = new PropertyMap(this, newProperties);
                newMap.updateFreeSlots(property, null);
            }
            this.addToHistory(property, newMap);
        }
        return newMap;
    }

    public PropertyMap replaceProperty(Property oldProperty, Property newProperty) {
        boolean sameType;
        if (this.listeners != null) {
            this.listeners.propertyModified(oldProperty, newProperty);
        }
        PropertyHashMap newProperties = this.properties.immutableReplace(oldProperty, newProperty);
        PropertyMap newMap = new PropertyMap(this, newProperties);
        boolean bl = sameType = oldProperty.getClass() == newProperty.getClass();
        assert (sameType || oldProperty instanceof AccessorProperty && newProperty instanceof UserAccessorProperty) : "arbitrary replaceProperty attempted " + sameType + " oldProperty=" + oldProperty.getClass() + " newProperty=" + newProperty.getClass() + " [" + oldProperty.getLocalType() + " => " + newProperty.getLocalType() + "]";
        newMap.flags = this.flags;
        if (!sameType) {
            newMap.spillLength = Math.max(this.spillLength, newProperty.getSlot() + 1);
            newMap.updateFreeSlots(oldProperty, newProperty);
        }
        return newMap;
    }

    public UserAccessorProperty newUserAccessors(String key, int propertyFlags) {
        return new UserAccessorProperty(key, propertyFlags, this.getFreeSpillSlot());
    }

    public Property findProperty(String key) {
        return this.properties.find(key);
    }

    public PropertyMap addAll(PropertyMap other) {
        assert (this != other) : "adding property map to itself";
        Property[] otherProperties = other.properties.getProperties();
        PropertyHashMap newProperties = this.properties.immutableAdd(otherProperties);
        PropertyMap newMap = new PropertyMap(this, newProperties);
        for (Property property : otherProperties) {
            assert (property.getSlot() == -1);
            assert (!ArrayIndex.isValidArrayIndex(ArrayIndex.getArrayIndex(property.getKey())));
        }
        return newMap;
    }

    public Property[] getProperties() {
        return this.properties.getProperties();
    }

    PropertyMap preventExtensions() {
        PropertyMap newMap = new PropertyMap(this);
        newMap.flags |= 1;
        return newMap;
    }

    PropertyMap seal() {
        PropertyHashMap newProperties = PropertyHashMap.EMPTY_HASHMAP;
        for (Property oldProperty : this.properties.getProperties()) {
            newProperties = newProperties.immutableAdd(oldProperty.addFlags(4));
        }
        PropertyMap newMap = new PropertyMap(this, newProperties);
        newMap.flags |= 1;
        return newMap;
    }

    PropertyMap freeze() {
        PropertyHashMap newProperties = PropertyHashMap.EMPTY_HASHMAP;
        for (Property oldProperty : this.properties.getProperties()) {
            int propertyFlags = 4;
            if (!(oldProperty instanceof UserAccessorProperty)) {
                propertyFlags |= 1;
            }
            newProperties = newProperties.immutableAdd(oldProperty.addFlags(propertyFlags));
        }
        PropertyMap newMap = new PropertyMap(this, newProperties);
        newMap.flags |= 1;
        return newMap;
    }

    private boolean anyConfigurable() {
        for (Property property : this.properties.getProperties()) {
            if (!property.isConfigurable()) continue;
            return true;
        }
        return false;
    }

    private boolean allFrozen() {
        for (Property property : this.properties.getProperties()) {
            if (!(property instanceof UserAccessorProperty) && property.isWritable()) {
                return false;
            }
            if (!property.isConfigurable()) continue;
            return false;
        }
        return true;
    }

    private PropertyMap checkProtoHistory(ScriptObject proto) {
        SoftReference<PropertyMap> weakMap;
        PropertyMap cachedMap = this.protoHistory != null ? ((weakMap = this.protoHistory.get(proto)) != null ? weakMap.get() : null) : null;
        if (Context.DEBUG && cachedMap != null) {
            ++protoHistoryHit;
        }
        return cachedMap;
    }

    private void addToProtoHistory(ScriptObject newProto, PropertyMap newMap) {
        if (this.protoHistory == null) {
            this.protoHistory = new WeakHashMap();
        }
        this.protoHistory.put(newProto, new SoftReference<PropertyMap>(newMap));
    }

    private void addToHistory(Property property, PropertyMap newMap) {
        if (this.history == null) {
            this.history = new WeakHashMap();
        }
        this.history.put(property, new SoftReference<PropertyMap>(newMap));
    }

    private PropertyMap checkHistory(Property property) {
        if (this.history != null) {
            PropertyMap historicMap;
            SoftReference<PropertyMap> ref = this.history.get(property);
            PropertyMap propertyMap = historicMap = ref == null ? null : ref.get();
            if (historicMap != null) {
                if (Context.DEBUG) {
                    ++historyHit;
                }
                return historicMap;
            }
        }
        return null;
    }

    public boolean equalsWithoutType(PropertyMap otherMap) {
        if (this.properties.size() != otherMap.properties.size()) {
            return false;
        }
        Iterator<Property> iter = this.properties.values().iterator();
        Iterator<Property> otherIter = otherMap.properties.values().iterator();
        while (iter.hasNext() && otherIter.hasNext()) {
            if (iter.next().equalsWithoutType(otherIter.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Debug.id(this));
        sb.append(" = {\n");
        for (Property property : this.getProperties()) {
            sb.append('\t');
            sb.append(property);
            sb.append('\n');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Iterator<Object> iterator() {
        return new PropertyMapIterator(this);
    }

    public final boolean containsArrayKeys() {
        return (this.flags & 2) != 0;
    }

    private void setContainsArrayKeys() {
        this.flags |= 2;
    }

    boolean isExtensible() {
        return (this.flags & 1) == 0;
    }

    boolean isSealed() {
        return !this.isExtensible() && !this.anyConfigurable();
    }

    boolean isFrozen() {
        return !this.isExtensible() && this.allFrozen();
    }

    int getFreeFieldSlot() {
        int freeSlot;
        if (this.freeSlots != null && (freeSlot = this.freeSlots.nextSetBit(0)) > -1 && freeSlot < this.fieldMaximum) {
            return freeSlot;
        }
        if (this.fieldCount < this.fieldMaximum) {
            return this.fieldCount;
        }
        return -1;
    }

    int getFreeSpillSlot() {
        int freeSlot;
        if (this.freeSlots != null && (freeSlot = this.freeSlots.nextSetBit(this.fieldMaximum)) > -1) {
            return freeSlot - this.fieldMaximum;
        }
        return this.spillLength;
    }

    public synchronized PropertyMap changeProto(ScriptObject newProto) {
        PropertyMap nextMap = this.checkProtoHistory(newProto);
        if (nextMap != null) {
            return nextMap;
        }
        if (Context.DEBUG) {
            ++setProtoNewMapCount;
        }
        PropertyMap newMap = new PropertyMap(this);
        this.addToProtoHistory(newProto, newMap);
        return newMap;
    }

    public static String diff(PropertyMap map0, PropertyMap map1) {
        StringBuilder sb = new StringBuilder();
        if (map0 != map1) {
            sb.append(">>> START: Map diff");
            boolean found = false;
            for (Property p : map0.getProperties()) {
                Property p2 = map1.findProperty(p.getKey());
                if (p2 == null) {
                    sb.append("FIRST ONLY : [" + p + "]");
                    found = true;
                    continue;
                }
                if (p2 == p) continue;
                sb.append("DIFFERENT  : [" + p + "] != [" + p2 + "]");
                found = true;
            }
            for (Property p2 : map1.getProperties()) {
                Property p1 = map0.findProperty(p2.getKey());
                if (p1 != null) continue;
                sb.append("SECOND ONLY: [" + p2 + "]");
                found = true;
            }
            if (!found) {
                sb.append(map0).append("!=").append(map1);
            }
            sb.append("<<< END: Map diff\n");
        }
        return sb.toString();
    }

    public static int getCount() {
        return count;
    }

    public static int getClonedCount() {
        return clonedCount;
    }

    public static int getHistoryHit() {
        return historyHit;
    }

    public static int getProtoInvalidations() {
        return protoInvalidations;
    }

    public static int getProtoHistoryHit() {
        return protoHistoryHit;
    }

    public static int getSetProtoNewMapCount() {
        return setProtoNewMapCount;
    }

    private static class PropertyMapIterator
    implements Iterator<Object> {
        final Iterator<Property> iter;
        Property property;

        PropertyMapIterator(PropertyMap propertyMap) {
            this.iter = Arrays.asList(propertyMap.properties.getProperties()).iterator();
            this.property = this.iter.hasNext() ? this.iter.next() : null;
            this.skipNotEnumerable();
        }

        private void skipNotEnumerable() {
            while (this.property != null && !this.property.isEnumerable()) {
                this.property = this.iter.hasNext() ? this.iter.next() : null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.property != null;
        }

        @Override
        public Object next() {
            if (this.property == null) {
                throw new NoSuchElementException();
            }
            String key = this.property.getKey();
            this.property = this.iter.next();
            this.skipNotEnumerable();
            return key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

