/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.dir;

import com.sun.jndi.toolkit.dir.AttrFilter;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidSearchFilterException;

public class SearchFilter
implements AttrFilter {
    String filter;
    int pos;
    private StringFilter rootFilter;
    protected static final boolean debug = false;
    protected static final char BEGIN_FILTER_TOKEN = '(';
    protected static final char END_FILTER_TOKEN = ')';
    protected static final char AND_TOKEN = '&';
    protected static final char OR_TOKEN = '|';
    protected static final char NOT_TOKEN = '!';
    protected static final char EQUAL_TOKEN = '=';
    protected static final char APPROX_TOKEN = '~';
    protected static final char LESS_TOKEN = '<';
    protected static final char GREATER_TOKEN = '>';
    protected static final char EXTEND_TOKEN = ':';
    protected static final char WILDCARD_TOKEN = '*';
    static final int EQUAL_MATCH = 1;
    static final int APPROX_MATCH = 2;
    static final int GREATER_MATCH = 3;
    static final int LESS_MATCH = 4;

    public SearchFilter(String string) throws InvalidSearchFilterException {
        this.filter = string;
        this.pos = 0;
        this.normalizeFilter();
        this.rootFilter = this.createNextFilter();
    }

    @Override
    public boolean check(Attributes attributes) throws NamingException {
        if (attributes == null) {
            return false;
        }
        return this.rootFilter.check(attributes);
    }

    protected void normalizeFilter() {
        this.skipWhiteSpace();
        if (this.getCurrentChar() != '(') {
            this.filter = '(' + this.filter + ')';
        }
    }

    private void skipWhiteSpace() {
        while (Character.isWhitespace(this.getCurrentChar())) {
            this.consumeChar();
        }
    }

    protected StringFilter createNextFilter() throws InvalidSearchFilterException {
        StringFilter stringFilter;
        this.skipWhiteSpace();
        try {
            if (this.getCurrentChar() != '(') {
                throw new InvalidSearchFilterException("expected \"(\" at position " + this.pos);
            }
            this.consumeChar();
            this.skipWhiteSpace();
            switch (this.getCurrentChar()) {
                case '&': {
                    stringFilter = new CompoundFilter(true);
                    stringFilter.parse();
                    break;
                }
                case '|': {
                    stringFilter = new CompoundFilter(false);
                    stringFilter.parse();
                    break;
                }
                case '!': {
                    stringFilter = new NotFilter();
                    stringFilter.parse();
                    break;
                }
                default: {
                    stringFilter = new AtomicFilter();
                    stringFilter.parse();
                }
            }
            this.skipWhiteSpace();
            if (this.getCurrentChar() != ')') {
                throw new InvalidSearchFilterException("expected \")\" at position " + this.pos);
            }
            this.consumeChar();
        }
        catch (InvalidSearchFilterException invalidSearchFilterException) {
            throw invalidSearchFilterException;
        }
        catch (Exception exception) {
            throw new InvalidSearchFilterException("Unable to parse character " + this.pos + " in \"" + this.filter + "\"");
        }
        return stringFilter;
    }

    protected char getCurrentChar() {
        return this.filter.charAt(this.pos);
    }

    protected char relCharAt(int n) {
        return this.filter.charAt(this.pos + n);
    }

    protected void consumeChar() {
        ++this.pos;
    }

    protected void consumeChars(int n) {
        this.pos += n;
    }

    protected int relIndexOf(int n) {
        return this.filter.indexOf(n, this.pos) - this.pos;
    }

    protected String relSubstring(int n, int n2) {
        return this.filter.substring(n + this.pos, n2 + this.pos);
    }

    public static String format(Attributes attributes) throws NamingException {
        if (attributes == null || attributes.size() == 0) {
            return "objectClass=*";
        }
        String string = "(& ";
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMore()) {
            Attribute attribute = namingEnumeration.next();
            if (attribute.size() == 0 || attribute.size() == 1 && attribute.get() == null) {
                string = string + "(" + attribute.getID() + "=" + "*)";
                continue;
            }
            NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
            while (namingEnumeration2.hasMore()) {
                String string2 = SearchFilter.getEncodedStringRep(namingEnumeration2.next());
                if (string2 == null) continue;
                string = string + "(" + attribute.getID() + "=" + string2 + ")";
            }
        }
        string = string + ")";
        return string;
    }

    private static void hexDigit(StringBuffer stringBuffer, byte by) {
        char c = (char)(by >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        stringBuffer.append(c);
        c = (char)(by & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        stringBuffer.append(c);
    }

    private static String getEncodedStringRep(Object object) throws NamingException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append('\\');
                SearchFilter.hexDigit(stringBuffer, byArray[i]);
            }
            return stringBuffer.toString();
        }
        String string = !(object instanceof String) ? object.toString() : (String)object;
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '*': {
                    stringBuffer.append("\\2a");
                    continue block8;
                }
                case '(': {
                    stringBuffer.append("\\28");
                    continue block8;
                }
                case ')': {
                    stringBuffer.append("\\29");
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append("\\5c");
                    continue block8;
                }
                case '\u0000': {
                    stringBuffer.append("\\00");
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static int findUnescaped(char c, String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            int n3 = string.indexOf(c, n);
            if (n3 == n || n3 == -1 || string.charAt(n3 - 1) != '\\') {
                return n3;
            }
            n = n3 + 1;
        }
        return -1;
    }

    public static String format(String string, Object[] objectArray) throws NamingException {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while ((n = SearchFilter.findUnescaped('{', string, n2)) >= 0) {
            int n3;
            int n4 = n + 1;
            int n5 = string.indexOf(125, n4);
            if (n5 < 0) {
                throw new InvalidSearchFilterException("unbalanced {: " + string);
            }
            try {
                n3 = Integer.parseInt(string.substring(n4, n5));
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidSearchFilterException("integer expected inside {}: " + string);
            }
            if (n3 >= objectArray.length) {
                throw new InvalidSearchFilterException("number exceeds argument list: " + n3);
            }
            stringBuffer.append(string.substring(n2, n)).append(SearchFilter.getEncodedStringRep(objectArray[n3]));
            n2 = n5 + 1;
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public static Attributes selectAttributes(Attributes attributes, String[] stringArray) throws NamingException {
        if (stringArray == null) {
            return attributes;
        }
        BasicAttributes basicAttributes = new BasicAttributes();
        for (int i = 0; i < stringArray.length; ++i) {
            Attribute attribute = attributes.get(stringArray[i]);
            if (attribute == null) continue;
            basicAttributes.put(attribute);
        }
        return basicAttributes;
    }

    final class AtomicFilter
    implements StringFilter {
        private String attrID;
        private String value;
        private int matchType;

        AtomicFilter() {
        }

        @Override
        public void parse() throws InvalidSearchFilterException {
            SearchFilter.this.skipWhiteSpace();
            try {
                int n = SearchFilter.this.relIndexOf(41);
                int n2 = SearchFilter.this.relIndexOf(61);
                char c = SearchFilter.this.relCharAt(n2 - 1);
                switch (c) {
                    case '~': {
                        this.matchType = 2;
                        this.attrID = SearchFilter.this.relSubstring(0, n2 - 1);
                        this.value = SearchFilter.this.relSubstring(n2 + 1, n);
                        break;
                    }
                    case '>': {
                        this.matchType = 3;
                        this.attrID = SearchFilter.this.relSubstring(0, n2 - 1);
                        this.value = SearchFilter.this.relSubstring(n2 + 1, n);
                        break;
                    }
                    case '<': {
                        this.matchType = 4;
                        this.attrID = SearchFilter.this.relSubstring(0, n2 - 1);
                        this.value = SearchFilter.this.relSubstring(n2 + 1, n);
                        break;
                    }
                    case ':': {
                        throw new OperationNotSupportedException("Extensible match not supported");
                    }
                    default: {
                        this.matchType = 1;
                        this.attrID = SearchFilter.this.relSubstring(0, n2);
                        this.value = SearchFilter.this.relSubstring(n2 + 1, n);
                    }
                }
                this.attrID = this.attrID.trim();
                this.value = this.value.trim();
                SearchFilter.this.consumeChars(n);
            }
            catch (Exception exception) {
                InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException("Unable to parse character " + SearchFilter.this.pos + " in \"" + SearchFilter.this.filter + "\"");
                invalidSearchFilterException.setRootCause(exception);
                throw invalidSearchFilterException;
            }
        }

        @Override
        public boolean check(Attributes attributes) {
            NamingEnumeration<?> namingEnumeration;
            Object object;
            try {
                object = attributes.get(this.attrID);
                if (object == null) {
                    return false;
                }
                namingEnumeration = object.getAll();
            }
            catch (NamingException namingException) {
                return false;
            }
            while (namingEnumeration.hasMoreElements()) {
                object = namingEnumeration.nextElement().toString();
                switch (this.matchType) {
                    case 1: 
                    case 2: {
                        if (!this.substringMatch(this.value, (String)object)) break;
                        return true;
                    }
                    case 3: {
                        if (((String)object).compareTo(this.value) < 0) break;
                        return true;
                    }
                    case 4: {
                        if (((String)object).compareTo(this.value) > 0) break;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean substringMatch(String string, String string2) {
            if (string.equals(new Character('*').toString())) {
                return true;
            }
            if (string.indexOf(42) == -1) {
                return string.equalsIgnoreCase(string2);
            }
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "*", false);
            if (string.charAt(0) != '*' && !string2.toLowerCase(Locale.ENGLISH).startsWith(stringTokenizer.nextToken().toLowerCase(Locale.ENGLISH))) {
                return false;
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                n = string2.toLowerCase(Locale.ENGLISH).indexOf(string3.toLowerCase(Locale.ENGLISH), n);
                if (n == -1) {
                    return false;
                }
                n += string3.length();
            }
            return string.charAt(string.length() - 1) == '*' || n == string2.length();
        }
    }

    final class CompoundFilter
    implements StringFilter {
        private Vector<StringFilter> subFilters = new Vector();
        private boolean polarity;

        CompoundFilter(boolean bl) {
            this.polarity = bl;
        }

        @Override
        public void parse() throws InvalidSearchFilterException {
            SearchFilter.this.consumeChar();
            while (SearchFilter.this.getCurrentChar() != ')') {
                StringFilter stringFilter = SearchFilter.this.createNextFilter();
                this.subFilters.addElement(stringFilter);
                SearchFilter.this.skipWhiteSpace();
            }
        }

        @Override
        public boolean check(Attributes attributes) throws NamingException {
            for (int i = 0; i < this.subFilters.size(); ++i) {
                StringFilter stringFilter = this.subFilters.elementAt(i);
                if (stringFilter.check(attributes) == this.polarity) continue;
                return !this.polarity;
            }
            return this.polarity;
        }
    }

    final class NotFilter
    implements StringFilter {
        private StringFilter filter;

        NotFilter() {
        }

        @Override
        public void parse() throws InvalidSearchFilterException {
            SearchFilter.this.consumeChar();
            this.filter = SearchFilter.this.createNextFilter();
        }

        @Override
        public boolean check(Attributes attributes) throws NamingException {
            return !this.filter.check(attributes);
        }
    }

    static interface StringFilter
    extends AttrFilter {
        public void parse() throws InvalidSearchFilterException;
    }
}

