/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.ReplayCache;
import sun.security.krb5.internal.rcache.AuthTime;
import sun.security.krb5.internal.rcache.AuthTimeWithHash;

public class DflCache
extends ReplayCache {
    private static final int KRB5_RV_VNO = 1281;
    private static final int EXCESSREPS = 30;
    private final String source;
    private static int uid;

    public DflCache(String string) {
        this.source = string;
    }

    private static String defaultPath() {
        return AccessController.doPrivileged(new GetPropertyAction("java.io.tmpdir"));
    }

    private static String defaultFile(String string) {
        int n = string.indexOf(47);
        if (n == -1) {
            n = string.indexOf(64);
        }
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (uid != -1) {
            string = string + "_" + uid;
        }
        return string;
    }

    private static Path getFileName(String string, String string2) {
        String string3;
        String string4;
        if (string.equals("dfl")) {
            string4 = DflCache.defaultPath();
            string3 = DflCache.defaultFile(string2);
        } else if (string.startsWith("dfl:")) {
            string = string.substring(4);
            int n = string.lastIndexOf(47);
            int n2 = string.lastIndexOf(92);
            if (n2 > n) {
                n = n2;
            }
            if (n == -1) {
                string4 = DflCache.defaultPath();
                string3 = string;
            } else if (new File(string).isDirectory()) {
                string4 = string;
                string3 = DflCache.defaultFile(string2);
            } else {
                string4 = null;
                string3 = string;
            }
        } else {
            throw new IllegalArgumentException();
        }
        return new File(string4, string3).toPath();
    }

    @Override
    public void checkAndStore(KerberosTime kerberosTime, AuthTimeWithHash authTimeWithHash) throws KrbApErrException {
        try {
            this.checkAndStore0(kerberosTime, authTimeWithHash);
        }
        catch (IOException iOException) {
            KrbApErrException krbApErrException = new KrbApErrException(60);
            krbApErrException.initCause(iOException);
            throw krbApErrException;
        }
    }

    private synchronized void checkAndStore0(KerberosTime kerberosTime, AuthTimeWithHash authTimeWithHash) throws IOException, KrbApErrException {
        Path path = DflCache.getFileName(this.source, authTimeWithHash.server);
        int n = 0;
        try (Storage storage = new Storage();){
            try {
                n = storage.loadAndCheck(path, authTimeWithHash, kerberosTime);
            }
            catch (IOException iOException) {
                Storage.create(path);
                n = storage.loadAndCheck(path, authTimeWithHash, kerberosTime);
            }
            storage.append(authTimeWithHash);
        }
        if (n > 30) {
            Storage.expunge(path, kerberosTime);
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("com.sun.security.auth.module.UnixSystem");
            uid = (int)((Long)clazz.getMethod("getUid", new Class[0]).invoke(clazz.newInstance(), new Object[0])).longValue();
        }
        catch (Exception exception) {
            uid = -1;
        }
    }

    private static class Storage
    implements Closeable {
        SeekableByteChannel chan;

        private Storage() {
        }

        private static void create(Path path) throws IOException {
            SeekableByteChannel seekableByteChannel = Storage.createNoClose(path);
            Throwable throwable = null;
            if (seekableByteChannel != null) {
                if (throwable != null) {
                    try {
                        seekableByteChannel.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    seekableByteChannel.close();
                }
            }
            Storage.makeMine(path);
        }

        private static void makeMine(Path path) throws IOException {
            try {
                HashSet<PosixFilePermission> hashSet = new HashSet<PosixFilePermission>();
                hashSet.add(PosixFilePermission.OWNER_READ);
                hashSet.add(PosixFilePermission.OWNER_WRITE);
                Files.setPosixFilePermissions(path, hashSet);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }

        private static SeekableByteChannel createNoClose(Path path) throws IOException {
            SeekableByteChannel seekableByteChannel = Files.newByteChannel(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            ByteBuffer byteBuffer = ByteBuffer.allocate(6);
            byteBuffer.putShort((short)1281);
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.putInt(KerberosTime.getDefaultSkew());
            byteBuffer.flip();
            seekableByteChannel.write(byteBuffer);
            return seekableByteChannel;
        }

        private static void expunge(Path path, KerberosTime kerberosTime) throws IOException {
            Path path2 = Files.createTempFile(path.getParent(), "rcache", null, new FileAttribute[0]);
            try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(path, new OpenOption[0]);){
                SeekableByteChannel seekableByteChannel2 = Storage.createNoClose(path2);
                Throwable throwable = null;
                try {
                    long l = kerberosTime.getSeconds() - Storage.readHeader(seekableByteChannel);
                    try {
                        while (true) {
                            AuthTime authTime = AuthTime.readFrom(seekableByteChannel);
                            if ((long)authTime.ctime <= l) continue;
                            ByteBuffer byteBuffer = ByteBuffer.wrap(authTime.encode(true));
                            seekableByteChannel2.write(byteBuffer);
                        }
                    }
                    catch (BufferUnderflowException bufferUnderflowException) {
                        if (seekableByteChannel2 != null) {
                            if (throwable != null) {
                                try {
                                    seekableByteChannel2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                seekableByteChannel2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (seekableByteChannel2 != null) {
                            if (throwable != null) {
                                try {
                                    seekableByteChannel2.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                seekableByteChannel2.close();
                            }
                        }
                        throw throwable4;
                    }
                }
            }
            Storage.makeMine(path2);
            Files.move(path2, path, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }

        private int loadAndCheck(Path path, AuthTimeWithHash authTimeWithHash, KerberosTime kerberosTime) throws IOException, KrbApErrException {
            int n = 0;
            if (Files.isSymbolicLink(path)) {
                throw new IOException("Symlink not accepted");
            }
            try {
                Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, new LinkOption[0]);
                if (uid != -1 && (Integer)Files.getAttribute(path, "unix:uid", new LinkOption[0]) != uid) {
                    throw new IOException("Not mine");
                }
                if (set.contains((Object)PosixFilePermission.GROUP_READ) || set.contains((Object)PosixFilePermission.GROUP_WRITE) || set.contains((Object)PosixFilePermission.GROUP_EXECUTE) || set.contains((Object)PosixFilePermission.OTHERS_READ) || set.contains((Object)PosixFilePermission.OTHERS_WRITE) || set.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
                    throw new IOException("Accessible by someone else");
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.chan = Files.newByteChannel(path, StandardOpenOption.WRITE, StandardOpenOption.READ);
            long l = kerberosTime.getSeconds() - Storage.readHeader(this.chan);
            long l2 = 0L;
            boolean bl = false;
            try {
                while (true) {
                    l2 = this.chan.position();
                    AuthTime authTime = AuthTime.readFrom(this.chan);
                    if (authTime instanceof AuthTimeWithHash) {
                        if (authTimeWithHash.equals(authTime)) {
                            throw new KrbApErrException(34);
                        }
                        if (authTimeWithHash.isSameIgnoresHash(authTime)) {
                            bl = true;
                        }
                    } else if (authTimeWithHash.isSameIgnoresHash(authTime) && !bl) {
                        throw new KrbApErrException(34);
                    }
                    if ((long)authTime.ctime < l) {
                        ++n;
                        continue;
                    }
                    --n;
                }
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                this.chan.position(l2);
                return n;
            }
        }

        private static int readHeader(SeekableByteChannel seekableByteChannel) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(6);
            seekableByteChannel.read(byteBuffer);
            if (byteBuffer.getShort(0) != 1281) {
                throw new IOException("Not correct rcache version");
            }
            byteBuffer.order(ByteOrder.nativeOrder());
            return byteBuffer.getInt(2);
        }

        private void append(AuthTimeWithHash authTimeWithHash) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(authTimeWithHash.encode(true));
            this.chan.write(byteBuffer);
            byteBuffer = ByteBuffer.wrap(authTimeWithHash.encode(false));
            this.chan.write(byteBuffer);
        }

        @Override
        public void close() throws IOException {
            if (this.chan != null) {
                this.chan.close();
            }
            this.chan = null;
        }
    }
}

