/*
 * Decompiled with CFR 0.152.
 */
package cpath.client.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.model.Model;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;

public class BioPAXHttpMessageConverter
implements HttpMessageConverter<Model> {
    private final BioPAXIOHandler bioPAXIOHandler;
    private static final List<MediaType> mediaList = new ArrayList<MediaType>();

    public BioPAXHttpMessageConverter(BioPAXIOHandler bioPAXIOHandler) {
        this.bioPAXIOHandler = bioPAXIOHandler;
    }

    @Override
    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return Model.class.equals(clazz);
    }

    @Override
    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return Collections.unmodifiableList(mediaList);
    }

    @Override
    public Model read(Class<? extends Model> clazz, HttpInputMessage inputMessage) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(inputMessage.getBody());
        bis.mark(0);
        return this.bioPAXIOHandler.convertFromOWL(bis);
    }

    @Override
    public void write(Model model, MediaType contentType, HttpOutputMessage outputMessage) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    static {
        mediaList.add(MediaType.TEXT_PLAIN);
        mediaList.add(MediaType.parseMediaType("application/vnd.biopax.rdf+xml"));
    }
}

