/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Traverser {
    protected final EditorMap editorMap;
    protected Visitor visitor;
    protected Filter<PropertyEditor>[] filters;
    private static final Logger log = LoggerFactory.getLogger(Traverser.class);

    public Traverser(EditorMap editorMap, Visitor visitor, Filter<PropertyEditor> ... filters) {
        this.editorMap = editorMap;
        this.visitor = visitor;
        this.filters = filters;
    }

    public void setVisitor(Visitor visitor) {
        this.visitor = visitor;
    }

    public Visitor getVisitor() {
        return this.visitor;
    }

    public <D extends BioPAXElement> void traverse(D element, Model model) {
        Set<PropertyEditor> editors = this.editorMap.getEditorsOf(element);
        if (editors == null) {
            log.warn("No editors for : " + element.getModelInterface());
            return;
        }
        for (PropertyEditor editor : editors) {
            Set valueSet;
            if (!this.filter(editor) || (valueSet = editor.getValueFromBean(element)).isEmpty()) continue;
            this.traverseElements(element, model, editor, valueSet);
        }
    }

    protected void traverseElements(BioPAXElement element, Model model, PropertyEditor<?, ?> editor, Set<?> valueSet) {
        for (Object value : new HashSet(valueSet)) {
            this.visitor.visit(element, value, model, editor);
        }
    }

    protected boolean filter(PropertyEditor<?, ?> editor) {
        for (Filter<PropertyEditor> filter : this.filters) {
            if (filter.filter(editor)) continue;
            return false;
        }
        return true;
    }
}

