/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SequenceModificationVocabulary;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;
import org.biopax.paxtools.pattern.util.DifferentialModificationUtil;

public class ModificationChangeConstraint
extends ConstraintAdapter {
    protected String[] featureSubstring;
    protected Type type;

    public ModificationChangeConstraint(Type type, String ... featureSubstring) {
        super(2);
        this.type = type;
        for (int i = 0; i < featureSubstring.length; ++i) {
            featureSubstring[i] = featureSubstring[i].toLowerCase();
        }
        this.featureSubstring = featureSubstring;
    }

    @Override
    public boolean satisfies(Match match, int ... ind) {
        PhysicalEntity pe1 = (PhysicalEntity)match.get(ind[0]);
        PhysicalEntity pe2 = (PhysicalEntity)match.get(ind[1]);
        Set<ModificationFeature>[] mods = DifferentialModificationUtil.getChangedModifications(pe1, pe2);
        Set<String> terms = this.type == Type.GAIN ? this.collectTerms(mods[0]) : (this.type == Type.LOSS ? this.collectTerms(mods[1]) : this.collectTerms(mods));
        return this.termsContainDesired(terms);
    }

    private Set<String> collectTerms(Set<ModificationFeature> ... mods) {
        HashSet<String> terms = new HashSet<String>();
        this.collectTerms(mods[0], (Set<String>)terms);
        if (mods.length > 1) {
            this.collectTerms(mods[1], (Set<String>)terms);
        }
        return terms;
    }

    private void collectTerms(Set<ModificationFeature> mods, Set<String> terms) {
        for (ModificationFeature mf : mods) {
            SequenceModificationVocabulary type = mf.getModificationType();
            if (type == null) continue;
            for (String term : type.getTerm()) {
                terms.add(term.toLowerCase());
            }
        }
    }

    private boolean termsContainDesired(Set<String> terms) {
        if (terms.isEmpty()) {
            return false;
        }
        if (this.featureSubstring.length == 0) {
            return true;
        }
        for (String term : terms) {
            for (String sub : this.featureSubstring) {
                if (!term.contains(sub)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum Type {
        GAIN,
        LOSS,
        ANY;

    }
}

