/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.biopax.paxtools.query.algorithm.BFS;
import org.biopax.paxtools.query.model.Edge;
import org.biopax.paxtools.query.model.GraphObject;
import org.biopax.paxtools.query.model.Node;

public class CycleBreaker
extends BFS {
    Set<GraphObject> result;
    Set<Node> ST;

    public CycleBreaker(Set<GraphObject> result, Set<Node> ST2, int limit) {
        this.result = result;
        this.ST = ST2;
        this.limit = limit;
    }

    public void breakCycles() {
        for (GraphObject go : new ArrayList<GraphObject>(this.result)) {
            if (!(go instanceof Node)) continue;
            Node node = (Node)go;
            for (Edge edge : node.getDownstream()) {
                if (!this.result.contains(edge) || this.isSafe(node, edge)) continue;
                this.result.remove(edge);
            }
        }
    }

    public boolean isSafe(Node node, Edge edge) {
        this.initMaps();
        this.setColor(node, 2);
        this.setLabel(node, 0);
        this.setLabel(edge, 0);
        this.labelEquivRecursive(node, true, 0, false, false);
        this.labelEquivRecursive(node, false, 0, false, false);
        Node neigh = edge.getTargetNode();
        if (this.getColor(neigh) != 0) {
            return false;
        }
        this.setColor(neigh, 1);
        this.setLabel(neigh, 0);
        this.queue.add(neigh);
        this.labelEquivRecursive(neigh, true, 0, true, false);
        this.labelEquivRecursive(neigh, false, 0, true, false);
        while (!this.queue.isEmpty()) {
            Node current = (Node)this.queue.remove(0);
            if (this.ST.contains(current)) {
                return true;
            }
            boolean safe = this.processNode2(current);
            if (safe) {
                return true;
            }
            this.setColor(current, 2);
        }
        return false;
    }

    protected boolean processNode2(Node current) {
        return this.processEdges(current, current.getDownstream()) || this.processEdges(current, current.getUpstream());
    }

    private boolean processEdges(Node current, Collection<Edge> edges) {
        for (Edge edge : edges) {
            if (!this.result.contains(edge)) continue;
            this.setLabel(edge, this.getLabel(current));
            Node neigh = edge.getSourceNode() == current ? edge.getTargetNode() : edge.getSourceNode();
            if (this.getColor(neigh) != 0) continue;
            if (neigh.isBreadthNode()) {
                this.setLabel(neigh, this.getLabel(current) + 1);
            } else {
                this.setLabel(neigh, this.getLabel(edge));
            }
            if (this.getLabel(neigh) == this.limit || this.isEquivalentInTheSet(neigh, this.ST)) {
                return true;
            }
            this.setColor(neigh, 1);
            if (neigh.isBreadthNode()) {
                this.queue.addLast(neigh);
            } else {
                this.queue.addFirst(neigh);
            }
            this.labelEquivRecursive(neigh, true, this.getLabel(neigh), true, !neigh.isBreadthNode());
            this.labelEquivRecursive(neigh, false, this.getLabel(neigh), true, !neigh.isBreadthNode());
        }
        return false;
    }
}

