/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.model.Edge;
import org.biopax.paxtools.query.model.GraphObject;
import org.cbio.causality.analysis.BFS;
import org.cbio.causality.analysis.Exhaustive;
import org.cbio.causality.model.Alteration;
import org.cbio.causality.model.AlterationPack;
import org.cbio.causality.model.Node;
import org.cbio.causality.model.Path;
import org.cbio.causality.model.PathUser;
import org.cbio.causality.wrapper.Graph;
import org.cbio.causality.wrapper.PhysicalEntityWrapper;

public class CausativePathSearch {
    public Map<Node, Map<Integer, Integer>[]> labelGraph(Graph graph, int distance, double overlapThr) {
        HashMap<Node, Map<Integer, Integer>[]> label = new HashMap<Node, Map<Integer, Integer>[]>();
        HashMap<Node, Set<String>[]> seen = new HashMap<Node, Set<String>[]>();
        for (Node target : graph.getBreadthNodes()) {
            AlterationPack altTarget = target.getAlterations();
            if (altTarget == null || !altTarget.isAltered()) continue;
            List<Path> paths = this.search(target, distance, overlapThr);
            for (Path path : paths) {
                assert (path.isReverse());
                assert (path.getFirstNode() == target);
                Node source = path.getLastNode();
                AlterationPack altSource = source.getAlterations();
                assert (altSource.isAltered());
                this.recordPaths(label, seen, altTarget, altSource, path, true);
                this.recordPaths(label, seen, altTarget, altSource, path, false);
            }
        }
        return label;
    }

    protected void recordPaths(Map<Node, Map<Integer, Integer>[]> label, Map<Node, Set<String>[]> seen, AlterationPack altTarget, AlterationPack altSource, Path path, boolean up) {
        List<Integer> inds = altTarget.getParallelChangedIndexes(altSource, path.getSign() == 1, up);
        if (!inds.isEmpty()) {
            String altKey = altSource.getId() + "-" + altTarget.getId();
            Map<Node, Integer> sm = path.getIntermediateSignMapping(up ? 1 : -1);
            for (Node node : sm.keySet()) {
                Integer sign = sm.get(node);
                if (!seen.containsKey(node)) {
                    seen.put(node, new Set[]{new HashSet(), new HashSet()});
                }
                if (seen.get(node)[sign == 1 ? 0 : 1].contains(altKey)) continue;
                seen.get(node)[sign == 1 ? 0 : 1].add(altKey);
                if (!label.containsKey(node)) {
                    label.put(node, new Map[]{new HashMap(), new HashMap()});
                }
                Map<Integer, Integer> map = label.get(node)[sign == 1 ? 0 : 1];
                for (Integer ind : inds) {
                    if (!map.containsKey(ind)) {
                        map.put(ind, 1);
                        continue;
                    }
                    map.put(ind, map.get(ind) + 1);
                }
            }
        }
    }

    public List<Path> search(Node target, int distance, double overlapThr) {
        BFS bfs;
        AlterationPack pack = target.getAlterations();
        boolean alt_exp = pack.isAltered(Alteration.EXPRESSION);
        boolean alt_prot = pack.isAltered(Alteration.PROTEIN_LEVEL);
        if (!alt_exp && !alt_prot) {
            return Collections.emptyList();
        }
        if (alt_prot) {
            bfs = new BFS(Collections.singleton(target), null, Direction.UPSTREAM, distance, false);
        } else {
            Set<Node> t = this.getTranscriptionReactions(target);
            if (t.isEmpty()) {
                return Collections.emptyList();
            }
            bfs = new BFS(t, null, Direction.UPSTREAM, distance, false);
        }
        Map<GraphObject, Integer> distMap = bfs.run();
        final HashSet<PhysicalEntityWrapper> pewSet = new HashSet<PhysicalEntityWrapper>();
        for (GraphObject go : distMap.keySet()) {
            AlterationPack pack2;
            PhysicalEntityWrapper pew;
            if (!(go instanceof PhysicalEntityWrapper) || (pew = (PhysicalEntityWrapper)go).getPathSign() == 0 || (pack2 = pew.getAlterations()) == null || pack == pack2) continue;
            boolean bl = pew.getPathSign() == 1;
            double rat = pack.getParallelChangeRatio(pack2, bl);
            if (!(rat >= overlapThr)) continue;
            pewSet.add(pew);
        }
        final ArrayList<Path> result = new ArrayList<Path>();
        if (!pewSet.isEmpty()) {
            Exhaustive ex = new Exhaustive(target, Direction.UPSTREAM, distance, new PathUser(){

                @Override
                public void processPath(Path path) {
                    if (pewSet.contains(path.getLastNode())) {
                        try {
                            result.add((Path)path.clone());
                        }
                        catch (CloneNotSupportedException e) {
                            e.printStackTrace();
                            throw new RuntimeException("Clone should have been supported here.");
                        }
                    }
                }
            }, distMap.keySet());
            ex.run();
        }
        for (GraphObject go : distMap.keySet()) {
            go.clear();
        }
        return result;
    }

    protected Set<Node> getTranscriptionReactions(Node node) {
        HashSet<Node> t = new HashSet<Node>();
        for (Edge edge : node.getUpstream()) {
            if (!edge.isTranscription()) continue;
            t.add((Node)edge.getSourceNode());
        }
        return t;
    }
}

