/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.cbio.causality.analysis.BranchDataProvider;
import org.cbio.causality.analysis.GeneBranch;
import org.cbio.causality.analysis.Graph;

public class DownstreamTree {
    private Graph trav;
    private Graph lastStep;
    private BranchDataProvider data;

    public DownstreamTree(Graph trav, Graph lastStep, BranchDataProvider data) {
        this.trav = trav;
        this.lastStep = lastStep;
        this.data = data;
    }

    public DownstreamTree(Graph trav, Graph lastStep) {
        this(trav, lastStep, null);
    }

    public DownstreamTree(Graph trav) {
        this(trav, null, null);
    }

    public GeneBranch getTree(String from, Collection<String> to, int limit) {
        GeneBranch result = new GeneBranch(from, this.data);
        HashMap<String, GeneBranch> map = new HashMap<String, GeneBranch>();
        map.put(from, result);
        HashMap<String, Integer> dist = new HashMap<String, Integer>();
        HashSet<String> visited = new HashSet<String>();
        HashSet<String> nonLeafVisited = new HashSet<String>();
        visited.add(from);
        nonLeafVisited.add(from);
        dist.put(from, 0);
        LinkedList<String> queue = new LinkedList<String>();
        queue.add(from);
        if (this.lastStep != null) {
            this.expandLastStep(map, dist, visited, from, from);
        }
        for (int i = 0; i < (this.lastStep == null ? limit : limit - 1) && !queue.isEmpty(); ++i) {
            ArrayList temp = new ArrayList(queue);
            queue.clear();
            for (String gene : temp) {
                assert (visited.contains(gene));
                assert (nonLeafVisited.contains(gene));
                assert (map.containsKey(gene));
                for (String down : this.trav.getDownstream(gene)) {
                    if (visited.contains(down)) {
                        if ((Integer)dist.get(down) != (Integer)dist.get(gene) + 1) continue;
                        ((GeneBranch)map.get((Object)gene)).branches.add((GeneBranch)map.get(down));
                        if (nonLeafVisited.contains(down)) continue;
                        queue.add(down);
                        nonLeafVisited.add(down);
                        continue;
                    }
                    dist.put(down, (Integer)dist.get(gene) + 1);
                    queue.add(down);
                    visited.add(down);
                    nonLeafVisited.add(down);
                    GeneBranch node = new GeneBranch(down, this.data, from);
                    ((GeneBranch)map.get((Object)gene)).branches.add(node);
                    map.put(down, node);
                }
            }
            if (this.lastStep == null) continue;
            for (String gene : queue) {
                this.expandLastStep(map, dist, visited, gene, from);
            }
        }
        result.removeNonTargetLeaf(to);
        if (this.lastStep != null) {
            result.removeAbsentLeafConnections(this.lastStep, true);
        }
        return result;
    }

    private void expandLastStep(Map<String, GeneBranch> map, Map<String, Integer> dist, Set<String> visited, String gene, String root) {
        for (String down : this.lastStep.getDownstream(gene)) {
            GeneBranch node;
            if (visited.contains(down)) {
                if (dist.get(down) != dist.get(gene) + 1) continue;
                node = map.get(down);
                map.get((Object)gene).branches.add(node);
                continue;
            }
            dist.put(down, dist.get(gene) + 1);
            visited.add(down);
            node = new GeneBranch(down, this.data, root);
            map.get((Object)gene).branches.add(node);
            map.put(down, node);
        }
    }
}

