/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.analysis;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.biopax.paxtools.pattern.miner.SIFInteraction;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.cbio.causality.util.CollectionUtil;
import org.cbio.causality.util.FDR;
import org.cbio.causality.util.FishersExactTest;
import org.cbio.causality.util.Histogram;

public class Graph
implements Serializable {
    private String edgeType;
    private String name;
    protected Map<String, Set<String>> dwMap = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> upMap = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> ppMap = new HashMap<String, Set<String>>();
    protected Map<String, Map<String, Set<String>>> mediators = new HashMap<String, Map<String, Set<String>>>();
    protected boolean allowSelfEdges = false;
    protected int mediatorColNumToRead = 3;

    public Graph(String name, String edgeType) {
        this();
        this.name = name;
        this.edgeType = edgeType;
    }

    public Graph() {
    }

    public void setMediatorColNumToRead(int mediatorColNumToRead) {
        this.mediatorColNumToRead = mediatorColNumToRead;
    }

    public boolean load(String filename, Set<String> ppiTypes, Set<String> signalTypes) {
        try {
            return this.load(new FileInputStream(filename), ppiTypes, signalTypes);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean load(InputStream is, Set<String> undirectedTypes, Set<String> directedTypes) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            while (line != null) {
                String[] token = line.split("\t");
                if (token.length >= 3) {
                    Boolean directed = null;
                    if (undirectedTypes.contains(token[1])) {
                        directed = false;
                    } else if (directedTypes.contains(token[1])) {
                        directed = true;
                    }
                    if (directed != null) {
                        if (token.length > this.mediatorColNumToRead) {
                            this.putRelation(token[0], token[2], token[this.mediatorColNumToRead], directed);
                        } else {
                            this.putRelation(token[0], token[2], directed);
                        }
                    }
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void load(Collection<SIFInteraction> sifs, SIFType ... typeArray) {
        HashSet<SIFType> types = typeArray.length == 0 ? null : new HashSet<SIFType>(Arrays.asList(typeArray));
        for (SIFInteraction sif : sifs) {
            if (types != null && !types.contains(sif.type)) continue;
            this.putRelation(sif.sourceID, sif.targetID, sif.type.isDirected());
        }
    }

    public void write(String filename) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            this.write(writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(Writer writer) {
        try {
            for (String g1 : this.dwMap.keySet()) {
                for (String g2 : this.dwMap.get(g1)) {
                    writer.write(g1 + "\t" + this.edgeType + "\t" + g2);
                    if (this.mediators.containsKey(g1) && this.mediators.get(g1).containsKey(g2)) {
                        writer.write("\t" + this.convertMediatorsToString(this.mediators.get(g1).get(g2)));
                    }
                    writer.write("\n");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getMediatorsInString(String source, String target) {
        String s = "";
        if (this.mediators.containsKey(source) && this.mediators.get(source).containsKey(target)) {
            s = s + this.convertMediatorsToString(this.mediators.get(source).get(target));
        }
        if (this.isUndirected() && this.mediators.containsKey(target) && this.mediators.get(target).containsKey(source)) {
            s = s + " " + this.convertMediatorsToString(this.mediators.get(target).get(source));
        }
        return s.trim();
    }

    private String convertMediatorsToString(Set<String> set) {
        StringBuilder sb = new StringBuilder();
        for (String s : set) {
            sb.append(s).append(" ");
        }
        return sb.toString().trim();
    }

    public void clear() {
        this.upMap.clear();
        this.dwMap.clear();
        this.ppMap.clear();
    }

    public void putRelation(String source, String target, String mediatorsStr, boolean directed) {
        this.putRelation(source, target, directed);
        if (!this.mediators.containsKey(source)) {
            this.mediators.put(source, new HashMap());
        }
        if (!this.mediators.get(source).containsKey(target)) {
            this.mediators.get(source).put(target, new HashSet());
        }
        this.mediators.get(source).get(target).addAll(Arrays.asList(mediatorsStr.split(" |;")));
    }

    public void putRelation(String source, String target, boolean directed) {
        if (!this.allowSelfEdges && source.equals(target)) {
            return;
        }
        if (directed) {
            if (!this.upMap.containsKey(target)) {
                this.upMap.put(target, new HashSet());
            }
            if (!this.dwMap.containsKey(source)) {
                this.dwMap.put(source, new HashSet());
            }
            this.upMap.get(target).add(source);
            this.dwMap.get(source).add(target);
        } else {
            if (!this.ppMap.containsKey(source)) {
                this.ppMap.put(source, new HashSet());
            }
            if (!this.ppMap.containsKey(target)) {
                this.ppMap.put(target, new HashSet());
            }
            this.ppMap.get(source).add(target);
            this.ppMap.get(target).add(source);
        }
    }

    public boolean isDirected() {
        return !this.upMap.isEmpty();
    }

    public boolean isUndirected() {
        return !this.ppMap.isEmpty();
    }

    public String getEdgeType() {
        return this.edgeType;
    }

    public void setEdgeType(String edgeType) {
        this.edgeType = edgeType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> goBFS(String seed, boolean downstream) {
        return this.goBFS(seed, downstream ? this.dwMap : this.upMap);
    }

    public Set<String> goBFS(Set<String> seed, Set<String> visited, boolean downstream) {
        return this.goBFS(seed, visited, downstream ? this.dwMap : this.upMap);
    }

    public Set<String> goBFS(Set<String> seed, Set<String> visited) {
        return this.goBFS(seed, visited, this.ppMap);
    }

    protected Set<String> goBFS(String seed, Map<String, Set<String>> map) {
        return this.goBFS(Collections.singleton(seed), null, map);
    }

    protected Set<String> goBFS(Set<String> seed, Set<String> visited, Map<String, Set<String>> map) {
        HashSet<String> neigh = new HashSet<String>();
        for (String s : seed) {
            if (!map.containsKey(s)) continue;
            for (String n : map.get(s)) {
                if (visited != null && visited.contains(n)) continue;
                neigh.add(n);
            }
        }
        return neigh;
    }

    public Set<String> getUpstream(Collection<String> genes) {
        return this.getStream(genes, true);
    }

    public Set<String> getDownstream(Collection<String> genes) {
        return this.getStream(genes, false);
    }

    protected Set<String> getStream(Collection<String> genes, boolean upstream) {
        HashSet<String> result = new HashSet<String>();
        for (String gene : genes) {
            result.addAll(upstream ? this.getUpstream(gene) : this.getDownstream(gene));
        }
        return result;
    }

    public Set<String> getUpstream(String gene) {
        if (this.upMap.containsKey(gene)) {
            return this.upMap.get(gene);
        }
        return Collections.emptySet();
    }

    public Set<String> getUpstream(String gene, int depth) {
        return this.getUpstream(Collections.singleton(gene), depth);
    }

    public Set<String> getUpstream(Set<String> genes, int depth) {
        return this.getStream(genes, true, depth);
    }

    public Set<String> getUpstream(Set<String> genes) {
        HashSet<String> result = new HashSet<String>();
        for (String gene : genes) {
            result.addAll(this.getUpstream(gene));
        }
        return result;
    }

    public Set<String> getDownstream(String gene, int depth) {
        return this.getDownstream(Collections.singleton(gene), depth);
    }

    public Set<String> getDownstream(Set<String> genes, int depth) {
        return this.getStream(genes, false, depth);
    }

    public Set<String> getBothstream(String gene, int depth) {
        return this.getBothstream(Collections.singleton(gene), depth);
    }

    public Set<String> getBothstream(Set<String> genes, int depth) {
        Set<String> stream = this.getStream(genes, true, depth);
        stream.addAll(this.getStream(genes, false, depth));
        return stream;
    }

    private Set<String> getStream(Set<String> genes, boolean upstream, int depth) {
        if (depth < 1) {
            return new HashSet<String>();
        }
        Set<String> newSet = new HashSet<String>(genes);
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < depth; ++i) {
            newSet = upstream ? this.getUpstream(newSet) : this.getDownstream(newSet);
            newSet.removeAll(result);
            result.addAll(newSet);
        }
        return result;
    }

    public Set<String> getDownstream(String gene) {
        if (this.dwMap.containsKey(gene)) {
            return this.dwMap.get(gene);
        }
        return Collections.emptySet();
    }

    public Set<String> getNeighbors(String gene) {
        HashSet<String> n = new HashSet<String>();
        if (this.ppMap.get(gene) != null) {
            n.addAll((Collection)this.ppMap.get(gene));
        }
        if (this.upMap.get(gene) != null) {
            n.addAll((Collection)this.upMap.get(gene));
        }
        if (this.dwMap.get(gene) != null) {
            n.addAll((Collection<String>)this.dwMap.get(gene));
        }
        return n;
    }

    public Set<String> getNeighbors(Set<String> genes) {
        HashSet<String> n = new HashSet<String>();
        for (String gene : genes) {
            n.addAll(this.getNeighbors(gene));
        }
        return n;
    }

    public List<Set<String>> getNeighborsTiered(Set<String> genes, int depth, boolean upstream) {
        ArrayList<Set<String>> list = new ArrayList<Set<String>>();
        for (int i = 1; i <= depth; ++i) {
            Set<String> stream = this.getStream(genes, upstream, i);
            for (Set set : list) {
                stream.removeAll(set);
            }
            list.add(stream);
        }
        return list;
    }

    public Set<String> getConnectedComponent(String node) {
        HashSet<String> n2;
        HashSet<String> comp = new HashSet<String>();
        Set<String> newGenes = this.getNeighbors(node);
        do {
            n2 = new HashSet<String>();
            for (String gene : newGenes) {
                n2.addAll(this.getNeighbors(gene));
            }
            comp.addAll(newGenes);
            n2.removeAll(comp);
        } while (!(newGenes = n2).isEmpty());
        return comp;
    }

    public Set<String> getGenesWithCommonDownstream(String gene) {
        Set<String> up = this.getUpstream(gene);
        Set<String> dw = this.getDownstream(gene);
        Set<String> ot = this.getUpstream(dw);
        HashSet<String> result = new HashSet<String>(up);
        result.addAll(dw);
        result.addAll(ot);
        return result;
    }

    public Set<String> getGenesWithCommonDownstream(Set<String> genes) {
        Set<String> up = this.getUpstream(genes);
        Set<String> dw = this.getDownstream(genes);
        Set<String> ot = this.getUpstream(dw);
        HashSet<String> result = new HashSet<String>(up);
        result.addAll(dw);
        result.addAll(ot);
        return result;
    }

    public int getDegree(String gene) {
        return this.getNeighbors(gene).size();
    }

    public Set<String> getPathElements(String from, Set<String> to, int limit) {
        HashSet<String> result = new HashSet<String>();
        this.getPathElements(from, to, limit, 0, result);
        return result;
    }

    private void getPathElements(String from, Set<String> to, int limit, int i, Set<String> result) {
        Set<String> set = Collections.singleton(from);
        Set<String> neigh = this.goBFS(set, set, true);
        for (String n : neigh) {
            if (to.contains(n)) {
                result.add(n);
                continue;
            }
            if (i >= limit) continue;
            int prevSize = result.size();
            this.getPathElements(n, to, limit, i + 1, result);
            if (result.size() <= prevSize) continue;
            result.add(n);
        }
    }

    public List<CommPoint> getCommonDownstream(Set<String> seed, int limit) {
        HashMap<String, HashSet<String>> reachMap = new HashMap<String, HashSet<String>>();
        HashMap<String, Set<String>> breadthMap = new HashMap<String, Set<String>>();
        HashMap<String, HashSet<String>> visitedMap = new HashMap<String, HashSet<String>>();
        HashSet<CommPoint> points = new HashSet<CommPoint>();
        for (String s : seed) {
            reachMap.put(s, new HashSet<String>(Arrays.asList(s)));
            breadthMap.put(s, new HashSet<String>(Arrays.asList(s)));
            visitedMap.put(s, new HashSet<String>(Arrays.asList(s)));
        }
        for (int i = 1; i < limit; ++i) {
            for (String s : seed) {
                Set<String> neigh = this.goBFS((Set<String>)((Set)breadthMap.get(s)), (Set<String>)((Set)visitedMap.get(s)), true);
                for (String n : neigh) {
                    if (!reachMap.containsKey(n)) {
                        reachMap.put(n, new HashSet<String>(Arrays.asList(s)));
                        continue;
                    }
                    ((Set)reachMap.get(n)).add(s);
                }
                breadthMap.put(s, neigh);
                ((Set)visitedMap.get(s)).addAll(neigh);
            }
            for (String r : reachMap.keySet()) {
                CommPoint p;
                if (((Set)reachMap.get(r)).size() <= 1 || this.containsBetter(points, p = new CommPoint(r, (Set)reachMap.get(r), i))) continue;
                points.add(p);
            }
        }
        ArrayList<CommPoint> list = new ArrayList<CommPoint>(points);
        Collections.sort(list);
        return list;
    }

    private boolean containsBetter(Set<CommPoint> set, CommPoint p) {
        if (set.contains(p)) {
            return true;
        }
        for (CommPoint cp : set) {
            if (cp.dist >= p.dist || !cp.upstr.containsAll(p.upstr)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getOneSideSymbols(boolean source) {
        HashSet<String> syms = new HashSet<String>();
        syms.addAll(source ? this.dwMap.keySet() : this.upMap.keySet());
        return syms;
    }

    public Set<String> getSymbols() {
        Set<String> symbols = this.getSymbols(true);
        symbols.addAll(this.getSymbols(false));
        return symbols;
    }

    public Set<String> getSymbols(boolean directed) {
        HashSet<String> syms = new HashSet<String>();
        if (directed) {
            syms.addAll(this.upMap.keySet());
            syms.addAll(this.dwMap.keySet());
        } else {
            syms.addAll(this.ppMap.keySet());
        }
        return syms;
    }

    public Set<String> getLinkedCommonDownstream(Set<String> seed) {
        HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
        for (String s : seed) {
            map.put(s, new HashSet<String>(this.getDownstream(s)));
            ((Set)map.get(s)).add(s);
        }
        boolean loop = true;
        while (loop) {
            loop = false;
            for (String s1 : seed) {
                for (String s2 : seed) {
                    if (s1.equals(s2) || !((Set)map.get(s2)).contains(s1)) continue;
                    boolean changed = ((Set)map.get(s2)).addAll((Collection)map.get(s1));
                    loop = changed || loop;
                }
            }
        }
        HashSet[] sets = map.values().toArray(new HashSet[map.values().size()]);
        HashSet<String> result = new HashSet<String>(sets[0]);
        for (int i = 1; i < sets.length; ++i) {
            result.retainAll(sets[i]);
        }
        return result;
    }

    public Map<Integer, Integer> getDegreeDistibution(boolean indegree) {
        HashMap<Integer, Integer> dist = new HashMap<Integer, Integer>();
        this.collectDegrees(dist, indegree ? this.upMap : this.dwMap);
        return dist;
    }

    public Map<Integer, Integer> getDegreeDistibution() {
        HashMap<Integer, Integer> dist = new HashMap<Integer, Integer>();
        this.collectDegrees(dist, this.upMap);
        this.collectDegrees(dist, this.dwMap);
        this.collectDegrees(dist, this.ppMap);
        return dist;
    }

    private void collectDegrees(Map<Integer, Integer> dist, Map<String, Set<String>> map) {
        for (Set<String> set : map.values()) {
            int degree = set.size();
            if (!dist.containsKey(degree)) {
                dist.put(degree, 1);
                continue;
            }
            dist.put(degree, dist.get(degree) + 1);
        }
    }

    public int getEdgeCount(boolean directed) {
        int edgeCnt = 0;
        if (directed) {
            for (Set<String> set : this.upMap.values()) {
                edgeCnt += set.size();
            }
            return edgeCnt;
        }
        for (Set<String> set : this.ppMap.values()) {
            edgeCnt += set.size();
        }
        return edgeCnt /= 2;
    }

    public void printStats() {
        int edgeCnt;
        Set<String> syms;
        System.out.println(this.name + " [" + this.edgeType + "]");
        if (!this.ppMap.isEmpty()) {
            syms = this.getSymbols(false);
            edgeCnt = this.getEdgeCount(false);
            System.out.println("Undirected graph: " + syms.size() + " genes and " + edgeCnt + " edges");
        }
        if (!this.upMap.isEmpty() || !this.dwMap.isEmpty()) {
            syms = this.getSymbols(true);
            edgeCnt = this.getEdgeCount(true);
            System.out.println("Directed graph: " + syms.size() + " genes (source: " + this.dwMap.keySet().size() + ", target: " + this.upMap.keySet().size() + ") and " + edgeCnt + " edges");
        }
    }

    public void merge(Graph graph) {
        this.merge(this.ppMap, graph.ppMap);
        this.merge(this.upMap, graph.upMap);
        this.merge(this.dwMap, graph.dwMap);
        for (String gene : graph.mediators.keySet()) {
            if (!this.mediators.containsKey(gene)) {
                this.mediators.put(gene, new HashMap());
            }
            this.merge(this.mediators.get(gene), graph.mediators.get(gene));
        }
    }

    private void merge(Map<String, Set<String>> m1, Map<String, Set<String>> m2) {
        for (String s : m2.keySet()) {
            if (!m1.containsKey(s)) {
                m1.put(s, new HashSet());
            }
            m1.get(s).addAll((Collection<String>)m2.get(s));
        }
    }

    public Graph copy() {
        Graph copy = new Graph(this.name, this.edgeType);
        for (String s : this.ppMap.keySet()) {
            copy.ppMap.put(s, new HashSet(this.ppMap.get(s)));
        }
        for (String s : this.upMap.keySet()) {
            copy.upMap.put(s, new HashSet(this.upMap.get(s)));
        }
        for (String s : this.dwMap.keySet()) {
            copy.dwMap.put(s, new HashSet(this.dwMap.get(s)));
        }
        return copy;
    }

    public Graph changeTo(boolean directed) {
        Map<String, Set<String>> map = directed ? this.upMap : this.ppMap;
        for (String g1 : map.keySet()) {
            for (String g2 : map.get(g1)) {
                this.putRelation(g1, g2, directed);
            }
        }
        map.clear();
        if (!directed) {
            this.dwMap.clear();
        }
        return this;
    }

    public void crop(Collection<String> symbols) {
        this.crop(this.ppMap, symbols);
        this.crop(this.upMap, symbols);
        this.crop(this.dwMap, symbols);
    }

    private void crop(Map<String, Set<String>> map, Collection<String> symbols) {
        HashSet<String> remKeys = new HashSet<String>();
        for (String s : map.keySet()) {
            if (!symbols.contains(s)) {
                remKeys.add(s);
                continue;
            }
            map.get(s).retainAll(symbols);
            if (!map.get(s).isEmpty()) continue;
            remKeys.add(s);
        }
        for (String key : remKeys) {
            map.remove(key);
        }
    }

    public void printVennIntersections(boolean directed, Graph ... gArray) {
        System.out.println("directed = " + directed);
        ArrayList<Graph> graphs = new ArrayList<Graph>(gArray.length + 1);
        graphs.add(this);
        Collections.addAll(graphs, gArray);
        ArrayList<Set<String>> relList = new ArrayList<Set<String>>();
        for (Graph graph : graphs) {
            relList.add(graph.getRelationStrings(directed));
        }
        int i = 65;
        for (Graph graph : graphs) {
            System.out.println((char)i++ + "\t" + graph.getName());
        }
        CollectionUtil.printVennCounts(relList.toArray(new Collection[relList.size()]));
    }

    protected Set<String> getRelationStrings(boolean directed) {
        HashSet<String> set = new HashSet<String>();
        if (directed) {
            for (String targ : this.upMap.keySet()) {
                for (String sour : this.upMap.get(targ)) {
                    set.add(sour + " " + targ);
                }
            }
        } else {
            for (String g1 : this.ppMap.keySet()) {
                for (String g2 : this.ppMap.get(g1)) {
                    if (g1.compareTo(g2) >= 0) continue;
                    set.add(g1 + " " + g2);
                }
            }
        }
        return set;
    }

    public void printVennIntersections(Graph ... graph) {
        if (this.isDirected()) {
            this.printVennIntersections(true, graph);
        }
        if (this.isUndirected()) {
            this.printVennIntersections(false, graph);
        }
    }

    public Set<String> toString(Set<String> from, Set<String> to) {
        HashSet<String> result = new HashSet<String>();
        for (String f : from) {
            for (String t : this.getDownstream(f)) {
                if (!to.contains(t)) continue;
                result.add(f + "\t" + this.edgeType + "\t" + t);
            }
        }
        return result;
    }

    public List<String> getEnrichedGenes(Set<String> query, Set<String> background, double fdrThr, NeighborType type, int distance) {
        Graph graph = this;
        if (background != null) {
            graph = this.copy();
            graph.crop(background);
        }
        background = graph.getSymbols();
        int n = background.size();
        query = new HashSet<String>(query);
        query.retainAll(background);
        int qSize = query.size();
        HashMap<String, Double> pvals = new HashMap<String, Double>();
        HashMap<String, Double> limit = new HashMap<String, Double>();
        for (String gene : background) {
            Set<String> neighbors = type == NeighborType.UPSTREAM ? graph.getUpstream(gene, distance) : (type == NeighborType.DOWNSTREAM ? graph.getDownstream(gene, distance) : graph.getBothstream(gene, distance));
            neighbors = new HashSet<String>(neighbors);
            neighbors.add(gene);
            int nSize = neighbors.size();
            neighbors.retainAll(query);
            int o = neighbors.size();
            pvals.put(gene, FishersExactTest.calcEnrichmentPval(n, qSize, nSize, o));
            limit.put(gene, FishersExactTest.calcEnrichmentPval(n, qSize, nSize, Math.min(qSize, nSize)));
        }
        if (fdrThr < 0.0) {
            fdrThr = FDR.decideBestFDR_BH(pvals, limit);
            System.out.println("fdrThr = " + fdrThr);
        }
        return FDR.select(pvals, limit, fdrThr);
    }

    public void printDegreeDistribution(int bins) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String node : this.getSymbols()) {
            Set<String> neighbors = this.getNeighbors(node);
            list.add(neighbors.size());
        }
        int max = CollectionUtil.maxIntInList(list);
        Histogram h = new Histogram((double)max / (double)bins);
        h.setBorderAtZero(true);
        for (Integer v : list) {
            h.count(v.intValue());
        }
        h.print();
    }

    public Graph cropToDegree(int minDegree) {
        HashSet<String> keep = new HashSet<String>();
        for (String node : this.getSymbols()) {
            Set<String> neighbors = this.getNeighbors(node);
            if (neighbors.size() < minDegree) continue;
            keep.add(node);
        }
        Graph g = this.copy();
        g.crop(keep);
        return g;
    }

    public static void main(String[] args) throws FileNotFoundException {
        Graph g = new Graph();
        g.load(new FileInputStream("../biopax-pattern/DeltaFeatures.txt"), Collections.<String>emptySet(), Collections.singleton(SIFEnum.CONTROLS_STATE_CHANGE_OF.getTag()));
        g.printStats();
    }

    public static enum NeighborType {
        UPSTREAM,
        DOWNSTREAM,
        BOTHSTREAM;

    }

    class CommPoint
    implements Comparable {
        String s;
        Set<String> upstr;
        int dist;

        CommPoint(String s, Set<String> upstr, int dist) {
            this.s = s;
            this.upstr = upstr;
            this.dist = dist;
        }

        public boolean equals(Object o) {
            if (o instanceof CommPoint) {
                CommPoint p = (CommPoint)o;
                if (p.s.equals(this.s) && p.upstr.containsAll(this.upstr) && this.upstr.containsAll(p.upstr) && p.dist == this.dist) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public int compareTo(Object o) {
            if (o instanceof CommPoint) {
                CommPoint p = (CommPoint)o;
                new Integer(p.upstr.size()).compareTo(this.upstr.size());
            }
            return 0;
        }
    }
}

