/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.analysis;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.cbio.causality.analysis.Graph;

public class SIFLinker {
    protected Map<String, Map<String, Set<String>>> sif;
    public Graph graph;

    public boolean load(String filename) {
        try {
            return this.load(new FileInputStream(filename), SIFEnum.CONTROLS_STATE_CHANGE_OF.getTag(), SIFEnum.CONTROLS_EXPRESSION_OF.getTag());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean load(Graph g) {
        if (this.graph == null) {
            this.graph = new Graph();
        }
        this.graph.merge(g);
        if (this.sif == null) {
            this.sif = new HashMap<String, Map<String, Set<String>>>();
        }
        for (String up : g.getSymbols()) {
            for (String dw : g.getDownstream(up)) {
                if (!this.sif.containsKey(up)) {
                    this.sif.put(up, new HashMap());
                }
                if (!this.sif.get(up).containsKey(g.getEdgeType())) {
                    this.sif.get(up).put(g.getEdgeType(), new HashSet());
                }
                this.sif.get(up).get(g.getEdgeType()).add(dw);
            }
        }
        return true;
    }

    public boolean load(InputStream is, String ... directedTypes) {
        try {
            byte[] content = this.getBytes(is);
            if (this.graph == null) {
                this.graph = new Graph();
            }
            this.graph.load(new ByteArrayInputStream(content), new HashSet<String>(), new HashSet<String>(Arrays.asList(directedTypes)));
            if (this.sif == null) {
                this.sif = new HashMap<String, Map<String, Set<String>>>();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(content)));
            String line = reader.readLine();
            while (line != null) {
                String[] token = line.split("\t");
                if (!this.sif.containsKey(token[0])) {
                    this.sif.put(token[0], new HashMap());
                }
                if (!this.sif.get(token[0]).containsKey(token[1])) {
                    this.sif.get(token[0]).put(token[1], new HashSet());
                }
                this.sif.get(token[0]).get(token[1]).add(token[2]);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private byte[] getBytes(InputStream is) throws IOException {
        int n;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((n = is.read(buf)) >= 0) {
            baos.write(buf, 0, n);
        }
        return baos.toByteArray();
    }

    public List<String> linkMinimal(Set<String> set, int limit) {
        ArrayList<String> rels = new ArrayList<String>();
        HashSet<String> linked = new HashSet<String>();
        for (int i = 0; i <= limit && linked.size() < set.size(); ++i) {
            for (String s1 : set) {
                for (String s2 : set) {
                    List<String> rel;
                    if (s1.equals(s2) || linked.contains(s1) && linked.contains(s2) || (rel = this.link(Collections.singleton(s1), Collections.singleton(s2), i)).isEmpty()) continue;
                    rels.addAll(rel);
                    linked.add(s1);
                    linked.add(s2);
                }
            }
        }
        return rels;
    }

    public List<String> linkProgressive(Set<String> from, Set<String> to, int limit) {
        ArrayList<String> rels = new ArrayList<String>();
        for (String s1 : from) {
            block1: for (String s2 : to) {
                for (int i = 0; i <= limit; ++i) {
                    List<String> rel;
                    if (s1.equals(s2) || (rel = this.link(Collections.singleton(s1), Collections.singleton(s2), i)).isEmpty()) continue;
                    for (String s : rel) {
                        if (rels.contains(s)) continue;
                        rels.add(s);
                    }
                    continue block1;
                }
            }
        }
        return rels;
    }

    public List<String> link(Set<String> from, Set<String> to, int limit) {
        ArrayList<String> rels = new ArrayList<String>();
        for (String s : from) {
            Set<String> eles = this.graph.getPathElements(s, to, limit);
            eles.add(s);
            for (String ele : eles) {
                if (!this.sif.containsKey(ele)) continue;
                for (String type : this.sif.get(ele).keySet()) {
                    for (String tar2 : this.sif.get(ele).get(type)) {
                        String rel;
                        if (!eles.contains(tar2) || tar2.equals(ele) || rels.contains(rel = ele + "\t" + type + "\t" + tar2)) continue;
                        rels.add(rel);
                    }
                }
            }
        }
        return rels;
    }

    public List<String> linkCommonDownstream(Set<String> seed, int limit) {
        ArrayList<String> rels = new ArrayList<String>();
        List<Graph.CommPoint> points = this.graph.getCommonDownstream(seed, limit);
        HashSet<Graph.CommPoint> select = new HashSet<Graph.CommPoint>();
        HashSet<String> covered = new HashSet<String>();
        for (Graph.CommPoint p : points) {
            select.add(p);
            covered.addAll(p.upstr);
        }
        for (Graph.CommPoint p : select) {
            List<String> link = this.linkProgressive(p.upstr, Collections.singleton(p.s), p.dist);
            for (String l : link) {
                if (rels.contains(l)) continue;
                rels.add(l);
            }
        }
        return rels;
    }

    public static void main(String[] args) {
        SIFLinker linker = new SIFLinker();
        linker.load("/home/ozgun/Desktop/SIF.txt");
        HashSet<String> set = new HashSet<String>(Arrays.asList("IFNA2  TP53".split("  ")));
        List<String> rels = linker.link(Collections.singleton("IFNA2"), Collections.singleton("TP53"), 3);
        for (String rel : rels) {
            System.out.println(rel);
        }
    }
}

