/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.binintanalysis;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.cbio.causality.analysis.ComponentSorter;
import org.cbio.causality.analysis.Graph;
import org.cbio.causality.binintanalysis.Dataset1;
import org.cbio.causality.data.portal.BroadAccessor;
import org.cbio.causality.data.portal.CBioPortalAccessor;
import org.cbio.causality.data.portal.ExpDataManager;
import org.cbio.causality.model.Alteration;
import org.cbio.causality.model.AlterationPack;
import org.cbio.causality.model.Change;
import org.cbio.causality.network.PathwayCommons;
import org.cbio.causality.util.FDR;
import org.cbio.causality.util.FishersExactTest;
import org.cbio.causality.util.StudentsT;
import org.cbio.causality.util.Summary;

public class DifferentiallyExpressedComponentFinder {
    private Graph graph;
    private Dataset1 dataset;
    CBioPortalAccessor portalAcc;
    ExpDataManager expMan;
    Map<String, Map<String, Double>> expPvals;
    Map<String, Map<String, Double>> expSigPvals;
    Map<String, Map<String, Double>> enrichSigPvals;
    Map<String, Map<String, Boolean>> targetChange;
    Map<String, List<Set<String>>> compsUp;
    Map<String, List<Set<String>>> compsDw;
    Set<String> mutsig;
    double mutsigThr;
    double fdrThr;
    int componentSizeThr;
    private static final int MIN_GROUP_SIZE = 1;

    public static void main(String[] args) throws IOException {
        DifferentiallyExpressedComponentFinder finder = new DifferentiallyExpressedComponentFinder(Dataset1.UCEC, 0.05, 0.05, 2);
        finder.calcDiffExpPvals();
        finder.calcComponents();
        finder.writeComponents();
    }

    public DifferentiallyExpressedComponentFinder(Dataset1 dataset, double mutsigThr, double fdrThr, int componentSizeThr) throws IOException {
        this.dataset = dataset;
        this.mutsigThr = mutsigThr;
        this.fdrThr = fdrThr;
        this.componentSizeThr = componentSizeThr;
        this.loadNetwork();
        this.loadData();
    }

    private void loadNetwork() {
        this.graph = PathwayCommons.getGraph(SIFEnum.CONTROLS_STATE_CHANGE_OF);
    }

    private void loadData() throws IOException {
        this.portalAcc = new CBioPortalAccessor(this.dataset.mutCnCallExpZ);
        this.expMan = new ExpDataManager(this.portalAcc.getGeneticProfileById(this.dataset.exp.getProfileID()[0]), this.portalAcc.getCaseListById(this.dataset.exp.getCaseListID()));
        this.mutsig = BroadAccessor.getMutsigGenes(this.dataset.code(), this.mutsigThr, true);
        this.removeMutsigWithMissingData();
        System.out.println("mutsig in network = " + this.mutsig.size());
    }

    private void removeMutsigWithMissingData() {
        Iterator<String> iter = this.mutsig.iterator();
        while (iter.hasNext()) {
            String ms = iter.next();
            AlterationPack alts = this.portalAcc.getAlterations(ms);
            if (alts == null) {
                iter.remove();
                continue;
            }
            if (alts.get(Alteration.MUTATION) != null && alts.get(Alteration.COPY_NUMBER) != null && alts.get(Alteration.EXPRESSION) != null) continue;
            iter.remove();
        }
    }

    private double calcDiffPval(String symbol, boolean[] set1, boolean[] set2) {
        double[] exp = this.expMan.get(symbol);
        if (exp == null) {
            return Double.NaN;
        }
        boolean[] cnUnchanged = this.getCopyNumberUnchanged(symbol);
        if (cnUnchanged == null) {
            return Double.NaN;
        }
        double[] vals1 = this.getSubset(exp, set1, cnUnchanged);
        double[] vals2 = this.getSubset(exp, set2, cnUnchanged);
        if (vals1.length < 1 || vals2.length < 1) {
            return Double.NaN;
        }
        return StudentsT.getPValOfMeanDifference(vals1, vals2);
    }

    private double calcMeanChange(String symbol, boolean[] set1, boolean[] set2) {
        double[] exp = this.expMan.get(symbol);
        if (exp == null) {
            return Double.NaN;
        }
        boolean[] cnUnchanged = this.getCopyNumberUnchanged(symbol);
        if (cnUnchanged == null) {
            return Double.NaN;
        }
        double[] vals1 = this.getSubset(exp, set1, cnUnchanged);
        double[] vals2 = this.getSubset(exp, set2, cnUnchanged);
        if (vals1.length < 1 || vals2.length < 1) {
            return Double.NaN;
        }
        return Summary.calcChangeOfMean(vals1, vals2);
    }

    private double[] getSubset(double[] vals, boolean[] inds, boolean[] cnUnchanged) {
        ArrayList<Double> list = new ArrayList<Double>(vals.length);
        for (int i = 0; i < vals.length; ++i) {
            if (!inds[i] || !cnUnchanged[i] || Double.isNaN(vals[i])) continue;
            list.add(vals[i]);
        }
        double[] sub = new double[list.size()];
        for (int i = 0; i < sub.length; ++i) {
            sub[i] = (Double)list.get(i);
        }
        return sub;
    }

    private boolean[] getCopyNumberUnchanged(String symbol) {
        AlterationPack alts = this.portalAcc.getAlterations(symbol);
        if (alts == null) {
            return null;
        }
        Change[] cnc = alts.get(Alteration.COPY_NUMBER);
        if (cnc == null) {
            return null;
        }
        boolean[] b = new boolean[cnc.length];
        for (int i = 0; i < b.length; ++i) {
            b[i] = !cnc[i].isAltered() && !cnc[i].isAbsent();
        }
        return b;
    }

    private boolean[] selectSubset(String symbol, boolean mutated) {
        AlterationPack alts = this.portalAcc.getAlterations(symbol);
        if (alts == null) {
            return null;
        }
        Change[] muts = alts.get(Alteration.MUTATION);
        Change[] cncs = alts.get(Alteration.COPY_NUMBER);
        Change[] expz = alts.get(Alteration.EXPRESSION);
        if (muts == null || cncs == null || expz == null) {
            return null;
        }
        boolean[] x = new boolean[alts.getSize()];
        for (int i = 0; i < x.length; ++i) {
            x[i] = (mutated ? muts[i].isAltered() : muts[i] == Change.NO_CHANGE) && cncs[i] != Change.INHIBITING && expz[i] != Change.INHIBITING && !cncs[i].isAbsent() && !expz[i].isAbsent();
        }
        return x;
    }

    public void calcDiffExpPvals() {
        this.targetChange = new HashMap<String, Map<String, Boolean>>();
        this.expPvals = new HashMap<String, Map<String, Double>>();
        this.expSigPvals = new HashMap<String, Map<String, Double>>();
        for (String mut : this.mutsig) {
            boolean[] normal = this.selectSubset(mut, false);
            boolean[] mutated = this.selectSubset(mut, true);
            if (normal == null || mutated == null) continue;
            HashMap<String, Double> pv = new HashMap<String, Double>();
            HashMap<String, Boolean> tc = new HashMap<String, Boolean>();
            for (String sym : this.graph.getSymbols()) {
                double pval = this.calcDiffPval(sym, normal, mutated);
                if (Double.isNaN(pval)) continue;
                pv.put(sym, pval);
                tc.put(sym, Math.signum(this.calcMeanChange(sym, normal, mutated)) > 0.0);
            }
            this.expPvals.put(mut, pv);
            this.targetChange.put(mut, tc);
            List<String> result = FDR.select(pv, null, this.fdrThr);
            if (!result.isEmpty()) {
                this.expSigPvals.put(mut, new HashMap());
            }
            for (String gene : result) {
                this.expSigPvals.get(mut).put(gene, (Double)pv.get(gene));
            }
        }
        this.enrichSigPvals = new HashMap<String, Map<String, Double>>();
        for (String mut : this.expSigPvals.keySet()) {
            this.enrichSigPvals.put(mut, new HashMap());
            HashMap<String, Double> pv = new HashMap<String, Double>();
            HashMap<String, Double> lim = new HashMap<String, Double>();
            for (String target : this.expSigPvals.get(mut).keySet()) {
                Set<String> neighs = this.graph.getNeighbors(target);
                neighs = this.graph.getNeighbors(neighs);
                neighs.retainAll(this.expPvals.get(mut).keySet());
                int total = this.expPvals.get(mut).size();
                int featured = this.expSigPvals.get(mut).size();
                int selected = neighs.size();
                neighs.retainAll(this.expSigPvals.get(mut).keySet());
                int featuredSelected = neighs.size();
                pv.put(target, FishersExactTest.calcEnrichmentPval(total, featured, selected, featuredSelected));
                lim.put(target, FishersExactTest.calcEnrichmentPval(total, featured, selected, Math.min(selected, featured)));
            }
            List<String> select = FDR.select(pv, lim, this.fdrThr);
            for (String target : select) {
                this.enrichSigPvals.get(mut).put(target, (Double)pv.get(target));
            }
        }
    }

    public void calcComponents() {
        this.compsUp = new HashMap<String, List<Set<String>>>();
        this.compsDw = new HashMap<String, List<Set<String>>>();
        for (String mut : this.enrichSigPvals.keySet()) {
            HashSet<String> up = new HashSet<String>();
            HashSet<String> dw = new HashSet<String>();
            for (String target : this.enrichSigPvals.get(mut).keySet()) {
                if (this.targetChange.get(mut).get(target).booleanValue()) {
                    up.add(target);
                    continue;
                }
                dw.add(target);
            }
            ComponentSorter sorter = new ComponentSorter(up, this.graph);
            List<Set<String>> components = sorter.getComponents(this.componentSizeThr);
            if (!components.isEmpty()) {
                this.compsUp.put(mut, components);
            }
            if ((components = (sorter = new ComponentSorter(dw, this.graph)).getComponents(this.componentSizeThr)).isEmpty()) continue;
            this.compsDw.put(mut, components);
        }
        HashSet<String> resultGeneratingMuts = new HashSet<String>(this.compsUp.keySet());
        resultGeneratingMuts.addAll(this.compsDw.keySet());
        System.out.println("Result generated for " + resultGeneratingMuts.size() + " mutators");
    }

    public void writeComponents() throws IOException {
        this.writeComponents(this.compsUp, "-up");
        this.writeComponents(this.compsDw, "-dw");
    }

    public void writeComponents(Map<String, List<Set<String>>> comps, String add) throws IOException {
        String dir = "temp/components/";
        new File(dir).mkdirs();
        for (String mut : comps.keySet()) {
            if (comps.get(mut).isEmpty()) continue;
            BufferedWriter w1 = new BufferedWriter(new FileWriter(dir + mut + add + ".sif"));
            BufferedWriter w2 = new BufferedWriter(new FileWriter(dir + mut + add + ".format"));
            for (Set<String> comp : comps.get(mut)) {
                for (String g1 : comp) {
                    Set<String> neighs = this.graph.isDirected() ? this.graph.getDownstream(g1) : this.graph.getNeighbors(g1);
                    for (String g2 : comp) {
                        if (this.graph.isUndirected() && g2.compareTo(g1) < 0 || !neighs.contains(g2)) continue;
                        w1.write(g1 + "\t" + this.graph.getEdgeType() + "\t" + g2 + "\n");
                    }
                    w2.write("node\t" + g1 + "\tcolor\t" + this.val2Color(this.expPvals.get(mut).get(g1), this.targetChange.get(mut).get(g1) != false ? 1 : -1) + "\n");
                }
            }
            w1.close();
            w2.close();
        }
    }

    private String val2Color(double pval, int type) {
        double score = Math.min(10.0, -Math.log(pval));
        int v = 255 - (int)Math.round(25.5 * score);
        switch (type) {
            case 1: {
                return "255 " + v + " " + v;
            }
            case -1: {
                return v + " 255 " + v;
            }
        }
        throw new IllegalArgumentException();
    }
}

