/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.cocitation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cbio.causality.cocitation.IHOPSpider;

public class CocitationManager {
    private static final Log log = LogFactory.getLog(CocitationManager.class);
    private String resourceDir;
    private long shelfLife;
    private IHOPSpider ihopSpider;

    public CocitationManager(int cacheLife, String resourceDir) {
        this.setShelfLife(cacheLife);
        this.setResourceDir(resourceDir);
        this.ihopSpider = new IHOPSpider("http://www.ihop-net.org/UniPub/iHOP/");
    }

    public void setShelfLife(long days) {
        this.shelfLife = days * 1000L * 60L * 60L * 24L;
    }

    private void createResourceDir() {
        File file = new File(this.getResourceDir());
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private boolean cacheCocitations(String symbol, Map<String, Integer> map) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.getResourceDir() + File.separator + symbol));
            writer.write("" + System.currentTimeMillis());
            for (String s : map.keySet()) {
                writer.write("\n" + s + "\t" + map.get(s));
            }
            writer.close();
            return true;
        }
        catch (IOException e) {
            log.error("Cannot cache co-citations of gene " + symbol + ".", e);
            return false;
        }
    }

    public Map<String, Integer> getCocitations(String symbol) {
        try {
            if (this.cacheExists(symbol)) {
                Map<String, Integer> map = null;
                long stamp = this.getCacheTimestamp(symbol);
                if (System.currentTimeMillis() - stamp > this.getShelfLife()) {
                    map = this.spiderAndCache(symbol);
                }
                if (map == null) {
                    map = this.readCache(symbol);
                }
                return map;
            }
            return this.spiderAndCache(symbol);
        }
        catch (IOException e) {
            log.error("Error while reading co-citation cache for symbol " + symbol + ".", e);
            return null;
        }
    }

    private Map<String, Integer> readCache(String symbol) throws IOException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        BufferedReader reader = new BufferedReader(new FileReader(this.getCachePath(symbol)));
        reader.readLine();
        String line = reader.readLine();
        while (line != null) {
            String[] token = line.split("\t");
            map.put(token[0], Integer.parseInt(token[1]));
            line = reader.readLine();
        }
        reader.close();
        return map;
    }

    private Map<String, Integer> spiderAndCache(String symbol) {
        Map<String, Integer> map = this.getIhopSpider().parseCocitations(symbol);
        if (map != null) {
            this.cacheCocitations(symbol, map);
        }
        return map;
    }

    protected boolean cacheExists(String symbol) {
        return new File(this.getCachePath(symbol)).exists();
    }

    protected long getCacheTimestamp(String symbol) {
        if (!this.cacheExists(symbol)) {
            return -1L;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.getCachePath(symbol)));
            String line = reader.readLine();
            reader.close();
            return Long.parseLong(line);
        }
        catch (IOException e) {
            log.error("Cannot read timestamp of cache of " + symbol + ".", e);
            return -1L;
        }
    }

    private String getCachePath(String symbol) {
        return this.getResourceDir() + File.separator + symbol;
    }

    protected void clearCache() {
        File dir = new File(this.getResourceDir());
        if (dir.exists()) {
            for (File file : dir.listFiles()) {
                file.delete();
            }
        }
    }

    public String getResourceDir() {
        return this.resourceDir;
    }

    public void setResourceDir(String resourceDir) {
        this.resourceDir = resourceDir;
        this.createResourceDir();
    }

    public long getShelfLife() {
        return this.shelfLife;
    }

    public IHOPSpider getIhopSpider() {
        return this.ihopSpider;
    }

    public void setIhopSpider(IHOPSpider ihopSpider) {
        this.ihopSpider = ihopSpider;
    }
}

