/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.data.portal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.cbio.causality.data.portal.CBioPortalAccessor;
import org.cbio.causality.data.portal.CancerStudy;
import org.cbio.causality.data.portal.CaseList;
import org.cbio.causality.data.portal.GeneticProfile;
import org.cbio.causality.data.portal.ProfileType;
import org.cbio.causality.model.Alteration;
import org.cbio.causality.model.AlterationPack;
import org.cbio.causality.model.Change;

public class DataListerMain {
    private static Random random = new Random();
    private static String[] genes = new String[]{"POU5F1B"};

    public static void main(String[] args) throws IOException {
        GeneticProfile geneticProfile2;
        CBioPortalAccessor cBioPortalAccessor = new CBioPortalAccessor();
        int studyIndex = 120;
        int caseListIndex = 0;
        int[] profileIndex = new int[]{0};
        boolean testDataRetrieval = true;
        int i = 0;
        System.out.println("**");
        System.out.println("All studies: ");
        List<CancerStudy> cancerStudies = cBioPortalAccessor.getCancerStudies();
        for (CancerStudy cancerStudy : cancerStudies) {
            System.out.println(i++ + "\tcancerStudy = " + cancerStudy.getName() + " [" + cancerStudy.getStudyId() + "]");
        }
        System.out.println("**");
        CancerStudy cancerStudy = cancerStudies.get(studyIndex);
        cBioPortalAccessor.setCurrentCancerStudy(cancerStudy);
        System.out.println("Current cancerStudy = " + cBioPortalAccessor.getCurrentCancerStudy().getName() + "\tid = " + cBioPortalAccessor.getCurrentCancerStudy().getStudyId());
        System.out.println("**");
        i = 0;
        System.out.println("Case lists:");
        List<CaseList> caseListsForCurrentStudy = cBioPortalAccessor.getCaseListsForCurrentStudy();
        for (CaseList caseList : caseListsForCurrentStudy) {
            System.out.println(i++ + "\tcaseList = " + caseList.getDescription() + " [" + caseList.getCases().length + "]" + " [" + caseList.getId() + "]");
        }
        cBioPortalAccessor.setCurrentCaseList(caseListsForCurrentStudy.get(caseListIndex));
        System.out.println("**");
        System.out.println("Current case list: " + cBioPortalAccessor.getCurrentCaseList().getDescription() + "\tid = " + cBioPortalAccessor.getCurrentCaseList().getId());
        i = 0;
        System.out.println("**");
        System.out.println("Genetic Profiles for the study:");
        List<GeneticProfile> geneticProfilesForCurrentStudy = cBioPortalAccessor.getGeneticProfilesForCurrentStudy();
        for (GeneticProfile geneticProfile2 : geneticProfilesForCurrentStudy) {
            System.out.println(i++ + "\tgeneticProfile = " + geneticProfile2.getName() + " (" + (Object)((Object)geneticProfile2.getType()) + ")" + " [" + geneticProfile2.getId() + "]");
        }
        ArrayList<GeneticProfile> geneticProfiles = new ArrayList<GeneticProfile>();
        for (int pi : profileIndex) {
            geneticProfiles.add(geneticProfilesForCurrentStudy.get(pi));
        }
        cBioPortalAccessor.setCurrentGeneticProfiles(geneticProfiles);
        System.out.println("**");
        System.out.println("Current genetic profile: ");
        for (GeneticProfile geneticProfile3 : cBioPortalAccessor.getCurrentGeneticProfiles()) {
            System.out.println("\tgeneticProfile = " + geneticProfile3.getName() + " (" + (Object)((Object)geneticProfile3.getType()) + ")\tid = " + geneticProfile3.getId());
        }
        geneticProfile2 = cBioPortalAccessor.getCurrentGeneticProfiles().iterator().next();
        Alteration alteration = ProfileType.convertToAlteration(geneticProfile2.getType());
        Integer numOfCases = cBioPortalAccessor.getCurrentCaseList().getCases().length;
        if (!testDataRetrieval) {
            return;
        }
        System.out.println("**");
        System.out.println("Inferred alterations:\n");
        System.out.println("Gene Name\tStatus\t\tOncoPrint(" + numOfCases + " cases)");
        for (String gene : genes) {
            AlterationPack alterations = cBioPortalAccessor.getAlterations(gene);
            if (alterations == null) continue;
            if (alterations.get(Alteration.ANY) == null) {
                alterations.complete(Alteration.ANY);
            }
            StringBuilder oncoPrint = new StringBuilder();
            Change[] changes = alterations.get(Alteration.ANY);
            assert (numOfCases.intValue() == alterations.getSize());
            for (Change change : changes) {
                if (change.isAltered()) {
                    oncoPrint.append("*");
                    continue;
                }
                if (!change.isAbsent()) {
                    oncoPrint.append(".");
                    continue;
                }
                oncoPrint.append(" ");
            }
            System.out.println("\t" + gene + (gene.length() < 3 ? "  " : "") + "\t" + (alterations.isAltered() ? "altered\t" : "not-altered") + "\t" + oncoPrint);
        }
    }

    private static void printRPPACases() throws IOException {
        CBioPortalAccessor acc = new CBioPortalAccessor();
        List<CancerStudy> cancerStudies = acc.getCancerStudies();
        for (CancerStudy study : cancerStudies) {
            acc.setCurrentCancerStudy(study);
            for (CaseList cl : acc.getCaseListsForCurrentStudy()) {
                if (!cl.getId().contains("rppa")) continue;
                System.out.println(cl + " [" + cl.getCases().length + "]");
            }
        }
    }
}

