/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.data.portal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cbio.causality.data.portal.CBioPortalManager;
import org.cbio.causality.data.portal.CaseList;
import org.cbio.causality.rppa.RPPAData;
import org.cbio.causality.util.ArrayUtil;

public class RPPADataManager {
    private CaseList caseList;
    private Map<String, List<RPPAData>> cache;
    private CBioPortalManager cman;

    public RPPADataManager(CaseList caseList) {
        this.caseList = caseList;
        this.cache = new HashMap<String, List<RPPAData>>();
        this.cman = new CBioPortalManager();
        this.load();
    }

    private void load() {
        Map<String[], String[]> map = this.cman.getRPPAData(this.caseList);
        for (String[] s1 : map.keySet()) {
            String[] s2 = map.get(s1);
            List<String> genes = Arrays.asList(s1[2].split("/"));
            RPPAData data = new RPPAData(s1[0], new double[][]{ArrayUtil.toDouble(s2)}, genes, s1[1].equals("phosphorylation") ? this.parsePhosphoSites(s1[0], genes, s1[3]) : null);
            for (String gene : data.genes) {
                if (!this.cache.containsKey(gene)) {
                    this.cache.put(gene, new ArrayList());
                }
                this.cache.get(gene).add(data);
            }
        }
    }

    private Map<String, List<String>> parsePhosphoSites(String id, List<String> genes, String pSite) {
        ArrayList<String> list = new ArrayList<String>();
        if (id.endsWith(pSite)) {
            list.add(pSite.substring(1));
        } else {
            ArrayList<String> sites = null;
            for (String s : id.split("_")) {
                if (s.contains("-")) {
                    s = s.substring(0, s.indexOf("-"));
                }
                if (s.equals(pSite)) {
                    sites = new ArrayList<String>();
                    sites.add(pSite.substring(1));
                    continue;
                }
                if (sites == null) continue;
                if (s.startsWith("p")) {
                    s = s.substring(1);
                }
                sites.add(s);
            }
            if (sites == null) {
                list.add(pSite.substring(1));
            } else {
                list.addAll(sites);
            }
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String gene : genes) {
            map.put(gene, list);
        }
        return map;
    }

    public List<RPPAData> get(String gene) {
        return this.cache.get(gene);
    }

    public boolean contains(String gene) {
        return this.cache.containsKey(gene);
    }

    public Set<String> getSymbols() {
        return this.cache.keySet();
    }

    public Set<RPPAData> getAllData() {
        HashSet<RPPAData> data = new HashSet<RPPAData>();
        for (List<RPPAData> list : this.cache.values()) {
            data.addAll(list);
        }
        return data;
    }
}

