/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.data.tcgafile;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.math.MathException;
import org.cbio.causality.data.tcgafile.CNAReader;
import org.cbio.causality.data.tcgafile.ExpressionReader;
import org.cbio.causality.data.tcgafile.MutationReader;
import org.cbio.causality.util.ArrayUtil;
import org.cbio.causality.util.Pearson;
import org.cbio.causality.util.StudentsT;
import org.cbio.causality.util.Summary;
import org.cbio.causality.util.TermCounter;

public class SimpleAnalysis {
    private static final String TCGADIR = "/home/ozgun/Documents/TCGA/broad";

    public static void plotExpressions(String gene, String tcgaDir, String outFile) throws IOException {
        File[] files;
        HashSet<String> genes = new HashSet<String>(Arrays.asList(gene));
        ArrayList<double[]> valList = new ArrayList<double[]>();
        ArrayList<String> names = new ArrayList<String>();
        for (File dir : files = SimpleAnalysis.getCaseDirs(tcgaDir)) {
            ExpressionReader er = new ExpressionReader(dir.getPath() + File.separator + "expression.txt", genes);
            Set<String> set = er.getSamples();
            double[] vals = er.getGeneAlterationArray(gene, set.toArray(new String[set.size()]));
            valList.add(vals);
            names.add(dir.getName());
        }
        ArrayUtil.prepareForBoxPlotR(valList, names, outFile);
    }

    public static void plotGeneExpression() throws IOException {
        String tcgaDir = "/home/ozgun/Documents/TCGA/";
        String gene = "NRAS";
        SimpleAnalysis.plotExpressions(gene, TCGADIR, tcgaDir + "/exp-dists/" + gene + ".txt");
    }

    public static void reportCorrelations() throws FileNotFoundException, MathException {
        SimpleAnalysis.reportCorrelations("AGAP2", "CCND1", TCGADIR);
    }

    public static void reportCorrelations(String gene1, String gene2, String tcgaDir) throws FileNotFoundException, MathException {
        System.out.println(gene1 + " and " + gene2);
        HashSet<String> genes = new HashSet<String>(Arrays.asList(gene1, gene2));
        for (File dir : SimpleAnalysis.getCaseDirs(tcgaDir)) {
            MutationReader mr;
            CNAReader cr;
            Object[] readers = SimpleAnalysis.prepareReaders(dir, genes);
            ExpressionReader er = (ExpressionReader)readers[0];
            String[] cases = SimpleAnalysis.getCommonCases(er, cr = (CNAReader)readers[1], mr = (MutationReader)readers[2]);
            if (cases.length < 10) continue;
            Map<String, double[]> expMap = SimpleAnalysis.getUnalteredExpressions(genes, er, cr, mr, cases);
            double corr = Pearson.correlation(expMap.get(gene1), expMap.get(gene2));
            double pval = Pearson.corrPval(expMap.get(gene1), expMap.get(gene2));
            if (!(pval < 0.05)) continue;
            System.out.println(dir.getName() + " = " + corr + "\tpval = " + pval + "\tsss = " + cases.length);
        }
    }

    private static Map<String, double[]> getUnalteredExpressions(Set<String> genes, ExpressionReader er, CNAReader cr, MutationReader mr, String[] samples) {
        HashMap<String, double[]> map = new HashMap<String, double[]>();
        boolean[] b = SimpleAnalysis.getAltered(genes, cr, mr, samples);
        b = ArrayUtil.negate(b);
        for (String gene : genes) {
            double[] exp = er.getGeneAlterationArray(gene, samples);
            exp = ArrayUtil.subset(exp, b);
            map.put(gene, exp);
        }
        return map;
    }

    public static void plotEffectOfAlterationsOnExpression() throws FileNotFoundException {
        SimpleAnalysis.plotEffectOfAlterationsOnExpression("DLEU1", TCGADIR, "TFDP1", "CDK4", "RB1", "CDKN2A");
    }

    public static void plotEffectOfAlterationsOnExpression(String target, String tcgaDir, String ... alteredGenes) throws FileNotFoundException {
        for (File dir : SimpleAnalysis.getCaseDirs(tcgaDir)) {
            SimpleAnalysis.reportExpressionChange(target, dir, alteredGenes);
        }
    }

    public static void plotEffectOfAlterationsOnExpression(String[] targets, String studyDir, String ... alteredGenes) throws FileNotFoundException {
        for (String target : targets) {
            System.out.println("target = " + target);
            File dir = new File(studyDir);
            SimpleAnalysis.reportExpressionChange(target, dir, alteredGenes);
        }
    }

    private static void reportExpressionChange(String target, File dir, String[] alteredGenes) throws FileNotFoundException {
        HashSet<String> genes = new HashSet<String>(Arrays.asList(alteredGenes));
        genes.add(target);
        Object[] readers = SimpleAnalysis.prepareReaders(dir, genes);
        ExpressionReader er = (ExpressionReader)readers[0];
        CNAReader cr = (CNAReader)readers[1];
        MutationReader mr = (MutationReader)readers[2];
        String[] cases = SimpleAnalysis.getCommonCases(er, cr, mr);
        boolean[] b1 = SimpleAnalysis.getAltered(new HashSet<String>(Arrays.asList(alteredGenes)), cr, mr, cases);
        boolean[] b2 = SimpleAnalysis.getAltered(Collections.singleton(target), cr, mr, cases);
        b2 = ArrayUtil.negate(b2);
        boolean[] test = ArrayUtil.getAND(b1, b2);
        boolean[] ctrl = ArrayUtil.getAND(ArrayUtil.negate(b1), b2);
        double[] exp = er.getGeneAlterationArray(target, cases);
        double[] testVals = ArrayUtil.subset(exp, test);
        double[] ctrlVals = ArrayUtil.subset(exp, ctrl);
        double pval = StudentsT.getPValOfMeanDifference(testVals, ctrlVals);
        if (pval < 0.05) {
            System.out.println(dir.getName() + "\tMean diff = " + (Summary.mean(testVals) - Summary.mean(ctrlVals)) + "\tpval = " + pval + "\tss= " + testVals.length + " " + ctrlVals.length);
        }
    }

    public static void compareTwoGeneCNAs() throws FileNotFoundException {
        String gene1 = "MDM2";
        String gene2 = "FRS2";
        final HashMap<String, Integer> cnt = new HashMap<String, Integer>();
        File dir = new File(TCGADIR);
        for (File studyDir : dir.listFiles()) {
            CNAReader cr = new CNAReader(studyDir.getPath() + File.separator + "copynumber.txt", new HashSet<String>(Arrays.asList(gene1, gene2)), false, 2);
            Set<String> sampleSet = cr.getSamples();
            String[] samples = sampleSet.toArray(new String[sampleSet.size()]);
            int[] cna1 = cr.getGeneAlterationArray(gene1, samples);
            int[] cna2 = cr.getGeneAlterationArray(gene2, samples);
            for (int i = 0; i < samples.length; ++i) {
                String s = (cna1[i] < 0 ? "" : " ") + cna1[i] + "\t" + (cna2[i] < 0 ? "" : " ") + cna2[i];
                if (cnt.containsKey(s)) {
                    cnt.put(s, (Integer)cnt.get(s) + 1);
                    continue;
                }
                cnt.put(s, 1);
            }
        }
        ArrayList keys = new ArrayList(cnt.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((Integer)cnt.get(o2)).compareTo((Integer)cnt.get(o1));
            }
        });
        for (String s : keys) {
            System.out.println(s + "\t" + cnt.get(s));
        }
    }

    public static void findBestCorrelatingAlterationsOfExpression(String target, String studyDir, double expThr, boolean lowExp) throws FileNotFoundException {
        Object[] r = SimpleAnalysis.prepareReaders(new File(studyDir), null);
        String[] cases = SimpleAnalysis.getCommonCases(r);
    }

    public static void listMutationTypes() throws FileNotFoundException {
        String gene = "NCOR2";
        String file = TCGADIR + File.separator + "SARC/mutation.maf";
        TermCounter tc = new TermCounter();
        TermCounter t2 = new TermCounter();
        System.out.println("gene = " + gene);
        Scanner sc = new Scanner(new File(file));
        while (sc.hasNextLine()) {
            String id;
            String line = sc.nextLine();
            if (!line.startsWith(gene) || !(id = line.substring(0, line.indexOf("\t"))).equals(gene)) continue;
            String[] token = line.split("\t");
            String type = token[8];
            String ch = token[49];
            if (!type.isEmpty()) {
                tc.addTerm(type);
            }
            if (ch.isEmpty()) continue;
            t2.addTerm(ch);
        }
        tc.print();
        t2.print();
    }

    public static void listAlterationFrequencies() throws FileNotFoundException {
        String gene = "TP53";
        String base = TCGADIR + File.separator + "SARC/";
        MutationReader mr = new MutationReader(base + "mutation.maf");
        CNAReader cr = new CNAReader(base + "copynumber.txt", Collections.singleton(gene));
        Set<String> cases = mr.getSamples();
        cases.retainAll(cr.getSamples());
        String[] samples = cases.toArray(new String[cases.size()]);
        boolean[] mut = mr.getGeneAlterationArray(gene, samples);
        int[] cna = cr.getGeneAlterationArray(gene, samples);
        int mCnt = 0;
        int ampCnt = 0;
        int delCnt = 0;
        int mutOrDel = 0;
        for (int i = 0; i < samples.length; ++i) {
            if (mut[i]) {
                ++mCnt;
            }
            if (cna[i] > 0) {
                ++ampCnt;
            } else if (cna[i] < 0) {
                ++delCnt;
            }
            if (!mut[i] && cna[i] >= 0) continue;
            ++mutOrDel;
        }
        System.out.println("samples = " + samples.length);
        System.out.println("mCnt = " + mCnt);
        System.out.println("ampCnt = " + ampCnt);
        System.out.println("delCnt = " + delCnt);
        System.out.println("mutOrDel = " + mutOrDel);
    }

    private static File[] getCaseDirs(String tcgaDir) {
        File[] files = new File(tcgaDir).listFiles();
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return files;
    }

    private static boolean[] getAltered(Set<String> genes, CNAReader cr, MutationReader mr, String[] samples) {
        boolean[] b = new boolean[samples.length];
        Arrays.fill(b, false);
        for (String gene : genes) {
            int[] cna = cr.getGeneAlterationArray(gene, samples);
            for (int i = 0; i < cna.length; ++i) {
                if (cna[i] == 0) continue;
                b[i] = true;
            }
            boolean[] mut = mr.getGeneAlterationArray(gene, samples);
            for (int i = 0; i < mut.length; ++i) {
                if (!mut[i]) continue;
                b[i] = true;
            }
        }
        return b;
    }

    private static boolean[] getAltered(Set<String> genes, ExpressionReader er, CNAReader cr, MutationReader mr, String[] samples) {
        boolean[] b = new boolean[samples.length];
        Arrays.fill(b, false);
        for (String gene : genes) {
            int[] cna = cr.getExpVerifiedCNA(gene, samples, er.getGeneAlterationArray(gene, samples), 0.05);
            if (cna != null) {
                for (int i = 0; i < cna.length; ++i) {
                    if (cna[i] == 0) continue;
                    b[i] = true;
                }
            }
            boolean[] mut = mr.getGeneAlterationArray(gene, samples);
            for (int i = 0; i < mut.length; ++i) {
                if (!mut[i]) continue;
                b[i] = true;
            }
        }
        return b;
    }

    private static Object[] prepareReaders(File dir, Set<String> genes) throws FileNotFoundException {
        ExpressionReader er = new ExpressionReader(dir.getPath() + File.separator + "expression.txt", genes);
        CNAReader cr = new CNAReader(dir.getPath() + File.separator + "copynumber.txt", genes);
        MutationReader mr = new MutationReader(dir.getPath() + File.separator + "mutation.maf");
        return new Object[]{er, cr, mr};
    }

    private static String[] getCommonCases(Object[] r) {
        return SimpleAnalysis.getCommonCases((ExpressionReader)r[0], (CNAReader)r[1], (MutationReader)r[2]);
    }

    private static String[] getCommonCases(ExpressionReader er, CNAReader cr, MutationReader mr) {
        Set<String> erSet = er.getSamples();
        Set<String> crSet = cr.getSamples();
        Set<String> mrSet = mr.getSamples();
        HashSet<String> sampleSet = new HashSet<String>(erSet);
        sampleSet.retainAll(crSet);
        sampleSet.retainAll(mrSet);
        return sampleSet.toArray(new String[sampleSet.size()]);
    }

    public static void main(String[] args) throws IOException, MathException {
        SimpleAnalysis.compareTwoGeneCNAs();
    }
}

