/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.network;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import org.biopax.paxtools.controller.Cloner;
import org.biopax.paxtools.controller.Completer;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.Xref;
import org.cbio.causality.idmapping.HGNC;
import org.cbio.causality.util.FDR;
import org.cbio.causality.util.FishersExactTest;

public class PCPathway {
    private static Map<String, Set<String>> gene2pathway;
    private static Map<String, Set<String>> pathway2gene;
    private static Map<String, String> pathway2name;
    private static final String FILE = "pcpathway.txt";

    public static Set<String> getPathways(String gene) {
        if (gene2pathway.containsKey(gene)) {
            return gene2pathway.get(gene);
        }
        return Collections.emptySet();
    }

    public static Set<String> getGenes(String pathwayID) {
        if (pathway2gene.containsKey(pathwayID)) {
            return pathway2gene.get(pathwayID);
        }
        return Collections.emptySet();
    }

    public static String getName(String id) {
        return pathway2name.get(id);
    }

    public static String getCoverageStr(String id, Set<String> genes) {
        if (!pathway2gene.containsKey(id)) {
            return null;
        }
        HashSet<String> set = new HashSet<String>(genes);
        set.retainAll((Collection)pathway2gene.get(id));
        return set.size() + "/" + pathway2gene.get(id).size();
    }

    public static Map<String, Double>[] getEnrichmentPvals(Collection<String> genes, Collection<String> background, int minMemberSize) {
        if (background == null && !(background = new HashSet<String>(gene2pathway.keySet())).containsAll(genes)) {
            HashSet<String> set = new HashSet<String>(genes);
            set.removeAll(background);
            genes = new HashSet<String>(genes);
            genes.removeAll(set);
            System.out.println("Removed " + set.size() + " unknown genes: " + set);
            System.out.println("Using " + genes.size() + ": " + genes);
        }
        if (!background.containsAll(genes)) {
            throw new IllegalArgumentException("Background genes have to contain all the selected genes.");
        }
        Map<String, Integer> selectionCnt = PCPathway.count(genes);
        Map<String, Integer> backgroundCnt = PCPathway.count(background);
        HashMap<String, Double> mapP = new HashMap<String, Double>();
        HashMap<String, Double> mapL = new HashMap<String, Double>();
        for (String pathway2 : selectionCnt.keySet()) {
            if (pathway2gene.get(pathway2).size() < minMemberSize) continue;
            double pval = FishersExactTest.calcEnrichmentPval(background.size(), backgroundCnt.get(pathway2), genes.size(), selectionCnt.get(pathway2));
            double limit = FishersExactTest.calcEnrichmentPval(background.size(), backgroundCnt.get(pathway2), genes.size(), Math.min(backgroundCnt.get(pathway2), genes.size()));
            mapP.put(pathway2, pval);
            mapL.put(pathway2, limit);
        }
        return new Map[]{mapP, mapL};
    }

    private static Map<String, Integer> count(Collection<String> genes) {
        HashMap<String, Integer> cnt = new HashMap<String, Integer>();
        for (String pathway2 : pathway2gene.keySet()) {
            HashSet mems = new HashSet(pathway2gene.get(pathway2));
            mems.retainAll(genes);
            if (mems.isEmpty()) continue;
            cnt.put(pathway2, mems.size());
        }
        return cnt;
    }

    public static List<String> getEnrichedPathways(Collection<String> genes, Collection<String> background, double fdrThr) {
        return PCPathway.getEnrichedPathways(genes, background, fdrThr, 3);
    }

    public static List<String> getEnrichedPathways(Collection<String> genes, Collection<String> background, double fdrThr, int memberThreshold) {
        Map<String, Double>[] map = PCPathway.getEnrichmentPvals(genes, background, memberThreshold);
        if (fdrThr < 0.0) {
            fdrThr = FDR.decideBestFDR_BH(map[0], map[1]);
            System.out.println("fdrThr = " + fdrThr);
        }
        return FDR.select(map[0], map[1], fdrThr);
    }

    public static Map<String, Double> getEnrichmentQvals(Collection<String> genes, Collection<String> background, int memberThreshold) {
        Map<String, Double>[] map = PCPathway.getEnrichmentPvals(genes, background, memberThreshold);
        return FDR.getQVals(map[0], map[1]);
    }

    public static void writeEnrichmentResults(Set<String> genes, int memberThreshold, String filename) throws IOException {
        String id;
        final Map[] pvals = PCPathway.getEnrichmentPvals(genes, null, memberThreshold);
        Map<String, Double> qvals = PCPathway.getEnrichmentQvals(genes, null, memberThreshold);
        ArrayList<String> ids = new ArrayList<String>(qvals.keySet());
        Collections.sort(ids, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((Double)pvals[0].get(o1)).compareTo((Double)pvals[0].get(o2));
            }
        });
        BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
        writer.write("# Pathway name: Name of the pathway as given by the original pathway database.\n");
        writer.write("# P-value: Enrichment p-value of the pathway calculated by Fisher's exact test.\n");
        writer.write("# Q-value: Estimated FDR (false discovery rate) if this p-value is used as cutoff threshold.\n");
        writer.write("# Hit size: Number of query genes that overlaps with this pathway.\n");
        writer.write("# Pathway size: Number of genes in this pathway.\n");
        writer.write("# Genes contributed enrichment: Names of query genes that overlaps with this pathway.\n");
        writer.write("Pathway name\tP-value\tQ-value\tHit size\tPathway size\tGenes contributed enrichment");
        Iterator i$ = ids.iterator();
        while (i$.hasNext() && !((Double)pvals[0].get(id = (String)i$.next()) > 0.05)) {
            HashSet<String> g = new HashSet<String>(PCPathway.getGenes(id));
            int allSize = g.size();
            g.retainAll(genes);
            int hitSize = g.size();
            writer.write("\n" + PCPathway.getName(id) + "\t" + pvals[0].get(id) + "\t" + qvals.get(id) + "\t" + hitSize + "\t" + allSize + "\t" + g);
        }
        writer.close();
    }

    public static TreeMap<String, Integer> getSortedPathways(Collection<String> genes) {
        final HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String gene : genes) {
            for (String pathway2 : PCPathway.getPathways(gene)) {
                if (map.containsKey(pathway2)) {
                    map.put(pathway2, (Integer)map.get(pathway2) + 1);
                    continue;
                }
                map.put(pathway2, 1);
            }
        }
        TreeMap<String, Integer> sorted = new TreeMap<String, Integer>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((Integer)map.get(o2)).compareTo((Integer)map.get(o1));
            }
        });
        sorted.putAll(map);
        return sorted;
    }

    public static void main(String[] args) throws IOException {
        PCPathway.prepareResource();
    }

    private static void prepareResource() throws IOException {
        pathway2gene = new HashMap<String, Set<String>>();
        gene2pathway = new HashMap<String, Set<String>>();
        pathway2name = new HashMap<String, String>();
        SimpleIOHandler h = new SimpleIOHandler();
        Model model = h.convertFromOWL(new FileInputStream("/home/babur/Downloads/Pathway Commons.7.Detailed_Process_Data.BIOPAX.owl"));
        for (Pathway pathway2 : model.getObjects(Pathway.class)) {
            String id = pathway2.getUri();
            String name = pathway2.getDisplayName();
            if (name == null || name.isEmpty()) continue;
            pathway2name.put(id, name);
            Model m = PCPathway.excise(model, pathway2);
            Set<String> syms = PCPathway.collectGeneSymbols(m);
            if (syms.size() < 3) continue;
            if (!pathway2gene.containsKey(id)) {
                pathway2gene.put(id, new HashSet());
            }
            for (String sym : syms) {
                if (!gene2pathway.containsKey(sym)) {
                    gene2pathway.put(sym, new HashSet());
                }
                pathway2gene.get(id).add(sym);
                gene2pathway.get(sym).add(id);
            }
        }
        PCPathway.writeResources();
    }

    private static void writeResources() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter("src/main/resources/org/cbio/causality/network/pcpathway.txt"));
        for (String id : pathway2gene.keySet()) {
            if (pathway2gene.get(id).isEmpty() || pathway2name.get(id).contains("$")) continue;
            writer.write(id + "\t" + pathway2name.get(id));
            for (String sym : pathway2gene.get(id)) {
                writer.write("\t" + sym);
            }
            writer.write("\n");
        }
        writer.close();
    }

    private static void readResources() {
        pathway2gene = new HashMap<String, Set<String>>();
        gene2pathway = new HashMap<String, Set<String>>();
        pathway2name = new HashMap<String, String>();
        Scanner sc = new Scanner(PCPathway.class.getResourceAsStream(FILE));
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            String[] token = line.split("\t");
            pathway2name.put(token[0], token[1]);
            if (token.length > 2) {
                pathway2gene.put(token[0], new HashSet<String>(Arrays.asList(token).subList(2, token.length)));
            }
            for (int i = 2; i < token.length; ++i) {
                if (!gene2pathway.containsKey(token[i])) {
                    gene2pathway.put(token[i], new HashSet());
                }
                gene2pathway.get(token[i]).add(token[0]);
            }
        }
    }

    private static Model excise(Model model, Pathway pathway2) {
        Completer c = new Completer(SimpleEditorMap.L3);
        Set<BioPAXElement> objects = c.complete(Collections.singleton(pathway2), model);
        Cloner cln = new Cloner(SimpleEditorMap.L3, BioPAXLevel.L3.getDefaultFactory());
        return cln.clone(model, objects);
    }

    private static Set<String> collectGeneSymbols(Model model) {
        HashSet<String> symbols = new HashSet<String>();
        for (EntityReference er : model.getObjects(EntityReference.class)) {
            for (Xref xref2 : er.getXref()) {
                String s;
                if (xref2.getDb() == null || !xref2.getDb().equalsIgnoreCase("HGNC SYMBOL") || (s = HGNC.getSymbol(xref2.getId())) == null) continue;
                symbols.add(s);
            }
        }
        return symbols;
    }

    static {
        PCPathway.readResources();
    }
}

