/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.network;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Scanner;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.cbio.causality.analysis.Graph;
import org.cbio.causality.idmapping.HGNC;
import org.cbio.causality.network.HPRD;

public class SignaLink {
    private static Graph graphPostTl = new Graph("SignaLink post-translational mod", SIFEnum.CONTROLS_STATE_CHANGE_OF.getTag());
    private static Graph graphTR = new Graph("SignaLink transcriptional regulation", SIFEnum.CONTROLS_EXPRESSION_OF.getTag());

    public static Graph getGraphPostTl() {
        return graphPostTl;
    }

    public static Graph getGraphTR() {
        return graphTR;
    }

    private static void prepare() throws IOException {
        Scanner sc = new Scanner(SignaLink.class.getResourceAsStream("signalink-raw.txt"));
        BufferedWriter writer = new BufferedWriter(new FileWriter("signalink.txt"));
        HashSet<String> existing = new HashSet<String>();
        while (sc.hasNextLine()) {
            String type;
            String line = sc.nextLine();
            String[] token = line.split(";");
            String source = HGNC.getSymbol(token[0]);
            String target = HGNC.getSymbol(token[6]);
            if (source == null || target == null || (type = token[13].toLowerCase()).contains("undirected")) continue;
            boolean tr = type.contains("transcriptional");
            String rel = source + "\t" + target + "\t" + (tr ? "T" : "");
            if (existing.contains(rel)) continue;
            existing.add(rel);
            writer.write(rel + (sc.hasNextLine() ? "\n" : ""));
        }
        writer.close();
    }

    public static void main(String[] args) throws IOException {
        System.out.println(SignaLink.getGraphPostTl().getDownstream("TAF5L"));
    }

    static {
        Scanner sc = new Scanner(HPRD.class.getResourceAsStream("signalink.txt"));
        while (sc.hasNextLine()) {
            boolean tr;
            String line = sc.nextLine();
            String[] token = line.split("\t");
            if (token[0].equals(token[1])) continue;
            token[0] = HGNC.getSymbol(token[0]);
            token[1] = HGNC.getSymbol(token[1]);
            if (token[0] == null || token[1] == null) continue;
            boolean bl = tr = token.length > 2 && token[2].equals("T");
            if (tr) {
                graphTR.putRelation(token[0], token[1], true);
                continue;
            }
            graphPostTl.putRelation(token[0], token[1], true);
        }
    }
}

