/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.network;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.cbio.causality.analysis.Graph;
import org.cbio.causality.analysis.PhosphoGraph;
import org.cbio.causality.network.PathwayCommons;
import org.cbio.causality.signednetwork.SignedType;
import org.cbio.causality.util.BaseDir;
import org.cbio.causality.util.Download;

public class SignedPC
extends PathwayCommons {
    private static final String url = "http://resources.chibe.googlecode.com/hg/SignedPC.sif.gz";
    private static final String tempFile = BaseDir.getDir() + "SignedPC.sif";
    private static final String dir = BaseDir.getDir() + "SignedPC/";

    public static Map<SignedType, Graph> getAllGraphs() {
        HashMap<SignedType, Graph> map = new HashMap<SignedType, Graph>();
        for (SignedType type : SignedType.values()) {
            map.put(type, SignedPC.getGraph(type));
        }
        return map;
    }

    public static Graph getGraph(SIFType ... types) {
        String edgeType = types[0].getTag();
        for (int i = 1; i < types.length; ++i) {
            edgeType = edgeType + "," + types[i].getTag();
        }
        boolean phos = false;
        for (SIFType type : types) {
            if (type != SignedType.PHOSPHORYLATES && type != SignedType.DEPHOSPHORYLATES) continue;
            phos = true;
            break;
        }
        if (SignedPC.fileExists(types)) {
            Graph graph = phos ? new PhosphoGraph("Signed PC", edgeType) : new Graph("Signed PC", edgeType);
            for (SIFType type : types) {
                Scanner sc;
                try {
                    sc = new Scanner(new FileInputStream(dir + type.getTag() + ".txt"));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
                while (sc.hasNextLine()) {
                    String line = sc.nextLine();
                    String[] token = line.split("\t");
                    if (token.length > 2) {
                        if (phos && token.length > 3) {
                            ((PhosphoGraph)graph).putRelation(token[0], token[1], token[2], type.isDirected(), token[3]);
                            continue;
                        }
                        graph.putRelation(token[0], token[1], token[2], type.isDirected());
                        continue;
                    }
                    graph.putRelation(token[0], token[1], type.isDirected());
                }
            }
            return graph;
        }
        return null;
    }

    public static Graph getSingleGraph(SIFType type) {
        return SignedPC.getGraph(type);
    }

    private static boolean fileExists(SIFType[] types) {
        if (!SignedPC.fileExistsJustCheck(types)) {
            if (!new File(tempFile).exists()) {
                Download.downloadAndUncompress(url, tempFile);
            }
            SignedPC.extractData();
        }
        return SignedPC.fileExistsJustCheck(types);
    }

    private static boolean fileExistsJustCheck(SIFType[] types) {
        boolean present = true;
        for (SIFType type : types) {
            if (new File(dir + type.getTag() + ".txt").exists()) continue;
            present = false;
            break;
        }
        return present;
    }

    private static boolean extractData() {
        try {
            Scanner sc = new Scanner(new File(tempFile));
            HashMap<String, BufferedWriter> writers = new HashMap<String, BufferedWriter>();
            new File(dir).mkdirs();
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                String[] token = line.split("\t");
                if (token.length <= 2) continue;
                if (!writers.containsKey(token[1])) {
                    writers.put(token[1], new BufferedWriter(new FileWriter(dir + token[1] + ".txt")));
                }
                ((Writer)writers.get(token[1])).write(token[0] + "\t" + token[2]);
                if (token.length > 3) {
                    ((Writer)writers.get(token[1])).write("\t" + token[3]);
                }
                if (token.length > 4) {
                    ((Writer)writers.get(token[1])).write("\t" + token[4]);
                }
                ((Writer)writers.get(token[1])).write("\n");
            }
            for (Writer writer : writers.values()) {
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void main(String[] args) {
        SignedPC.printNetworkSizes();
    }

    private static void printNetworkSizes() {
        for (SignedType type : SignedType.values()) {
            SignedPC.getGraph(type).printStats();
        }
    }
}

