/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.rppa;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.cbio.causality.rppa.RPPAData;

public class RPPAFileReader {
    public static String[] getHeader(String filename) {
        try {
            Scanner sc = new Scanner(new File(filename));
            String line = sc.nextLine();
            return line.split("\t");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> getNamesOfNumberColumns(String filename) {
        try {
            Scanner sc = new Scanner(new File(filename));
            String[] header = sc.nextLine().split("\t");
            String[] row = sc.nextLine().split("\t");
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < row.length; ++i) {
                try {
                    Double.parseDouble(row[i]);
                    names.add(header[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            return names;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<RPPAData> readAnnotation(String filename, String idname, String symbolname, String psitename, String effectName) {
        try {
            int effectInd;
            ArrayList<RPPAData> datas = new ArrayList<RPPAData>();
            Scanner sc = new Scanner(new File(filename));
            String s = sc.nextLine();
            List<String> cols = Arrays.asList(s.split("\t"));
            int colInd = cols.indexOf(idname);
            int symbolInd = cols.indexOf(symbolname);
            int siteInd = cols.indexOf(psitename);
            int n = effectInd = effectName == null ? -1 : cols.indexOf(effectName);
            while (sc.hasNextLine()) {
                HashMap<String, List<String>> siteMap;
                String[] row = sc.nextLine().split("\t");
                String id = row[colInd];
                String syms = row[symbolInd];
                String sites = row.length > siteInd ? row[siteInd] : "";
                String effect = effectInd >= 0 && row.length > effectInd ? row[effectInd] : null;
                List<String> genes = Arrays.asList(syms.split("\\s+"));
                HashMap<String, List<String>> hashMap = siteMap = sites.isEmpty() ? null : new HashMap<String, List<String>>();
                if (!sites.isEmpty()) {
                    int i;
                    String[] perGene = sites.split("\\s+");
                    for (i = 0; i < perGene.length; ++i) {
                        siteMap.put(genes.get(i), Arrays.asList(perGene[i].split("\\|")));
                    }
                    if (siteMap.size() < genes.size()) {
                        for (i = siteMap.size(); i < genes.size(); ++i) {
                            siteMap.put(genes.get(i), (List<String>)siteMap.get(genes.get(0)));
                        }
                    }
                }
                RPPAData data = new RPPAData(id, null, genes, siteMap);
                if (effect != null) {
                    data.effect = effect.equals("c") ? RPPAData.SiteEffect.COMPLEX : (effect.equals("a") ? RPPAData.SiteEffect.ACTIVATING : (effect.equals("i") ? RPPAData.SiteEffect.INHIBITING : null));
                }
                datas.add(data);
            }
            return datas;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Double>[] readVals(String filename, String idName, String ... colname) {
        try {
            Map[] valMaps = new Map[colname.length];
            for (int i = 0; i < valMaps.length; ++i) {
                valMaps[i] = new HashMap();
            }
            Scanner sc = new Scanner(new File(filename));
            List<String> header = Arrays.asList(sc.nextLine().split("\t"));
            int idInd = header.indexOf(idName);
            int[] valInd = new int[colname.length];
            for (int i = 0; i < colname.length; ++i) {
                valInd[i] = header.indexOf(colname[i]);
            }
            while (sc.hasNextLine()) {
                String[] row = sc.nextLine().split("\t");
                for (int i = 0; i < colname.length; ++i) {
                    double val;
                    try {
                        val = Double.parseDouble(row[valInd[i]]);
                    }
                    catch (NumberFormatException e) {
                        val = Double.NaN;
                    }
                    valMaps[i].put(row[idInd], val);
                }
            }
            return valMaps;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addValues(List<RPPAData> datas, String filename, String idColName, List<String> vals0, List<String> vals1, Double missingVal) {
        Double doubVal;
        int i;
        Map<String, Double>[] v0 = RPPAFileReader.readVals(filename, idColName, vals0.toArray(new String[vals0.size()]));
        Map<String, Double>[] v1 = vals1 == null || vals1.isEmpty() ? null : RPPAFileReader.readVals(filename, idColName, vals1.toArray(new String[vals1.size()]));
        ArrayList<RPPAData> remove = new ArrayList<RPPAData>();
        for (RPPAData data : datas) {
            data.vals = new double[2][];
            data.vals[0] = new double[v0.length];
            for (i = 0; i < v0.length; ++i) {
                doubVal = v0[i].get(data.id);
                if (doubVal != null) {
                    data.vals[0][i] = doubVal;
                    continue;
                }
                if (missingVal == null) {
                    remove.add(data);
                    continue;
                }
                data.vals[0][i] = missingVal;
            }
        }
        datas.removeAll(remove);
        if (v1 != null) {
            for (RPPAData data : datas) {
                data.vals[1] = new double[v1.length];
                for (i = 0; i < v1.length; ++i) {
                    doubVal = v1[i].get(data.id);
                    data.vals[1][i] = doubVal == null ? missingVal : doubVal;
                }
            }
        }
    }

    public static int getPotentialIDColIndex(String[] header) {
        return RPPAFileReader.getPotentialColIndex(header, "id");
    }

    public static int getPotentialSymbolColIndex(String[] header) {
        return RPPAFileReader.getPotentialColIndex(header, "symbol");
    }

    public static int getPotentialSiteColIndex(String[] header) {
        return RPPAFileReader.getPotentialColIndex(header, "site");
    }

    public static int getPotentialEffectColIndex(String[] header) {
        return RPPAFileReader.getPotentialColIndex(header, "effect");
    }

    private static int getPotentialColIndex(String[] header, String find) {
        for (int i = 0; i < header.length; ++i) {
            if (!header[i].toLowerCase().contains(find)) continue;
            return i;
        }
        return -1;
    }
}

