/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.signednetwork;

import java.util.Arrays;
import java.util.List;
import org.biopax.paxtools.pattern.miner.SIFMiner;
import org.biopax.paxtools.pattern.miner.SIFType;

public enum SignedType implements SIFType
{
    PHOSPHORYLATES("First protein positively affects phosphorylation of the second protein.", true, true, new Class[0]),
    DEPHOSPHORYLATES("First protein negatively affects phosphorylation of the second protein.", true, true, new Class[0]),
    UPREGULATES_EXPRESSION("First protein positively affects expression of the second protein.", true, false, new Class[0]),
    DOWNREGULATES_EXPRESSION("First protein negatively affects expression of the second protein.", true, false, new Class[0]);

    private String description;
    private boolean directed;
    private boolean phospho;
    private List<Class<? extends SIFMiner>> miners;

    private SignedType(String description, boolean directed, boolean phospho, Class<? extends SIFMiner> ... miners) {
        this.description = description;
        this.directed = directed;
        this.phospho = phospho;
        this.miners = Arrays.asList(miners);
    }

    @Override
    public String getTag() {
        return this.name().toLowerCase().replaceAll("_", "-");
    }

    @Override
    public boolean isDirected() {
        return this.directed;
    }

    public boolean isPhospho() {
        return this.phospho;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<Class<? extends SIFMiner>> getMiners() {
        return this.miners;
    }

    public static SignedType typeOf(String tag) {
        tag = tag.toUpperCase().replaceAll("-", "_");
        SignedType type = null;
        try {
            type = SignedType.valueOf(tag);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return type;
    }
}

