/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

public class ErrorFunction {
    private static final double TWO_OVER_SQRT_PI = 2.0 / Math.sqrt(Math.PI);
    private static final int terms = 60;
    private static double[] divider = ErrorFunction.getDividers(60);
    private double[] vals;
    private static final double limit = 5.0;
    private static final double step = 0.001;
    private static ErrorFunction instance = new ErrorFunction();

    private ErrorFunction() {
        int n = (int)Math.round(5000.0);
        this.vals = new double[n];
        for (int i = 0; i < n; ++i) {
            this.vals[i] = this.calcError((double)i * 0.001);
        }
    }

    public static double getSignif(double x) {
        return instance.getError(x);
    }

    private double getError(double x) {
        if (x < 0.0) {
            return -this.getError(-x);
        }
        int i = (int)Math.round(x / 0.001);
        if (i < this.vals.length) {
            return this.vals[i];
        }
        return 1.0;
    }

    private double calcError(double x) {
        double x2 = x * x;
        double er = x;
        for (double d : divider) {
            er += (x *= x2) / d;
        }
        if ((er *= TWO_OVER_SQRT_PI) > 1.0) {
            er = 0.9999999999;
        }
        return er;
    }

    private static double[] getDividers(int size) {
        double fact = 1.0;
        double[] div = new double[size];
        for (int i = 1; i <= size; ++i) {
            div[i - 1] = (fact *= (double)(-i)) * (double)(2 * i + 1);
        }
        return div;
    }

    public static void main(String[] args) {
        ErrorFunction ef = new ErrorFunction();
        for (double x = 0.0; x < 10.0; x += 0.1) {
            System.out.println(x + "\t" + ef.getError(x / Math.sqrt(2.0)));
        }
    }
}

