/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.wrapper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.biopax.paxtools.query.wrapperL3.EventWrapper;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.biopax.paxtools.query.wrapperL3.GraphL3;
import org.biopax.paxtools.query.wrapperL3.UbiqueFilter;
import org.cbio.causality.model.AlterationProvider;
import org.cbio.causality.model.Node;
import org.cbio.causality.wrapper.ComplexMember;
import org.cbio.causality.wrapper.ControlWrapper;
import org.cbio.causality.wrapper.ConversionWrapper;
import org.cbio.causality.wrapper.Edge;
import org.cbio.causality.wrapper.PhysicalEntityWrapper;
import org.cbio.causality.wrapper.TemplateReactionWrapper;

public class Graph
extends GraphL3 {
    protected AlterationProvider alterationProvider;
    protected Map<String, ComplexMember> memberMap;
    public static final String ACTIVE_STATE = "Active state ";
    public static final String INACTIVE_STATE = "Inactive state ";
    public static final String ACTIVATING_CONV = "Activating conv ";
    public static final String INACTIVATING_CONV = "Inactivating conv ";
    public static final String IS_TRANSCRIPTION = "Is Transcipription";

    public Graph(Model model) {
        super(model, new Filter[0]);
        this.memberMap = new HashMap<String, ComplexMember>();
        this.configureNetworkToActivity();
    }

    public Graph(Model model, Set<String> ubiqueIDs) {
        super(model, new UbiqueFilter(ubiqueIDs));
        assert (ubiqueIDs != null);
        this.memberMap = new HashMap<String, ComplexMember>();
        this.configureNetworkToActivity();
    }

    @Override
    public Node wrap(Object obj) {
        org.biopax.paxtools.query.model.Node wrap = super.wrap(obj);
        if (wrap == null) {
            return null;
        }
        if (obj instanceof PhysicalEntity) {
            PhysicalEntity pe = (PhysicalEntity)obj;
            return new PhysicalEntityWrapper(pe, this);
        }
        if (obj instanceof Conversion) {
            return new ConversionWrapper((Conversion)obj, this);
        }
        if (obj instanceof TemplateReaction) {
            return new TemplateReactionWrapper((TemplateReaction)obj, this);
        }
        if (obj instanceof Control) {
            return new ControlWrapper((Control)obj, this);
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn("Invalid BioPAX object to wrap as node. Ignoring: " + obj);
        }
        return null;
    }

    public ComplexMember wrapMember(PhysicalEntity pe) {
        return new ComplexMember(pe, this);
    }

    public ComplexMember getMember(PhysicalEntity pe) {
        String key = this.getKey(pe);
        ComplexMember mem = this.memberMap.get(key);
        if (mem == null) {
            mem = this.wrapMember(pe);
            assert (mem != null);
            this.memberMap.put(key, mem);
            mem.init();
        }
        return this.memberMap.get(key);
    }

    public Set<Node> getAllWrappers(PhysicalEntity pe) {
        ComplexMember mem = this.getMember(pe);
        if (mem != null) {
            HashSet<Node> set = new HashSet<Node>();
            set.add(mem);
            set.add((Node)this.getGraphObject(pe));
            return set;
        }
        return Collections.singleton((Node)this.getGraphObject(pe));
    }

    public Set<Node> getForAll(Collection<? extends PhysicalEntity> objects) {
        HashSet<Node> set = new HashSet<Node>();
        for (PhysicalEntity physicalEntity2 : objects) {
            set.add((Node)this.getGraphObject(physicalEntity2));
        }
        return set;
    }

    public AlterationProvider getAlterationProvider() {
        return this.alterationProvider;
    }

    public void setAlterationProvider(AlterationProvider alterationProvider) {
        this.alterationProvider = alterationProvider;
    }

    public Set<Node> getBreadthNodes() {
        HashSet<Node> nodes = new HashSet<Node>();
        for (PhysicalEntity pe : this.model.getObjects(PhysicalEntity.class)) {
            nodes.add((Node)this.getGraphObject(pe));
        }
        return nodes;
    }

    public void configureNetworkToActivity() {
        for (ProteinReference pr : this.model.getObjects(ProteinReference.class)) {
            Edge edge;
            HashSet<PhysicalEntityWrapper> active = new HashSet<PhysicalEntityWrapper>();
            HashSet<PhysicalEntityWrapper> inactive = new HashSet<PhysicalEntityWrapper>();
            HashSet<EventWrapper> activating = new HashSet<EventWrapper>();
            HashSet<EventWrapper> inhibiting = new HashSet<EventWrapper>();
            for (PhysicalEntity physicalEntity2 : this.getRelated(pr, ACTIVE_STATE, PhysicalEntity.class)) {
                active.add((PhysicalEntityWrapper)this.getGraphObject(physicalEntity2));
            }
            for (PhysicalEntity physicalEntity3 : this.getRelated(pr, INACTIVE_STATE, PhysicalEntity.class)) {
                inactive.add((PhysicalEntityWrapper)this.getGraphObject(physicalEntity3));
            }
            for (Conversion conversion2 : this.getRelated(pr, ACTIVATING_CONV, Conversion.class)) {
                activating.add((EventWrapper)this.getGraphObject(conversion2));
            }
            for (Conversion conversion3 : this.getRelated(pr, INACTIVATING_CONV, Conversion.class)) {
                inhibiting.add((EventWrapper)this.getGraphObject(conversion3));
            }
            for (PhysicalEntityWrapper physicalEntityWrapper : active) {
                for (EventWrapper ev : inhibiting) {
                    edge = new Edge((org.biopax.paxtools.query.model.Node)ev, (org.biopax.paxtools.query.model.Node)physicalEntityWrapper, this);
                    edge.setSign(-1);
                }
                for (EventWrapper ev : activating) {
                    edge = new Edge((org.biopax.paxtools.query.model.Node)ev, (org.biopax.paxtools.query.model.Node)physicalEntityWrapper, this);
                    edge.setSign(1);
                }
            }
            for (PhysicalEntityWrapper physicalEntityWrapper : inactive) {
                for (EventWrapper ev : inhibiting) {
                    edge = new Edge((org.biopax.paxtools.query.model.Node)ev, (org.biopax.paxtools.query.model.Node)physicalEntityWrapper, this);
                    edge.setSign(1);
                }
                for (EventWrapper ev : activating) {
                    edge = new Edge((org.biopax.paxtools.query.model.Node)ev, (org.biopax.paxtools.query.model.Node)physicalEntityWrapper, this);
                    edge.setSign(-1);
                }
            }
            HashSet<EventWrapper> reac = new HashSet<EventWrapper>(activating);
            reac.addAll(inhibiting);
            for (EventWrapper ev : reac) {
                ev.initBanned();
                ev.getBanned().addAll(reac);
                ev.getBanned().remove(ev);
            }
        }
    }

    private <T extends BioPAXElement> Set<T> getRelated(ProteinReference pr, String tag, Class<T> c) {
        HashSet<BioPAXElement> set = new HashSet<BioPAXElement>();
        for (String com : pr.getComment()) {
            if (!com.startsWith(tag)) continue;
            String id = com.substring(com.lastIndexOf(" ") + 1);
            BioPAXElement ele = this.model.getByID(id);
            assert (ele != null);
            set.add(ele);
        }
        return set;
    }
}

