/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.wrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.Xref;
import org.cbio.causality.model.AlterationPack;
import org.cbio.causality.model.Node;
import org.cbio.causality.wrapper.ComplexMember;
import org.cbio.causality.wrapper.Graph;

public class PhysicalEntityWrapper
extends org.biopax.paxtools.query.wrapperL3.PhysicalEntityWrapper
implements Node {
    protected List<Xref> xrefs;
    AlterationPack alterations;

    public PhysicalEntityWrapper(PhysicalEntity pe, Graph graph) {
        super(pe, graph);
    }

    @Override
    protected void initLowerEquivalent() {
        super.initLowerEquivalent();
        this.initComplexMemberEqs();
    }

    protected void initComplexMemberEqs() {
        if (this.pe instanceof Complex) {
            for (PhysicalEntity memPE : ((Complex)this.pe).getComponent()) {
                ComplexMember mem = ((Graph)this.graph).getMember(memPE);
                this.lowerEquivalent.add(mem);
            }
        }
    }

    public List<Xref> getXRefs() {
        if (this.xrefs == null) {
            SimplePhysicalEntity spe;
            EntityReference er;
            this.xrefs = new ArrayList<Xref>();
            this.xrefs.addAll(this.pe.getXref());
            if (this.pe instanceof SimplePhysicalEntity && (er = (spe = (SimplePhysicalEntity)this.pe).getEntityReference()) != null) {
                this.xrefs.addAll(er.getXref());
            }
        }
        return this.xrefs;
    }

    @Override
    protected Set<Interaction> getDownstreamInteractions(Collection<Interaction> inters) {
        HashSet<Interaction> set = new HashSet<Interaction>();
        for (Interaction inter : inters) {
            if (!(inter instanceof Control)) continue;
            set.add(inter);
        }
        return set;
    }

    @Override
    public AlterationPack getAlterations() {
        if (this.alterations == null) {
            this.alterations = this.getGraph().getAlterationProvider().getAlterations(this);
        }
        return this.alterations;
    }

    public void setAlterations(AlterationPack pack) {
        this.alterations = pack;
    }

    @Override
    public Graph getGraph() {
        return (Graph)super.getGraph();
    }

    @Override
    public String toString() {
        return this.pe.getDisplayName();
    }
}

