/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.mapping;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class ResourceTraversal {
    private int depth;
    private int flags;
    private IResource[] resources;

    public ResourceTraversal(IResource[] resources, int depth) {
        this(resources, depth, 0);
    }

    public ResourceTraversal(IResource[] resources, int depth, int flags) {
        this.resources = resources;
        this.depth = depth;
        this.flags = flags;
    }

    public void accept(IResourceVisitor visitor) throws CoreException {
        int i = 0;
        while (i < this.resources.length) {
            IResource resource = this.resources[i];
            resource.accept(visitor, this.depth, this.flags);
            ++i;
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public int getFlags() {
        return this.flags;
    }

    public IResource[] getResources() {
        return this.resources;
    }
}

