/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemeTabPaneDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class TabFolderDrawData
extends DrawData {
    public int tabsWidth;
    public int tabsHeight;
    public Rectangle tabsArea;
    public int selectedX;
    public int selectedWidth;
    public int spacing;

    public TabFolderDrawData() {
        this.state = new int[1];
        if (SWT.getPlatform().equals("gtk")) {
            this.spacing = -2;
        }
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        int[] nArray = new int[1];
        OS.GetThemeMetric(10, nArray);
        int n = nArray[0];
        OS.GetThemeMetric(11, nArray);
        int n2 = nArray[0];
        CGRect cGRect = new CGRect();
        cGRect.x = rectangle.x;
        cGRect.y = rectangle.y;
        cGRect.width = rectangle.width;
        cGRect.height = rectangle.height;
        if ((this.style & 0x400) != 0) {
            cGRect.height -= (float)(n / 2);
        } else {
            cGRect.y += (float)((n2 + n) / 2);
            cGRect.height -= (float)((n2 + n) / 2);
        }
        HIThemeTabPaneDrawInfo hIThemeTabPaneDrawInfo = this.getInfo();
        OS.HIThemeDrawTabPane(cGRect, hIThemeTabPaneDrawInfo, gC.handle, 0);
        if (this.tabsArea != null) {
            this.tabsArea.x = rectangle.x + n2 + (rectangle.width - n2 * 2 - this.tabsWidth) / 2;
            this.tabsArea.y = rectangle.y;
            this.tabsArea.width = rectangle.width - n2 * 2;
            this.tabsArea.height = n;
            this.tabsArea.y = (this.style & 0x400) != 0 ? (this.tabsArea.y += rectangle.height - n) : (this.tabsArea.y += n2 / 2);
        }
    }

    HIThemeTabPaneDrawInfo getInfo() {
        int n = this.state[0];
        HIThemeTabPaneDrawInfo hIThemeTabPaneDrawInfo = new HIThemeTabPaneDrawInfo();
        hIThemeTabPaneDrawInfo.version = 1;
        hIThemeTabPaneDrawInfo.direction = 0;
        if ((this.style & 0x400) != 0) {
            hIThemeTabPaneDrawInfo.direction = 1;
        }
        if ((this.style & 0x80) != 0) {
            hIThemeTabPaneDrawInfo.direction = 0;
        }
        hIThemeTabPaneDrawInfo.state = (n & 8) != 0 ? 2 : ((n & 0x10) != 0 ? ((n & 0x20) == 0 ? 1 : 7) : ((n & 0x20) == 0 ? 0 : 8));
        return hIThemeTabPaneDrawInfo;
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (!rectangle.contains(point)) {
            return -1;
        }
        return 0;
    }
}

