/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.ControlButtonContentInfo;
import org.eclipse.swt.internal.carbon.ControlFontStyleRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.carbon.ThemeButtonDrawInfo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    String text = "";
    Image image;
    int cIcon;
    boolean isImage;
    boolean grayed;

    public Button(Composite composite, int n) {
        super(composite, Button.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        if (((n = Button.checkBits(n, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(n, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((n & 0x30) != 0) {
            return Button.checkBits(n, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((n & 4) != 0) {
            return Button.checkBits(n |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return n;
    }

    void click() {
        this.postEvent(13);
    }

    int callPaintEventHandler(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int[] nArray = null;
        if ((this.style & 4) != 0) {
            n6 = 0;
            if (OS.VERSION < 4176) {
                n6 = (this.style & 0x80) != 0 ? 1 : 0;
            } else {
                int n7 = n6 = (this.style & 0x80) == 0 && (this.style & 0x4000) == 0 ? 0 : 1;
            }
            if (n6 != 0) {
                nArray = new int[1];
                OS.GetEventParameter(n4, 1668183160, 1668183160, null, 4, null, nArray);
                OS.CGContextSaveGState(nArray[0]);
                CGRect cGRect = new CGRect();
                OS.HIViewGetBounds(this.handle, cGRect);
                OS.CGContextRotateCTM(nArray[0], (float)Compatibility.PI);
                OS.CGContextTranslateCTM(nArray[0], -cGRect.width, -cGRect.height);
            }
        }
        n6 = super.callPaintEventHandler(n, n2, n3, n4, n5);
        if (nArray != null) {
            OS.CGContextRestoreGState(nArray[0]);
        }
        return n6;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Object object;
        Object object2;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] nArray = new int[1];
            OS.GetThemeMetric(25, nArray);
            int n3 = nArray[0];
            int n4 = nArray[0];
            if (n != -1) {
                n3 = n;
            }
            if (n2 != -1) {
                n4 = n2;
            }
            return new Point(n3, n4);
        }
        int n5 = 0;
        int n6 = 0;
        if (this.isImage && this.image != null) {
            object2 = this.image.getBounds();
            n5 = object2.width;
            n6 = object2.height;
        }
        object2 = new int[1];
        OS.CopyControlTitleAsCFString(this.handle, object2);
        if (object2[0] != 0) {
            object = this.textExtent(object2[0], 0);
            n5 += ((Point)object).x;
            n6 = Math.max(n6, ((Point)object).y);
            OS.CFRelease(object2[0]);
            if (this.image != null && this.isImage) {
                n5 += 3;
            }
        } else if (this.image == null) {
            n5 = 64;
            n6 = 64;
        }
        if ((this.style & 0x30) != 0) {
            object = new int[1];
            int n7 = (this.style & 0x20) != 0 ? 50 : 52;
            OS.GetThemeMetric(n7, (int[])object);
            n5 += object[0] + 3;
            n6 = Math.max((int)object[0], n6);
        } else if ((this.style & 0x800000) != 0 || (this.style & 2) != 0) {
            n5 += 8;
            n6 += 8;
        } else {
            n5 += 28;
            object = new int[1];
            OS.GetThemeMetric(19, (int[])object);
            n6 = Math.max(n6, (int)object[0]);
        }
        object = this.getInset();
        n5 += ((Rect)object).left + ((Rect)object).right;
        n6 += ((Rect)object).top + ((Rect)object).bottom;
        n5 = Math.max(20, n5);
        if (n != -1) {
            n5 = n;
        }
        if (n2 != -1) {
            n6 = n2;
        }
        return new Point(n5, n6);
    }

    void createHandle() {
        if ((this.style & 8) == 0) {
            this.state |= 0x800;
        }
        int[] nArray = new int[1];
        int n = OS.GetControlOwner(this.parent.handle);
        if ((this.style & 4) != 0) {
            int n2 = 0;
            if ((this.style & 0x80) != 0) {
                n2 = 1;
            }
            if ((this.style & 0x400) != 0) {
                n2 = 1;
            }
            if ((this.style & 0x4000) != 0) {
                n2 = 2;
            }
            OS.CreateBevelButtonControl(n, null, 0, (short)0, (short)0, 0, (short)0, (short)0, (short)0, nArray);
            if (nArray[0] == 0) {
                this.error(2);
            }
            this.handle = nArray[0];
            OS.SetControlData(this.handle, 0, 1650811499, 2, new short[]{6});
            OS.SetControl32BitMaximum(this.handle, 2);
            OS.SetControl32BitValue(this.handle, n2);
        }
        if ((this.style & 0x20) != 0) {
            OS.CreateBevelButtonControl(n, null, 0, (short)0, (short)256, 0, (short)0, (short)0, (short)0, nArray);
            if (nArray[0] == 0) {
                this.error(2);
            }
            this.handle = nArray[0];
            OS.SetControlData(this.handle, 0, 1650811499, 2, new short[]{1});
        }
        if ((this.style & 0x10) != 0) {
            OS.CreateBevelButtonControl(n, null, 0, (short)0, (short)256, 0, (short)0, (short)0, (short)0, nArray);
            if (nArray[0] == 0) {
                this.error(2);
            }
            this.handle = nArray[0];
            OS.SetControlData(this.handle, 0, 1650811499, 2, new short[]{2});
        }
        if ((this.style & 2) != 0) {
            OS.CreateBevelButtonControl(n, null, 0, (short)1, (short)256, 0, (short)0, (short)0, (short)0, nArray);
            if (nArray[0] == 0) {
                this.error(2);
            }
            this.handle = nArray[0];
            if ((this.style & 0x800000) == 0) {
                OS.SetControlData(this.handle, 0, 1650811499, 2, new short[]{15});
            }
        }
        if ((this.style & 8) != 0) {
            if ((this.style & 0x800000) != 0) {
                OS.CreateBevelButtonControl(n, null, 0, (short)2, (short)0, 0, (short)0, (short)0, (short)0, nArray);
            } else {
                OS.CreatePushButtonControl(n, null, 0, nArray);
            }
            if (nArray[0] == 0) {
                this.error(2);
            }
            this.handle = nArray[0];
            if ((this.style & 0x800000) == 0) {
                OS.SetControlData(this.handle, 0, 1650811499, 2, new short[1]);
            }
        }
        ControlFontStyleRec controlFontStyleRec = new ControlFontStyleRec();
        controlFontStyleRec.flags = (short)128;
        controlFontStyleRec.font = (short)this.defaultThemeFont();
        OS.SetControlFontStyle(this.handle, controlFontStyleRec);
        if ((this.style & 4) != 0) {
            return;
        }
        this._setAlignment(this.style & 0x1024000);
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 105;
    }

    void drawWidget(int n, int n2, int n3, int n4, int n5) {
        if (OS.VERSION < 4160 && this.isImage && this.image != null && (this.style & 8) != 0 && (this.style & 0x800000) == 0) {
            Rect rect = new Rect();
            Rect rect2 = new Rect();
            OS.GetControlBounds(this.handle, rect);
            ThemeButtonDrawInfo themeButtonDrawInfo = new ThemeButtonDrawInfo();
            themeButtonDrawInfo.state = OS.IsControlEnabled(this.handle) ? (OS.IsControlActive(this.handle) ? 1 : 0) : (OS.IsControlActive(this.handle) ? 7 : 8);
            themeButtonDrawInfo.adornment = 1;
            OS.GetThemeButtonContentBounds(rect, 0, themeButtonDrawInfo, rect2);
            int n6 = this.image == null ? 0 : OS.CGImageGetWidth(this.image.handle);
            int n7 = this.image == null ? 0 : OS.CGImageGetHeight(this.image.handle);
            int n8 = (rect.right - rect.left - n6) / 2;
            int n9 = (rect2.bottom - rect2.top - n7) / 2;
            GCData gCData = new GCData();
            gCData.paintEvent = n5;
            gCData.visibleRgn = n4;
            GC gC = GC.carbon_new(this, gCData);
            gC.drawImage(this.image, n8, n9);
            gC.dispose();
        }
        super.drawWidget(n, n2, n3, n4, n5);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return OS.GetControl32BitValue(this.handle) != 0;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    Rect getInset() {
        if ((this.style & 8) == 0) {
            return super.getInset();
        }
        return this.display.buttonInset;
    }

    boolean isDescribedByLabel() {
        return false;
    }

    int kEventAccessibleGetNamedAttribute(int n, int n2, int n3) {
        int n4 = -9874;
        if ((this.style & 0x10) != 0) {
            int[] nArray = new int[1];
            OS.GetEventParameter(n2, 1635020397, 1667658612, null, 4, null, nArray);
            int n5 = 0;
            if (nArray[0] != 0) {
                n5 = OS.CFStringGetLength(nArray[0]);
            }
            char[] cArray = new char[n5];
            CFRange cFRange = new CFRange();
            cFRange.length = n5;
            OS.CFStringGetCharacters(nArray[0], cFRange, cArray);
            String string = new String(cArray);
            if (string.equals("AXRole") || string.equals("AXRoleDescription")) {
                String string2 = "AXRadioButton";
                cArray = new char[string2.length()];
                string2.getChars(0, cArray.length, cArray, 0);
                nArray[0] = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                if (nArray[0] != 0) {
                    if (string.equals("AXRole")) {
                        OS.SetEventParameter(n2, 1635022444, 1667658612, 4, nArray);
                    } else {
                        int n6 = OS.HICopyAccessibilityRoleDescription(nArray[0], 0);
                        OS.SetEventParameter(n2, 1635022444, 1667658612, 4, new int[]{n6});
                        OS.CFRelease(n6);
                    }
                    OS.CFRelease(nArray[0]);
                    n4 = 0;
                }
            }
        }
        if (this.accessible != null) {
            n4 = this.accessible.internal_kEventAccessibleGetNamedAttribute(n, n2, n4);
        }
        return n4;
    }

    int kEventControlHit(int n, int n2, int n3) {
        int n4 = super.kEventControlHit(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) == 0) {
                this.selectRadio();
            }
        } else if ((this.style & 0x20) != 0 && this.grayed) {
            switch (OS.GetControl32BitValue(this.handle)) {
                case 0: {
                    OS.SetControl32BitMaximum(this.handle, 2);
                    OS.SetControl32BitValue(this.handle, 2);
                    break;
                }
                case 1: 
                case 2: {
                    OS.SetControl32BitMaximum(this.handle, 0);
                    OS.SetControl32BitValue(this.handle, 0);
                }
            }
        }
        this.postEvent(13);
        return -9874;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
            this.cIcon = 0;
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectRadio() {
        Control[] controlArray = this.parent._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control2 = controlArray[n];
            if (this != control2) {
                control2.setRadioSelection(false);
            }
            ++n;
        }
        this.setSelection(true);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        this._setAlignment(n);
        this.redraw();
    }

    void _setAlignment(int n) {
        boolean bl;
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= n & 0x24480;
            int n2 = 0;
            if ((this.style & 0x80) != 0) {
                n2 = 1;
            }
            if ((this.style & 0x400) != 0) {
                n2 = 1;
            }
            if ((this.style & 0x4000) != 0) {
                n2 = 2;
            }
            OS.SetControl32BitValue(this.handle, n2);
            return;
        }
        if ((n & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        boolean bl2 = bl = this.text != null && this.text.length() > 0 && this.image != null;
        if (bl) {
            if ((this.style & 0x30) != 0) {
                n = 16384;
            }
            if ((this.style & 0xA) != 0) {
                n = 0x1000000;
            }
        }
        int n3 = 0;
        int n4 = 0;
        if ((n & 0x4000) != 0) {
            n3 = -2;
            n4 = 1;
        }
        if ((n & 0x1000000) != 0) {
            n3 = 1;
            n4 = 0;
        }
        if ((n & 0x20000) != 0) {
            n3 = -1;
            n4 = 2;
        }
        OS.SetControlData(this.handle, 0, 1952541801, 2, new short[]{(short)n3});
        OS.SetControlData(this.handle, 0, 1734437993, 2, new short[]{(short)n4});
        if (bl) {
            OS.SetControlData(this.handle, 0, 1953524835, 2, new short[]{1});
        }
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        if (bl2 && (this.style & 4) == 0) {
            n4 = Math.max(20, n4);
        }
        return super.setBounds(n, n2, n3, n4, bl, bl2, bl3);
    }

    void setDefault(boolean bl) {
        if ((this.style & 8) == 0) {
            return;
        }
        int n = OS.GetControlOwner(this.handle);
        OS.SetWindowDefaultButton(n, bl ? this.handle : 0);
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        this.grayed = bl;
        if (bl) {
            if (OS.GetControl32BitValue(this.handle) != 0) {
                OS.SetControl32BitMaximum(this.handle, 2);
                OS.SetControl32BitValue(this.handle, 2);
            } else {
                OS.SetControl32BitMaximum(this.handle, 0);
                OS.SetControl32BitValue(this.handle, 0);
            }
        } else {
            if (OS.GetControl32BitValue(this.handle) != 0) {
                OS.SetControl32BitValue(this.handle, 1);
            }
            OS.SetControl32BitMaximum(this.handle, 1);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
            this.cIcon = 0;
        }
        this.image = image;
        this.isImage = true;
        if (OS.VERSION < 4160 && (this.style & 8) != 0 && (this.style & 0x800000) == 0) {
            if (image == null) {
                this.setText(this.text);
                return;
            }
            if (this.text.length() > 0) {
                int n = OS.CFStringCreateWithCharacters(0, null, 0);
                if (n == 0) {
                    this.error(13);
                }
                OS.SetControlTitleWithCFString(this.handle, n);
                OS.CFRelease(n);
            }
        }
        ControlButtonContentInfo controlButtonContentInfo = new ControlButtonContentInfo();
        if (image != null) {
            if (OS.VERSION < 4160) {
                this.cIcon = this.createCIcon(image);
                controlButtonContentInfo.contentType = (short)130;
                controlButtonContentInfo.iconRef = this.cIcon;
            } else {
                controlButtonContentInfo.contentType = (short)134;
                controlButtonContentInfo.iconRef = image.handle;
            }
        } else {
            controlButtonContentInfo.contentType = 0;
        }
        OS.SetBevelButtonContentInfo(this.handle, controlButtonContentInfo);
        this._setAlignment(this.style);
        this.redraw();
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        if ((this.style & 0x20) != 0) {
            if (this.grayed) {
                if (bl) {
                    OS.SetControl32BitMaximum(this.handle, 2);
                    OS.SetControl32BitValue(this.handle, 2);
                } else {
                    OS.SetControl32BitMaximum(this.handle, 0);
                    OS.SetControl32BitValue(this.handle, 0);
                }
                return;
            }
            OS.SetControl32BitMaximum(this.handle, 1);
        }
        OS.SetControl32BitValue(this.handle, bl ? 1 : 0);
    }

    public void setText(String string) {
        Object object;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        if (OS.VERSION < 4160 && (this.style & 8) != 0 && (this.style & 0x800000) == 0) {
            if (this.isImage) {
                object = new ControlButtonContentInfo();
                object.contentType = 0;
                OS.SetBevelButtonContentInfo(this.handle, (ControlButtonContentInfo)object);
            }
            this.isImage = false;
        }
        object = new char[this.text.length()];
        this.text.getChars(0, ((char[])object).length, (char[])object, 0);
        int n = this.fixMnemonic((char[])object);
        int n2 = OS.CFStringCreateWithCharacters(0, object, n);
        if (n2 == 0) {
            this.error(13);
        }
        OS.SetControlTitleWithCFString(this.handle, n2);
        OS.CFRelease(n2);
        this._setAlignment(this.style);
        this.redraw();
    }

    int traversalCode(int n, int n2) {
        int n3 = super.traversalCode(n, n2);
        if ((this.style & 4) != 0) {
            n3 &= 0xFFFFFFE7;
        }
        if ((this.style & 0x10) != 0) {
            n3 |= 0x60;
        }
        return n3;
    }
}

